--TEST--
mhash_keygen_s2k() test
--SKIPIF--
<?php
	include "skip.inc";
?>
--FILE--
<?php

$supported_hash_al = array(
"MHASH_MD5"       => "\x15N24zPF\x06栔\x0CTyzcght^W\x09-sA7Y:\x10wݲxdqS^҃&U,: aǙz\x06\x1CS\x01",
"MHASH_SHA1"      => "1\\p\x06\x1D\x07E]S\x0B\x08\x0Caf\\\x1A\x01\x10T#\$2\x06xc\x0A=\x16\"IJ\x0E'NΚԽn\x08J3\x15<+H\x13\x1D0[\x00[Y\x12qء\x19KmI",
"MHASH_HAVAL256"  => "G\x00NPw\x0CH6Wل+,\x1C\x0DgdZU\x07)oAi[NadT\x17\x1F2ZU46}IYb,C\x17\x1Au{[x",
"MHASH_HAVAL224"  => "\\J=Z\x08\x08y8ha\x0Apg|yܫq\x19\x1E\x06)
˼lǌG\x0CB@kwºQv52OP-05\x00L	m`G-2I",
"MHASH_HAVAL192"  => "\"q&\x02<.A\x07/\x1E2d\x17\x1C2Xv\x0Bpű%\x03\x16(C;+\x08pz8\x12\x15\x13N\x08udd)qهv_MINxLtǇ",
"MHASH_HAVAL160"  => "\x07dn6GXm\x06\x1E\x00η#5M\"mi\x1D1\$\x0E|X<O)Y;=ʰy.`\"`\x02ٴB	ԯҵk>G\x19\x17~\x0D~",
"MHASH_RIPEMD160" => "Fx\x0D5\x02\x0a\x1D[\x19gDXgwܡD&bjB7]G[\x14G`^\x1B\x08K\x11\x173C-AB%\x04K\x03??K",
"MHASH_GOST"      => "Di~C=wƂ\x17B\x15}sM\x01d|\x014hY\"\x0AI*b@фxc@sިyN%d\x09FD\x0a\x12\x12P\x0F}E~:pO\x0DpwR{\x19M",
"MHASH_TIGER"     => "g{\nG&/3d#7`2UBQ/y)X#k'hn/Ep*M1 VKyO`	M6|\"",
"MHASH_CRC32"     => "H@&_YoQ1[Fq\"\x08fV8\x08EE<M:Ⱥrk*Hu/}h3iWJ?vu
i=W\"",
"MHASH_CRC32B"    => "le>}*]Fכ6\x13bCˏ.	I\x0FjΥ0\x0D\x1F<.Qy疾tixb\$}\x0Bȴ	ϬȌDDK\x131uL6`ɏ|Ec\x04",
);

foreach ($supported_hash_al as $hash=>$wanted) {
	$passwd = str_repeat($hash, 10);
	$salt = str_repeat($hash, 2);
	$result = mhash_keygen_s2k(constant($hash), $passwd, $salt, 100);
	if (!strcmp($result, $wanted)) {
		echo "$hash\nok\n";
	} else {
		echo "$hash: ";
		var_dump(bin2hex($wanted));
		echo "$hash: ";
		var_dump(bin2hex($result));
	}
	echo "\n";
}
?>
--EXPECT--
MHASH_MD5
ok

MHASH_SHA1
ok

MHASH_HAVAL256
ok

MHASH_HAVAL224
ok

MHASH_HAVAL192
ok

MHASH_HAVAL160
ok

MHASH_RIPEMD160
ok

MHASH_GOST
ok

MHASH_TIGER
ok

MHASH_CRC32
ok

MHASH_CRC32B
ok
