# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementDataWarehouseUserActivitiesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_warehouse_user_activities_list_by_database(self, resource_group):
        response = self.client.data_warehouse_user_activities.list_by_database(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_data_warehouse_user_activities_get(self, resource_group):
        response = await self.client.data_warehouse_user_activities.get(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            data_warehouse_user_activity_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...
