#ifndef DDK750_MODE_H__
#define DDK750_MODE_H__

#include "ddk750_chip.h"

typedef enum _spolarity_t {
	POS = 0, /* positive */
	NEG, /* negative */
}
spolarity_t;


typedef struct _mode_parameter_t {
	/* Horizontal timing. */
	unsigned long horizontal_total;
	unsigned long horizontal_display_end;
	unsigned long horizontal_sync_start;
	unsigned long horizontal_sync_width;
	spolarity_t horizontal_sync_polarity;

	/* Vertical timing. */
	unsigned long vertical_total;
	unsigned long vertical_display_end;
	unsigned long vertical_sync_start;
	unsigned long vertical_sync_height;
	spolarity_t vertical_sync_polarity;

	/* Refresh timing. */
	unsigned long pixel_clock;
	unsigned long horizontal_frequency;
	unsigned long vertical_frequency;

	/* Clock Phase. This clock phase only applies to Panel. */
	spolarity_t clock_phase_polarity;
}
mode_parameter_t;

int ddk750_setModeTiming(mode_parameter_t *, clock_type_t);


#endif
