C     *******************************
      DOUBLE PRECISION FUNCTION DRAND(SEED)
C     *******************************
C
C
C     DOUBLE  PRECISION  FUNCTION  DRAND RETURNS PSEUDO RANDOM NUMBERS,
C     HOMOGENEOUSLY  DISTRIBUTED  IN  THE INTEVAL [0,1].  IT  USES  THE
C     LINEAR CONGRUENCE METHOD.  THE  PERIOD OF THE GENERATOR IS 2**23.
C     IF SEED IS NOT EQUAL TO ZERO, SEED IS USED  AS  A NEW START VALUE
C     FOR THE ALGORITHM; OTHERWISE DRAND RETURNS THE NEXT RANDOM NUMBER
C     OF THE SEQUENCE. THE  SPECTRAL  PROPERTIES  OF THE GENERATOR HAVE
C     NOT BEEN TESTED.
C
C
C     CALLS DBLE, MOD
C
C
C     LATEST REVISION - JULY 12, 1989; E.KEHL
C
C
      INTEGER SEED,A,B,M,X
C
      DOUBLE PRECISION NORM
C
      SAVE X
      DATA X/0/
C
      DATA NORM/ 0.83886070000000000E+07 /
      DATA M/ 8388608 /
C
      DATA A,B/129,1/
C
C
      IF( SEED .LT. 0 ) SEED = - SEED
      IF( SEED .NE. 0 ) X = SEED
      IF( SEED .GT. M ) THEN
          SEED = MOD(SEED,M) + 1
          X    = SEED
      ENDIF
C
      IC = 0
   10 X = MOD( A * X + B , M )
C
      DRAND = DBLE(X) / NORM

      IF( DRAND .GE. 1.D0 .OR. DRAND .LE. 0.D0 ) THEN
          IC = IC + 1
          IF( IC .GT. 1 ) THEN
              PRINT *,'ERROR IN DRAND'
              STOP
          ENDIF
          GOTO 10
      ENDIF
C
      RETURN
      END
