#include <stdio.h>
#include <string.h>

#include <bn.h>
#include <dsa.h>
#include <dh.h>

BIGNUM *pgp2BN5(unsigned char **buf, unsigned int decrypt);

extern FILE *kring;

extern unsigned long long nkidul;
extern unsigned char xbp[3];
void donewkeyid(unsigned char *, int);

FILE *setkeyring5(char *file);
void setkeyring5_fp(FILE * newkr);
int getkey5(DH **, DSA **, unsigned char *, unsigned long long *);

int sigmak5(void *, FILE *, FILE *, unsigned long long,
            unsigned int, unsigned int, unsigned int);
int sigchk5(FILE * chkfile, FILE * sigfile);

int pkeenc5(unsigned long long, unsigned char *, unsigned char *,
            unsigned int, unsigned int);
int pkedec5(unsigned char *, unsigned char *);

void cnvenc5(FILE * inf, FILE * outf, unsigned char *, unsigned int);
int cnvdec5(FILE * inf, FILE * outf, unsigned char *keybuf, unsigned int cy);
void keyout5(FILE *, FILE *, DH *, DSA *, unsigned char *, char *);

int sigchk5x(unsigned char *, int, char *, int, unsigned long long);

int checkdsa(BIGNUM * r, BIGNUM * u1, DSA *, unsigned char *, unsigned int);
int checkelg(BIGNUM * a, BIGNUM * b, DH *, unsigned char *, unsigned int);

/*------------*/
/* hashes */

#define MAXHASH 4
extern void hashinit(int ha, void *ctx);
extern void hashupdate(int ha, void *ctx, unsigned char *, unsigned int);
extern void hashfinal(int ha, unsigned char *buf, void *ctx);
extern unsigned int hashlen[];
extern unsigned int hashDERlen[];
extern unsigned char hashDER[][64];

#ifdef RSAKEY
#include <rsa.h>
int getkey2(RSA **, char *, unsigned char *, unsigned long long *);
int checkrsa(BIGNUM * a, RSA *, unsigned char *, unsigned int);
#endif

void cfbinit(unsigned char *key, unsigned char *iv0, int cipher);
void docfb(unsigned char *buf, int len, int enc);
void cfbreset(unsigned char *);
