#!/bin/sh
export PGPPATH=.

echo ========== Generating key:
#needs existing pubring.pkr with good parameters in the first key.
#I could use newkeygen, but it takes a while...

if [ -s pubring.pkr ] ; then
  ./new5key -K 0 -k 0 -r pubring.pkr -u "Test Key" #-p testpass
else
  ./new5key -g 768 -u "Test Key" #-p testpass
fi

#this probably should be a cat, but...
mv pubnew.pkr pubring.pkr
mv secnew.skr secring.skr

#fix pubring to allow encryption
./lookup5 -x -m Test | ./pgp5sign -t 24 -p testpass >>pubring.pkr
echo -ne "\260\001\147" >>pubring.pkr
#strictly, you also need to use pgpk -s to sign the DSS key on the pubring

pgpk -l

rm -f pubring.pgp secring.pgp
../minipgp/keygen -n 512 >testfsec.pgp 2>testfpub.pgp
pgp -kaf <testfsec.pgp +batchmode 2>/dev/null >/dev/null
pgp -kaf <testfpub.pgp +batchmode 2>/dev/null >/dev/null
../minipgp/pullkey 0 2>testfpb2.pgp | \
  ../minipgp/minipgp -t 16 -u 0 >testfile.sgn
cat testfpb2.pgp testfile.sgn >testfile.pgp
pgp -ka testfile.pgp +batchmode 2>/dev/null | grep "/.*Unknown"
rm -f testfsec.pgp testfpub.pgp pubring.bak secring.bak

../minipgp/pullkey 0 2>testfpb2.pgp | \
  ./pgp5sign -t 24 -p testpass >testfile.sgn
cat testfpb2.pgp testfile.sgn >testfile.pgp

pgpk -a testfile.pgp
pgpk -a secring.pgp

rm -f testfpb2.pgp testfile.sgn testfile.pgp

#pgpk -s Unknown -u Test

echo ========== Encrypt test

cat new5key | ./pgp5cryp -l wrx | ../minipgp/minipgp -z | ./pgp5cryp | \
  ./pgp5cryp -k 0 >wrx.enc
rm -f wrx
pgpv wrx.enc
if cmp wrx new5key; then echo quick encrypt ok; else exit 0; fi
rm wrx

echo ========== Encrypt and One pass sig test

for pka in 1 16; do
  for siga in 1 16 17; do
    for hash in 1 2 3; do
      for alg in 1 2 3; do
        echo
        echo testing pkenc $pka convenc $alg, hash $hash, sig $siga
        cat new5key | ./pgp5cryp -l wrx >wrx.one
        ./pgp5sign -A $siga -a $hash -t 1 -p testpass -1 >wrx.pre
        ./pgp5sign -A $siga -a $hash -t 1 -p testpass <new5key >wrx.two
        cat wrx.pre wrx.one wrx.two | ../minipgp/minipgp -z |\
          ./pgp5cryp | ./pgp5cryp -k 0 -a $alg -A $pka >wrx.enc
        rm -f wrx wrx.pre wrx.one wrx.two
        pgpv wrx.enc -o wrx

        if cmp wrx new5key ; then echo pgp decrypt ok; else exit 0; fi
        ./pgp5cryp -d <wrx.enc -p testpass | ./pgp5sign -v |\
          ../minipgp/minipgp | ./pgp5sign -v >wry.out
        if cmp wry.out new5key ; then echo decrypt ok; else exit 0; fi
      done
    done
  done
done
rm wrx wry.out

echo ========== Detached Signature test

for siga in 1 16 17; do
  for hash in 1 2 3; do
    ./pgp5sign <pgp5cryp >pgp5cryp.sig -p testpass -a $hash -A $siga
    ./pgp5sign -v <pgp5cryp -s pgp5cryp.sig
    pgpv pgp5cryp.sig
  done
done

rm pgp5cryp.sig

echo ========== Decrypt test
echo warning: this will fail on FreeBSD due to pgpe problems

rm -f wrx.out
pgpe new5key -r Test -s -u Test -o wrx.out
./pgp5cryp -d <wrx.out -p testpass | ./pgp5sign -v | ../minipgp/minipgp |\
  ./pgp5sign -v >wry.out
if cmp wry.out new5key; then echo our decrypt ok; else exit 0; fi
rm wry.out

