#!/bin/sh

PGPPATH=.
export PGPPATH
rm -f testfile*
cp README testfile.pro
cp testfile.pro testfile.ret
if [ ! -e randseed.bin ] ; then cp test.sh randseed.bin; fi

while ( cmp testfile.pro testfile.ret ); do 
    rm -f pubring.pgp secring.pgp testfile.pro.asc testfile.ret
    ./keygen -n 512 -s testfsec.pgp -o testfpub.pgp
    pgp -kaf <testfsec.pgp +batchmode +verbose=0
    pgp -kaf <testfpub.pgp +batchmode +verbose=0
    ./pullkey -x testfpb2.pgp -y testfpb1.pgp
    ./minipgp -i testfpb1.pgp -o testfile.sgn -t 16 -u 0
    cat testfpb2.pgp testfile.sgn >testfile.pgp
    pgp -ka testfile.pgp +batchmode +verbose=0 | grep "/.*Unknown"
    rm -f testfsec.pgp testfpub.pgp testfpb2.pgp pubring.bak secring.bak

    pgp -eas testfile.pro Unknown -u Unknown +batchmode +verbose=0 >/dev/null
    ./minipgp -i testfile.pro.asc | ./minipgp | ./minipgp >testfile.sgn
    ./minipgp -o testfile.out -x <testfile.sgn
#     dearmor                       decrypt     decompr   \
#     (save for sigchk)    deliter
   ./minipgp -i testfile.sgn -d
#   sigcheck
#this will fail with pgp -east, but diff -b will indicate no differences
#since PGP strips trailing space and changes line endings to CRLF
    if cmp testfile.pro testfile.out; then echo decrypt ok; else exit 0; fi

# 0 goes to the first keyid on ring: 97C0F21D
# literal and encryption must seek output file, so cannot use pipe or append
    ./minipgp -i testfile.out -o testfile.c1 -u 0 #signature
    ./minipgp -i testfile.out -o testfile.d1 -l testfile.out #literal

    ./minipgp -p TestPass -i testfile.d1 -o testfile.con -c
    ./minipgp -p TestPass -i testfile.con | ./minipgp -o testfile.out -x
    if cmp testfile.pro testfile.out; then echo convencr ok; else exit 0; fi

    cat testfile.c1 testfile.d1 | ./minipgp -o testfile.z1 -z
    ./minipgp -i testfile.z1 -o testfile.a1 -e 0
    ./minipgp -i testfile.a1 -o testfile.asc -a MESSAGE
    pgp -f <testfile.asc >testfile.ret +batchmode +verbose=0 2>testfile.log
    if grep "Good signature" testfile.log ; then true; else exit 0; fi

    ./pullkey -S -x testfpb2.pgp -y testfpb1.pgp
    ./minipgp -o testfile.sgn -i testfpb2.pgp -t 32 -u 0 
    cat testfpb2.pgp testfile.sgn testfpb1.pgp >testfile.pgp
    pgp -f +batchmode +verbose=0 <testfile.pgp >testfile.log

    if grep "KEY REVOKED" testfile.log ; then true; else exit 0; fi
done
