/*
**  Record the PID of the process using a particular device.
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/
/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */
#include <stdio.h>
#include "dp.h"


static char	lockfile[sizeof PID_FILE + 20];

int
record_pid(what)
    char	*what;
{
    extern char	*strcat();
    extern char	*strcpy();
    FILE	*fp;

    /* Open the file. */
    (void)sprintf(lockfile, PID_FILE, what);
    if ((fp = fopen(lockfile, "w")) == NULL) {
	d_log(DLOG_GENERAL, progname, "Can't write PID in \"%s\", %m",
		lockfile);
	lockfile[0] = '\0';
	return -1;
    }

    /* Write the PID out and close the file */
    (void)fprintf(fp, "%d\n", getpid()); 
    (void)fclose(fp);  
    return 0;
}


unlock_pid()
{
    if (lockfile[0]) {
	(void)unlink(lockfile);
	lockfile[0] = '\0';
    }
}
