/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Vector;
import tcl.lang.CmdTraceProc;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TraceRecord;
import tcl.lang.VarTrace;

class TraceCmd
implements Command {
    private static final String[] validCmds = new String[]{"variable", "vdelete", "vinfo"};
    private static final int OPT_VARIABLE = 0;
    private static final int OPT_VDELETE = 1;
    private static final int OPT_VINFO = 2;
    private static TclObject[] opStr = TraceCmd.initOptStr();

    private static TclObject[] initOptStr() {
        TclObject[] tclObjectArray = new TclObject[]{TclString.newInstance("error"), TclString.newInstance("r"), TclString.newInstance("w"), TclString.newInstance("rw"), TclString.newInstance("u"), TclString.newInstance("ru"), TclString.newInstance("wu"), TclString.newInstance("rwu")};
        int n = 0;
        while (n < 8) {
            TclObject tclObject = tclObjectArray[n];
            if (tclObject.internalRep == null) {
                throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
            }
            ++tclObject.refCount;
            ++n;
        }
        return tclObjectArray;
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option arg ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n) {
            case 0: 
            case 1: {
                if (tclObjectArray.length != 5) {
                    if (n == 0) {
                        throw new TclNumArgsException(interp, 1, tclObjectArray, "variable name ops command");
                    }
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "vdelete name ops command");
                }
                int n2 = 0;
                Object object = tclObjectArray[3];
                if (((TclObject)object).stringRep == null) {
                    ((TclObject)object).stringRep = ((TclObject)object).internalRep.toString();
                }
                object = ((TclObject)object).stringRep;
                int n3 = ((String)object).length();
                int n4 = 0;
                block12: while (n4 < n3) {
                    switch (((String)object).charAt(n4)) {
                        case 'r': {
                            n2 |= 0x10;
                            break;
                        }
                        case 'w': {
                            n2 |= 0x20;
                            break;
                        }
                        case 'u': {
                            n2 |= 0x40;
                            break;
                        }
                        default: {
                            n2 = 0;
                            break block12;
                        }
                    }
                    ++n4;
                }
                if (n2 == 0) {
                    throw new TclException(interp, "bad operations \"" + tclObjectArray[3] + "\": should be one or more of rwu");
                }
                if (n == 0) {
                    Object object2 = tclObjectArray[4];
                    if (((TclObject)object2).stringRep == null) {
                        ((TclObject)object2).stringRep = ((TclObject)object2).internalRep.toString();
                    }
                    object2 = new CmdTraceProc(((TclObject)object2).stringRep, n2);
                    interp.varFrame.traceVar(tclObjectArray[2], (VarTrace)object2, n2);
                    return;
                }
                Vector vector = interp.varFrame.getTraces(tclObjectArray[2], 0);
                if (vector == null) break;
                n3 = vector.size();
                int n5 = 0;
                while (n5 < n3) {
                    TraceRecord traceRecord = (TraceRecord)vector.elementAt(n5);
                    if (traceRecord.trace instanceof CmdTraceProc) {
                        CmdTraceProc cmdTraceProc = (CmdTraceProc)traceRecord.trace;
                        if (cmdTraceProc.flags == n2) {
                            String string = cmdTraceProc.command.toString();
                            TclObject tclObject = tclObjectArray[4];
                            if (tclObject.stringRep == null) {
                                tclObject.stringRep = tclObject.internalRep.toString();
                            }
                            if (string.equals(tclObject.stringRep)) {
                                interp.varFrame.untraceVar(tclObjectArray[2], (VarTrace)cmdTraceProc, n2);
                                return;
                            }
                        }
                    }
                    ++n5;
                }
                return;
            }
            case 2: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                Vector vector = interp.varFrame.getTraces(tclObjectArray[2], 0);
                if (vector == null) break;
                int n6 = vector.size();
                TclObject tclObject = TclList.newInstance();
                TclObject tclObject2 = null;
                if (tclObject.internalRep == null) {
                    throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
                }
                ++tclObject.refCount;
                try {
                    int n7 = 0;
                    while (n7 < n6) {
                        TraceRecord traceRecord = (TraceRecord)vector.elementAt(n7);
                        if (traceRecord.trace instanceof CmdTraceProc) {
                            CmdTraceProc cmdTraceProc = (CmdTraceProc)traceRecord.trace;
                            int n8 = cmdTraceProc.flags;
                            n8 &= 0x70;
                            tclObject2 = TclList.newInstance();
                            TclList.append(interp, tclObject2, opStr[n8 /= 16]);
                            TclList.append(interp, tclObject2, TclString.newInstance(cmdTraceProc.command));
                            TclList.append(interp, tclObject, tclObject2);
                        }
                        ++n7;
                    }
                    interp.setResult(tclObject);
                    return;
                }
                finally {
                    Object var11_19 = null;
                    tclObject.release();
                }
            }
        }
    }

    TraceCmd() {
    }
}

