module
#include "../expr/id.t.t"
#include "../expr/types.t.t"
#include "../expr/pprint.t"
#include "../syntax/listgen.h"
export lmlzf;
rec
    icons = mkids "_."
and inil = mkids "_[]"
and itrue = mkids "_true"
and ifalse = mkids "_false"
and igt = mkids "_>"
and iadd = mkids "_+"
and isub = mkids "_-"
and ifrom = mkids "Pfrom"
and ifromby = mkids "Pfromby"
and ifromto = mkids "Pfromto"
and ifrombyto = mkids "Pfrombyto"
and c1 = mkconst (cint 1)
and elet i e1 e2 = mkletv (mkbrec (mkbpat [(i, e1)])) e2
and econs e1 e2 = mkap (mkap (mkident icons) e1) e2
and enil = mkident inil
and elam i e = mklam i e
and eif b t f = mkcase b [(mkident itrue, t); (mkident ifalse, f)]
and egt e1 e2 = mkap (mkap (mkident igt) e1) e2
and eap e1 e2 = mkap e1 e2
and einc e = mkap (mkap (mkident iadd) e) c1
and esub e1 e2 = mkap (mkap (mkident isub) e1) e2
and eadd e e1 e2 = mkap (mkap (mkident iadd) e) (esub e1 e2)
and edum = mkident (mkids "_")
and newid n = mkident (mkids ("Lx"@itos n))

and
    L e [] t u =
	(econs e t, u)
||  L e (mkqfilter f.r) t u =
	let (q, u') = L e r t u
	in (eif f q t, u')
||  L e (mkqgen (x as mkident _) (mklistf L_FROM_TO [n; m]).r) t u =
	let g = newid u in
	let (q, u') = L e r (eap g (einc x)) (u+1)
	in (elet g (elam x (eif (egt x m) t q)) (eap g n), u')
||  L e (mkqgen (x as mkident _) (mklistf L_FROM [n]).r) t u =
	let g = newid u in
	let (q, u') = L e r (eap g (einc x)) (u+1)
	in (elet g (elam x q) (eap g n), u')
||  L e (mkqgen (x as mkident _) (mklistf L_FROM_BY_TO [n; k; m]).r) t u =
	let g = newid u in
	let (q, u') = L e r (eap g (eadd x k n)) (u+1)
	in (elet g (elam x (eif (egt x m) t q)) (eap g n), u')
||  L e (mkqgen (x as mkident _) (mklistf L_FROM_BY [n; k]).r) t u =
	let g = newid u in
	let (q, u') = L e r (eap g (eadd x k n)) (u+1)
	in (elet g (elam x q) (eap g n), u')
||  L e (mkqgen p l.r) t u =
	let g = newid u
	and xs = newid (u+1)
	in let (q, u') = L e r (eap g xs) (u+2)
	in (elet g (Lg g p t q xs) (eap g l), u')
and Lg g p t q xs =
	let a = mkident (mkids "La") in
	let dum = (econs edum xs, eap g xs)
	and pat = econs p xs in
	let d =
		case p in
		   mkcondp _ _ : [(pat, q); dum]
		|| mkident _ : [(pat, q)]
		|| _ : [(mkcondp pat (mkident itrue), q); dum]
		end
	in
	mklam a (mkcase a ((enil, t) . d))

and mkif c t e = mkcase c [(mtrue, t); (mfalse, e)]
and mtrue = mkident (mkids "_true")
and mfalse = mkident (mkids "_false")
and
    tr u (mkap (mkap (mkap (mkident (mkids "Pif")) c) t) e) = tr u (mkif c t e)
||  tr u (mkap (mkap (mkident (mkids "_&")) x) y) = tr u (mkif x y mfalse)
||  tr u (mkap (mkap (mkident (mkids "_|")) x) y) = tr u (mkif x mtrue y)
||  tr u (mkap (mkident (mkids "_~")) x) = tr u (mkif x mfalse mtrue)

||  tr u (mkap e1 e2) =
	let (u', e1') = tr u e1 in
	let (u'', e2')= tr u' e2 in
	(u'', mkap e1' e2')
||  tr u (mklam e1 e2) =
	let (u', e1') = trp u e1 in
	let (u'', e2') = tr u e2 in
	(u'', mklam e1 e2')
||  tr u (mkcase e pes) =
	let (u', e') = tr u e in
	let (u'', pes') = mapstate trpb u pes in
	(u'', mkcase e' pes')
||  tr u (mkletv b e) =
	let (u', b') = trb u b in
	let (u'', e') = tr u' e in
	(u'', mkletv b' e')
||  tr u (e as mkident _) = (u, e)
||  tr u (mkmodule i ex im fi b) = 
	let (u', b') = trb u b in
	(u', mkmodule i ex im fi b')
||  tr u (e as mkconst _) = (u, e)
||  tr u (e as mkerror _) = (u, e)
/*
||  tr u (mkas i e) =
	let (u', e') = tr u e in
	(u', mkas i e')
||  tr u (mkcondp p e) =
	let (u', e') = tr u e in
	let (u'', p') = tr u' p in
	(u', mkcondp p' e')
*/
||  tr u (mkinfo t e) =
	let (u', e') = tr u e in
	(u', mkinfo t e')
||  tr u (mklistf L_FROM [e1]) =
	let (u', e1') = tr u e1 in
	(u', eap (mkident ifrom) e1')
||  tr u (mklistf L_FROM_TO [e1; e2]) =
	let (u', e1') = tr u e1 in
	let (u'', e2') = tr u' e2 in
	(u'', eap (eap (mkident ifromto) e1') e2')
||  tr u (mklistf L_FROM_BY [e1; e2]) =
	let (u', e1') = tr u e1 in
	let (u'', e2') = tr u' e2 in
	(u'', eap (eap (mkident ifromby) e1') (esub e2' e1'))
||  tr u (mklistf L_FROM_BY_TO [e1; e2; e3]) =
	let (u', e1') = tr u e1 in
	let (u'', e2') = tr u' e2 in
	let (u''', e3') = tr u'' e3 in
	(u''', eap (eap (eap (mkident ifrombyto) e1') (esub e2' e1')) e3')
||  tr u (mklistg e gs) =
	let (l, u') = L e gs enil u in
	tr u' l
||  tr u e = fail ("ZF-trans "@ppr e)
and
    trpb u (p, e) =
	let (u', e') = tr u e in
	let (u'', p') = trp u' p in
	(u'', (p', e'))
and
    trb u (b as mkbtype _ _ _) = (u, b)
||  trb u (mkbpat pes) =
	let (u', pes') = mapstate trpb u pes in
	(u', mkbpat pes')
||  trb u (mkband b1 b2) =
	let (u', b1') = trb u b1 in
	let (u'', b2')= trb u' b2 in
	(u'', mkband b1' b2')
||  trb u (mkbrec b) =
	let (u', b') = trb u b in
	(u', mkbrec b')
||  trb u (mkblocal b1 b2) =
	let (u', b1') = trb u b1 in
	let (u'', b2')= trb u' b2 in
	(u'', mkblocal b1' b2')
||  trb u (b as mkbnull) = (u, b)
||  trb u (b as mkbsyn _ _) = (u, b)
and trp u (mkcondp p e) =
    let (u', e') = tr u e in
    (u', mkcondp p e')
||  trp u p = (u, p)
and lmlzf e = snd (tr 1 e)
end
