module -- genderiv
#include "../expr/types.t.t"
#include "../expr/id.t"
#include "../expr/id.t.t"
#include "../expr/ttype.t"
#include "../expr/ttype.t.t"
#include "../expr/pprint.t"
#include "../misc/misc.t"
#include "../misc/util.t"
#include "../misc/flags.t"
#include "../rename/renameutil.t"
#include "../rename/deriv.t"
#include "lettrans.t"
#include "hexpr.t"
#include "exprs.t"
#include "cutil.t"
#include <Option>

export gender;
rec gender i t cs u = assocdefeq eqid i gtab (\_.\_.\u.(mkbnull, u)) t cs u

and gtab = [(hiEq, genEq); (hiOrd, genOrd); (hiIx, genIx); (hiEnum, genEnum); (hiText, genText); (hiBinary, genBinary)]

and isenum cs = all (\(mkcons _ l).null l) cs
and mkapi f a = mkap (mkident f) a
and mkap2i f x y = mkap (mkap (mkident f) x) y
and mkap3i f x y z = mkap (mkap (mkap (mkident f) x) y) z
and etrue = mkconstr hctrue []
and efalse = mkconstr hcfalse []
and edum = mkident dummyid
and enever = mkident hinever
and eq2 x y = mkap2i hieq x y
and andthem [x] [y] = eq2 x y
||  andthem (x.xs) (y.ys) = mkap2i hiand (eq2 x y) (andthem xs ys)
and orandthem [x] [y] = mkap2i hile x y
||  orandthem (x.xs) (y.ys) = mkap2i hior (mkap2i hilt x y) (mkap2i hiand (eq2 x y) (orandthem xs ys))
and mkb bs = andify (map (\p.mkbpat [p]) bs)
and e1 = mkconst (cint 1)
and e10 = mkconst (cint 10)
and estr s = mkconst (cstring (tl s))
and eint i = mkconst (cint i)
and esp = mkapi hishowChar (mkconst (cchar ' '))
and epair a b = mkconstr hcpair [a;b]
and esing x = mkconstr hccons [x; mkconstr hcnil []]
and comp [x] = x
||  comp (x.xs) = mkap2i hicomp x (mkap2i hicomp esp (comp xs))
and comb i [e] = e
||  comb i (e.es) = mkap2i i e (comb i es)

and mkl2 op x y = mklam x (mklam y (mkap2i op (mkapi hiord x) (mkapi hiord y)))

-- Generate equality test
and genEq t cs u =
    let [x;y] = for u (u+1) newid in
	if isenum cs then
	    (mkb    [(mkident hieq, mkl2 hieqint x y)], u)
	else
	    let (pes, u') = Umap (geneqt y) cs (u+2) in
	    (mkb    [(mkident hieq, mklam x (mklam y (
			   if length cs = 1 then
			       mkcase x pes
			   else
			       mkcase (mkap2i hieqint (mkapi hicno x) (mkapi hicno y))
				      [(etrue, mkcase x pes);
				       (edum, efalse)]))
	            )], u')

and geneqt y (mkcons i tbs) u =
        let n = length tbs in
	let xs = for u (u+n-1) newid
        and ys = for (u+n) (u+2*n-1) newid
        and c = idtoconstr i in
        ((mkconstr c xs, mkcase y [(mkconstr c ys, if n = 0 then etrue else andthem xs ys); (edum, enever)]), u+2*n)

-- Generate ordering tests
and genOrd t cs u =
	let [x;y;x1;y1;x2;y2] = for u (u+5) newid in
        let u = u+6 in
	if isenum cs then
	    (mkb    [(mkident hile, mkl2 hileint x1 y1);
		     (mkident hilt, mkl2 hiltint x2 y2)], u)
	else
	    let (pes, u') = Umap (genlet y) cs u in
            let xn = mkapi hicno x
            and yn = mkapi hicno y in
	    (mkb [(mkident hile, mklam x (mklam y (
			if length cs = 1 then
			    mkcase x pes
			else
			    (mkcase (mkap2i hieqint xn yn)
			            [(etrue, mkcase x pes);
				     (edum, mkap2i hiltint xn yn)])))
	         )], u')

and genlet y (mkcons i tbs) u =
        let n = length tbs in
	let xs = for u (u+n-1) newid
        and ys = for (u+n) (u+2*n-1) newid
        and c = idtoconstr i in
        ((mkconstr c xs, mkcase y [(mkconstr c ys, if n = 0 then etrue else orandthem xs ys); (edum, enever)]), u+2*n)

and genIx t cs u =
	if isenum cs then
	    (mkb    [(mkident hirange, mkident hiPrange);
		     (mkident hiindex, mkident hiPindex);
		     (mkident hiinRange,mkident hiPinRange)], u)
	else
	    let [mkcons i tbs] = cs in
            let ci = idtoconstr i in
	    let n = length tbs in

	    let ls = for u (u+n-1) newident
            and us = for (u+n) (u+2*n-1) newident
            and is = for (u+2*n) (u+3*n-1) newident
            and x = newident (u+3*n) in
	    let rangecode = mklistg (mkconstr ci is) (map3 (\i.\l.\u.mkqgen i (mkapi hirange (epair l u))) is ls us) in
	    let drange = mklam x (mkcase x [(epair (mkconstr ci ls) (mkconstr ci us), rangecode)]) in

	    let u = u+3*n+1 in
	    let ls = for u (u+n-1) newident
            and us = for (u+n) (u+2*n-1) newident
            and is = for (u+2*n) (u+3*n-1) newident
            and x = newident (u+3*n)
            and y = newident (u+3*n+1) in
            let sizes = map2 (\l.\h.mkap2i hiadd (mkap2i hiindex (epair l h) h) e1) ls us
            and indexes = map3 (\l.\h.\i.mkap2i hiindex (epair l h) i) ls us is in
            let indexcode =
		if length is = 1 then
		    hd indexes
		else
		    mkap2i hiadd
		           (reduce (\(i,s).\r.mkap2i himul (mkap2i hiadd r i) s) 
			           (mkap2i himul (hd indexes) (hd (tl sizes)))
			           (reverse (combine(tl indexes, tl(tl sizes)))))
			   (last indexes)
	    in
	    let dindex = mklam x (mklam y (mkcase x [(epair (mkconstr ci ls) (mkconstr ci us), mkcase y [(mkconstr ci is, indexcode)])])) in

	    let u = u+3*n+2 in
	    let ls = for u (u+n-1) newident
            and us = for (u+n) (u+2*n-1) newident
            and is = for (u+2*n) (u+3*n-1) newident
            and x = newident (u+3*n)
            and y = newident (u+3*n+1) in
            let inRangecode = comb hiand (map3 (\i.\l.\u.mkap2i hiinRange (epair l u) i) is ls us) in
	    let dinRange = mklam x (mklam y (mkcase x [(epair (mkconstr ci ls) (mkconstr ci us), mkcase y [(mkconstr ci is, inRangecode)])])) in

	    (mkb    [(mkident hirange, drange);
		     (mkident hiindex, dindex);
		     (mkident hiinRange, dinRange)], u+3*n+2)

and mkl3i i x y z = mklam x (mklam y (mklam z (mkap (mkap (mkap (mkident i) x) y) z)))
and mkl2i i x y = mklam x (mklam y (mkap (mkap (mkident i) x) y))
and genEnum t cs u =
   let (mkcons i _) = last cs in
   let [x1;x2;y2;x3;y3;z3;x4;y4;z4] = for u (u+8) newid in
   (mkb    [(mkident hienumFrom,        (mklam x1 (mkap2i hienumFT x1 (mkident i))));
	    (mkident hienumFromThen,    (mklam x2 (mklam y2 (mkap3i hienumFTT x2 y2 (mkident i)))));
	    (mkident hienumFromTo,      mkl2i hienumFT  x3 y3);
	    (mkident hienumFromThenTo,  mkl3i hienumFTT x4 y4 z4)], u+9)

and genText t cs u =
    let [x1;x2;d1;d2] = for u (u+3) newid in
    let (pes1, u') = Umap (genshow d1) cs (u+4) in
    let (e2, u'') = genread d2 x2 cs u in
    (mkb [(mkident hishowsPrec, mklam d1 (mklam x1 (mkcase x1 pes1)));
	  (mkident hireadsPrec, mklam d2 (mklam x2 e2))], u'')

and genshow d (mkcons (i as mkid _ _ _ (Orignames _ f ns)) tbs) u =
    let n = length tbs in
    let xs = for u (u+n-1) newid in
    ((mkconstr (idtoconstr i) xs,
     if f = Nofixity then
	 if n = 0 then
	     mkapi hishowString (estr (last ns))
	 else
	     mkap2i hishowParen (mkap2i hileint e10 d) (comp (mkapi hishowString (estr (last ns)).map (mkap2i hishowsPrec e10) xs))
     else
	 let (lp, rp, p) = case f in InfixL p : (p, p+1, p) || InfixR p : (p+1, p, p) || Infix p : (p+1,p+1, p) end in
         let [e1;e2] = xs in
         mkap2i hishowParen (mkap2i hiltint (eint p) d) (comp [mkap2i hishowsPrec (eint lp) e1; mkapi hishowString (estr (last ns)); mkap2i hishowsPrec (eint rp) e2])),
     u+n)

and genread d x cs u =
    let (ecs, u') = Umap (genreadc d x) cs u in
    (comb hiconc ecs, u')

and genreadc d x (mkcons (i as mkid _ _ _ (Orignames _ f ns)) tbs) u =
    let n = length tbs in
    let r1 = newid u in
    let ss = for (u+1) (u+n+1) newid
    and tt = for (u+n+2) (u+2*(n+1)) newid in
    let c = idtoconstr i in
    let cname = estr (last ns) in
    ((if f = Nofixity then
	mkap3i hireadParen (mkap2i hileint e10 d)
	       (mklam r1 (mklistg (epair (mkconstr c (tl tt)) (last ss))
				  (mkqgen (epair (hd tt) (hd ss)) (esing (mkapi hilex r1)) . mkqfilter (mkap2i hieq (hd tt) cname) .
				   map3 (\sk.\tk.\sk1.mkqgen (epair tk sk) (mkap2i hireadsPrec e10 sk1)) (tl ss) (tl tt) ss)
				  ))
               x
      else
	let (lp, rp, p) = case f in InfixL p : (p, p+1, p) || InfixR p : (p+1, p, p) || Infix p : (p+1,p+1, p) end in
        let [s0; s1; s2] = ss
        and [u; tok; v] = tt in
	mkap3i hireadParen (mkap2i hiltint (eint p) d)
	       (mklam r1 (mklistg (epair (mkconstr c [u;v]) s2)
			          [mkqgen (epair u s0) (mkap2i hireadsPrec (eint lp) r1);
				   mkqgen (epair tok s1) (esing (mkapi hilex s0));
				      mkqfilter (mkap2i hieq tok cname);
				   mkqgen (epair v s2) (mkap2i hireadsPrec (eint rp) s1)]))
	       x
      ), u+2*(n+1)+1)

and genBinary t cs u =
    (mkb    [(mkident hishowBin, mkident hiPshowBin);
	     (mkident hireadBin, mkident hiPreadBin)], u)
end
