module -- failcase
-- $Header: /ufs/usr.src/local/lml/src/transform/RCS/failcase.m,v 2.16 87/12/18 18:25:24 augustss Exp $
--
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/constr.t.t"
#include "../expr/ttype.t.t"
#include "../expr/einfo.t.t"
#include "../expr/types.t.t"
#include "../expr/constrfun.t"
#include "../expr/ttype.t"
#include "../expr/subst.t"
#include "../expr/pprint.t"
#include "../rename/importpre.t"
#include "hexpr.t"
#include "misc.t"
export fmkcase, tfail;
rec

    nfail = (dollar, mkfailmatch 0)
and tfail s = mkap (mkident hifail) (mkconstr (mkstring s) [])

and allcases [] = false
||  allcases ((mkconstr c _).l) = nconstrs c = length l + 1

-- Compute how many fails are jumping out of an expression.
-- This is somewhat kludgy.
and nfails (mkcase _ ((_, e)._)) = nfails e
||  nfails (mkfailmatch n) = n
||  nfails _ = 0

and repfail d (mkcase e ((di, de).pes)) = mkcase e ((di, repfail d de).pes)
||  repfail d (mkfailmatch 1) = d
||  repfail _ e = e
and isfailmatch (mkfailmatch _) = true
||  isfailmatch _ = false

and fmk i ((def as (_,d)).pes) =
	if  allcases (map fst pes) then
		let n = Sum (map (nfails o snd) pes) in
		if n = 0 then
			mkcase i (nfail.pes)
		else if n = 1 & nfails d = 0 then
			mkcase i (nfail.mapsnd (repfail d) pes)
		else
			mkcase i (def.pes)
	else
	    mkcase i (def.pes)

and extend [d] = [d]
||  extend (d.pes) =
	let ((mkconstr c _, _).l) = pes in
	let n = length pes
	and m = nconstrs c in
	if n < m & n+1 >= m then
		d.(f (reverse (count 0 (m-1))) pes where rec
		    f [] _ = []
		 || f (n.ns) ((pe as (mkconstr c _, _)).pes) & (n = cno c) =
			pe.f ns pes
		 || f (n.ns) pes = let c' = nth_constr n (ctinfo c) in
(mkconstr c' (map (\_.dollar) (cargs c')), mkfailmatch 1).f ns pes)
	else
		d.pes

and opt i (d as [(mkident di, de)]) = subst i di de
||  opt i ((mkident di, de).cs) = fmk i ((dollar, subst i di de).cs)
||  opt i pes = fmk i pes

and fmkcase i pes = opt i (extend pes)
end
