# include <stdio.h>
# include <setjmp.h>
# include "include.h"
# include "curry.h"

extern list Lnil;
extern char *malloc();

tree mkterop(s, l, m, r)
  char *s;
  tree l, m, r;
{
	return mkap(mkap(mkap(mkident(s), l), m), r);
}

tree mkbinop(s, l, r)
  char *s;
  tree l, r;
{
	return mkap(mkap(mkident(s), l), r);
}

tree mkunop(s, o)
  char *s;
  tree o;
{
	return mkap(mkident(s), o);
}

tree mkcons(h, t)
tree h, t;
{
	return mkap(mkap(mkident("_."), h), t);
}

#if 0
tree mkbool(b)
{
	return mkident(b ? "Ptrue" : "Pfalse");
}
			
tree mkif(c, i, t)
  tree c, i, t;
{
	return mkcasee(c, mklcons(mkppat(mkbool(1), i),
			         mklcons(mkppat(mkbool(0), t),
				         mklnil())));
}

tree mkand(a, b)
tree a, b;
{
	return mkif(a, b, mkbool(0));
}

tree mkor(a, b)
tree a, b;
{
	return mkif(a, mkbool(1), b);
}

tree mknot(a)
tree a;
{
	return mkif(a, mkbool(0), mkbool(1));
}
#endif

tree mkfcomp(f1, f2)
  tree f1, f2;
{
	tree t = mkident("x");
	return mklam(t, mkap(f1, mkap(f2, t)));
}

char *
tupstr(l, n)
list l;
{
	if (tlist(l) == lcons)
		return tupstr(ltl(l), n+1);
	else {
		char *p = malloc(10);
		sprintf(p, "_#%d", n);
		return p;
	}
}

list
lconc(l1, l2)
list l1, l2;
{
	list t;

	if (tlist(l1) == lnil)
		return(l2);
	for(t = l1; tlist(ltl(t)) != lnil; t = ltl(t))
		;
	ltl(t) = l2;
	return(l1);
}

list
lapp(l1, l2)
list l1;
{
	list t;

	if (tlist(l1) == lnil)
		return(mklcons(l2, mklnil()));
	for(t = l1; tlist(ltl(t)) != lnil; t = ltl(t))
		;
	ltl(t) = mklcons(l2, mklnil());
	return(l1);
}

list
nrev(l)
list *l;
{
    list cur, prev, next;

    prev = Lnil;
    cur = *l;
    while(tlist(cur) != lnil) {
	next = ltl(cur);
	ltl(cur) = prev;
	prev = cur;
	cur = next;
    }
    *l = prev;
    return *l;
}


/* Temporary fix for the type id problem. */
#define TIDMAX 2000
typeno(s)
char *s;
{
	static char *tn[TIDMAX];
	static int tno = 0;
	int i;

	for(i = 0; i < tno; i++) {
		if (strcmp(tn[i], s) == 0)
			return i;
	}
	if (tno >= TIDMAX) {
	    	error("Too many type id\n");
	}
	tn[tno] = malloc(strlen(s)+1);
	strcpy(tn[tno], s);
	return tno++;
}

tree mksection(i, e)
id i;
tree e;
{
	tree x = mkident("xx");

	return mklam(x, mkbinop(i, x, e));
}

#define T_PAT 1
#define T_EXP 2
#define T_ANY 3

static jmp_buf tjmp;

static void
tcheck(t)
tree t;
{
    list l;

    switch(ttree(t)) {
    case par:
	tcheck(gpare(t));
	break;
    case ident: 
    case integer:
    case bignum:
    case charr:
    case floatt:
    case string:
    case ratnum:
	break;
    case restr:
	tcheck(grestre(t));
	break;
    case eannot:
	tcheck(geannote(t));
	break;
    case ap: 
	tcheck(gfun(t)); 
	tcheck(garg(t)); 
	break;
    case letv: 
    case lam: 
    case casee:
    case listf:
    case listg:
	longjmp(tjmp, T_EXP);
	break;
    case tuple:
	for(l = gtuplelist(t); tlist(l) != lnil ; l = ltl(l))
	    tcheck(lhd(l));
	break;
    case as:
    case condp:
    case lazyp:
	longjmp(tjmp, T_PAT);
	break;
    default:
	error("Bad tcheck");
    }
}

static int
check(t)
tree t;
{
    int r;

    if (r = setjmp(tjmp))
	return r;
    tcheck(t);
    return T_ANY;
}

tree
checkpat(t)
tree t;
{
    if (check(t) == T_EXP)
	syntaxerror();
    return t;
}

tree
checkexp(t)
tree t;
{
    if (check(t) == T_PAT)
	syntaxerror();
    return t;
}

static id
expname(e)
expidt e;
{
    switch(texpidt(e)) {
    case expid:
	return (gexpid(e));
	break;
    case expdd:
	return (gexpdd(e));
	break;
    case exppdd:
	return (gexppdd(e));
	break;
    case expl:
	return(gexplid(e));
	break;
    default:
	error("Bad prexpid");
	break;
    }
}

/* add all imported infixes to the lexical analyser */
addinfixes(i)
impstuff i;
{
    list fixs = gifixes(i);
    impstuff spec = gispec(i);
    list rens = girename(i);
    int show = giexpose(spec);
    list expids = giids(spec);
    static int tok[] = { INFIX, INFIXL, INFIXR, 0, 0, NONFIX };

    for(; tlist(fixs) == lcons; fixs = ltl(fixs)) {
	impstuff fix = (impstuff)lhd(fixs);
	list lfix;
	int as = gifixass(fix);
	int prec = gifixprec(fix);

	for(lfix = gifixids(fix); tlist(lfix) == lcons; lfix = ltl(lfix)) {
	    id fi = (id)lhd(lfix);
	    int inlist;
	    list l;

	    for(inlist = 0, l = expids; tlist(l) == lcons; l = ltl(l)) {
		if (strcmp(fi, expname(lhd(l))) == 0) {
		    inlist++;
		    break;
		}
	    }
	    if (show && inlist || !show && !inlist) {
		/* keep this unless it is renamed */
		int ren;
		list r;

		for(ren = 0, r = rens; tlist(r) == lcons; r = ltl(r)) {
		    if (strcmp(fi, girensrc(lhd(r))) == 0) {
			ren++;
			break;
		    }
		}
		if (!ren) {
		    makefixop(fi, tok[as], prec);
                }
	    }
	}
    }
}
