

#include "include.h"
#include "icmd.h"
struct SIexpr {
	Ticmd tag;
	tree XgIexpr;
};

struct SIbinding {
	Ticmd tag;
	list XgIbinding;
};

struct SItload {
	Ticmd tag;
	tree XgItloadname;
	tree XgItloadimp;
};

struct SImload {
	Ticmd tag;
	tree XgImloadname;
};

struct SImsg {
	Ticmd tag;
	tree XgImsg;
};

struct SImsgnp {
	Ticmd tag;
	tree XgImsgnp;
};

struct SInull {
	Ticmd tag;
};

Ticmd ticmd(t)
 icmd t;
{
	return(t -> tag);
}


/************** Iexpr ******************/

icmd mkIexpr(PPgIexpr)
 tree PPgIexpr;
{
	register struct SIexpr *pp =
		(struct SIexpr *) malloc(sizeof(struct SIexpr));
	pp -> tag = Iexpr;
	pp -> XgIexpr = PPgIexpr;
	return((icmd)pp);
}

tree *RgIexpr(t)
 struct SIexpr *t;
{
	if(t -> tag != Iexpr)
		printf("gIexpr: illegal selection; was %d\n", t -> tag);
	return(& t -> XgIexpr);
}

/************** Ibinding ******************/

icmd mkIbinding(PPgIbinding)
 list PPgIbinding;
{
	register struct SIbinding *pp =
		(struct SIbinding *) malloc(sizeof(struct SIbinding));
	pp -> tag = Ibinding;
	pp -> XgIbinding = PPgIbinding;
	return((icmd)pp);
}

list *RgIbinding(t)
 struct SIbinding *t;
{
	if(t -> tag != Ibinding)
		printf("gIbinding: illegal selection; was %d\n", t -> tag);
	return(& t -> XgIbinding);
}

/************** Itload ******************/

icmd mkItload(PPgItloadname, PPgItloadimp)
 tree PPgItloadname;
 tree PPgItloadimp;
{
	register struct SItload *pp =
		(struct SItload *) malloc(sizeof(struct SItload));
	pp -> tag = Itload;
	pp -> XgItloadname = PPgItloadname;
	pp -> XgItloadimp = PPgItloadimp;
	return((icmd)pp);
}

tree *RgItloadname(t)
 struct SItload *t;
{
	if(t -> tag != Itload)
		printf("gItloadname: illegal selection; was %d\n", t -> tag);
	return(& t -> XgItloadname);
}

tree *RgItloadimp(t)
 struct SItload *t;
{
	if(t -> tag != Itload)
		printf("gItloadimp: illegal selection; was %d\n", t -> tag);
	return(& t -> XgItloadimp);
}

/************** Imload ******************/

icmd mkImload(PPgImloadname)
 tree PPgImloadname;
{
	register struct SImload *pp =
		(struct SImload *) malloc(sizeof(struct SImload));
	pp -> tag = Imload;
	pp -> XgImloadname = PPgImloadname;
	return((icmd)pp);
}

tree *RgImloadname(t)
 struct SImload *t;
{
	if(t -> tag != Imload)
		printf("gImloadname: illegal selection; was %d\n", t -> tag);
	return(& t -> XgImloadname);
}

/************** Imsg ******************/

icmd mkImsg(PPgImsg)
 tree PPgImsg;
{
	register struct SImsg *pp =
		(struct SImsg *) malloc(sizeof(struct SImsg));
	pp -> tag = Imsg;
	pp -> XgImsg = PPgImsg;
	return((icmd)pp);
}

tree *RgImsg(t)
 struct SImsg *t;
{
	if(t -> tag != Imsg)
		printf("gImsg: illegal selection; was %d\n", t -> tag);
	return(& t -> XgImsg);
}

/************** Imsgnp ******************/

icmd mkImsgnp(PPgImsgnp)
 tree PPgImsgnp;
{
	register struct SImsgnp *pp =
		(struct SImsgnp *) malloc(sizeof(struct SImsgnp));
	pp -> tag = Imsgnp;
	pp -> XgImsgnp = PPgImsgnp;
	return((icmd)pp);
}

tree *RgImsgnp(t)
 struct SImsgnp *t;
{
	if(t -> tag != Imsgnp)
		printf("gImsgnp: illegal selection; was %d\n", t -> tag);
	return(& t -> XgImsgnp);
}

/************** Inull ******************/

icmd mkInull()
{
	register struct SInull *pp =
		(struct SInull *) malloc(sizeof(struct SInull));
	pp -> tag = Inull;
	return((icmd)pp);
}
