#include "include.h"
#include "curry.h"
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#define MAXINFIX 100
#define MAXISTR 1000

#define COMM 10000
#define PLCOMM 10001

extern double atof();
extern id installid();
extern int interactive, interfacef, debug;
extern int pedantic;
extern char *copystring();
extern char *index(), *rindex();

int yylineno = 1;
extern int zyzflag, zyzid;
char *filename;
FILE *yyin = stdin;
struct {
    FILE *file;
    char *name;
    int curindent, yylineno, curchar, save1;
} oldfiles[100];
int oldindex = 0;
static int pushtoken = -1;
static int forcedeof = 0;
static char *yyp;
static char tmpname[200] = "";
static char incdir[1024];
char empty_prel[1024];
char yytext[5120];
static char yybuf[5120];
static int saved = 0;
static char savechar[1024];
#define LASTMAX 10
static int curchar='\n', lastvec[LASTMAX];
static int lastind = 0;
#define lastchar lastvec[lastind % LASTMAX]

int tabstop = 8;
static int indentlevel, curindent;
#define I_HARD 1
#define I_SOFT 2
struct ind {
    int indent;
    int kind;
};
#define MAXINDENT 100
#define INITIND 0
static struct ind indtab[MAXINDENT] = { { INITIND, I_HARD } };
static int indindex = 1;
#define topkind (indtab[indindex-1].kind)
#define topindent (indtab[indindex-1].indent)

static struct ctrl {
    char *code;
    int ord;
} ctrls[] = {
"a",  7,  "b",  8,  "t",  9,  "n",  10, "f",  12, "r",  13, "v",  14,
"'",'\'', "\"",'"', "\\",'\\',
"NUL",0,  "SOH",1,  "STX",2,  "ETX",3,  "EOT",4,  "ENQ",5,  "ACK",6,  "BEL",7,
"BS", 8,  "HT", 9,  "LF", 10, "VT", 11, "FF", 12, "CR", 13, "SO", 14, "SI", 15,
"DLE",16, "DC1",17, "DC2",18, "DC3",19, "DC4",20, "NAK",21, "SYN",22, "ETB",23,
"CAN",24, "EM", 25, "SUB",26, "ESC",27, "FS", 28, "GS", 29, "RS", 30, "US", 31,
"SP",32,  "DEL",127,
0,0 };

static struct yytable {
    char *name;
    short token;
} yytable[] = {
    "case",	CASE,
    "class",	CLASS,
    "data",	DATA,
    "default",	DEFAULT,
    "deriving",	DERIVING,
    "else",	ELSE,
    "hiding",	HIDING,
    "if",	IF,
    "import",	IMPORT,
    "infix",	INFIX,
    "infixl",	INFIXL,
    "infixr",	INFIXR,
    "nonfix",	MNONFIX,
    "instance",	INSTANCE,
    "interface",INTERFACE,
    "module",	MODULE,
    "of",	OF,
    "renaming",	RENAMING,
    "then",	THEN,
    "to",	TO,
    "type",	TYPE,
    "where",	WHERE,

    "load",	LOAD,
    "source",	SOURCE,
    "let",	LET,
    0,0,0
};

#define MAXOPR 1000
struct opr {
    char *oprname;
    int oprtoken;
} oprs[MAXOPR] = {
"mod",	OPN7,
"div",	OPN7,
"rem",	OPN7,
0,0
};

#define COMM 10000
static struct infix {
    char *iname;	/* first char is ignored */
    short ilen;
    short itoken;
} infixtab[MAXINFIX] = {
"?{-:",	3,	ANNOT,

"?--",	2,	COMM,
"?{-",	2,	PLCOMM,
"?..",	2,	DOTDOT,
"P->",	2,	ARROW,
"?<-",	2,	RARROW,
"?=>",	2,	DARROW,
"?::",	2,	DCOLON,
"_||",	2,	OPR0,
"_&&",	2,	OPR1,
"_/=",	2,	OPN2,
"_>=",	2,	OPN2,
"_<=",	2,	OPN2,
"_==",	2,	OPN2,
"_++",	2,	OPR3,
"_**",	2,	OPR8,
"_^^",	2,	OPR8,
"_!!",	2,	OPL9,
"_:%",	2,	OPN7,
"_:+",	2,	OPN6,
"_\\\\",2,	OPL3,
"_:=",	2,	OPN5,
"_//",	2,	OPL4,

"?\\",	1,	BACKSLASH,
"?;",	1,	SEMI,
"?,",	1,	COMMA,
"?(",	1,	LPAR,
"?)",	1,	RPAR,
"?[",	1,	LBRA,
"?]",	1,	RBRA,
"?{",	1,	LCURL,
"?}",	1,	RCURL,
"?|",	1,	BAR,
"?@",	1,	AS,
"?=",	1,	EQ,
"?~",	1,	TILDE,

"_>",	1,	OPN2,
"_<",	1,	OPN2,
"_:",	1,	OPR3,
"_+",	1,	OPL6,
"_-",	1,	MINUS,
"_*",	1,	OPL7,
"_^",	1,	OPR8,
"_/",	1,	OPN7,
"_%",	1,	OPN7,
"_.",	1,	OPR9,	/* !!! */
"_!",	1,	OPL9,

"?",	0,	0,
};
static int ninfix;		/* # of predefined operators */
static char infixstr[MAXISTR];
static char *infixp = infixstr;
#define mlinf (infixtab[0].ilen)	/* longest length */

nfixes()
{
    return ninfix;
}

#define BADESC "Bad character escape"

static char *
decode(p, ip, base)
char *p;
int *ip;
int base;
{
    static char b8[] = "01234567", b10[] = "0123456789", b16[] = "0123456789abcdefABCDEF";
    char *b = base == 8 ? b8 : base == 10 ? b10 : b16;
    char *q;
    unsigned int r, n;

    r = 0;
    while(q = index(b, *p)) {
	n = q-b;
	if (n >= 16) n -= 6;
	r = r*base + n;
	p++;
    }
    *ip = r;
    return p;
}

static int
processbackslash(q, p)
register char *p, *q;
{
    unsigned int c;
    struct ctrl *ct;
    char *oq = q;

    while(*p) {
	if ((c = *p++) == '\\') {
	    switch(c = *p++) {
	    case '&': continue;
	    case '^': c = *p++; if (c < '@' || c > '_') yyerror(BADESC); c &= 0x1f; break;
	    case 'o': /* Octal */
		p = decode(p, &c, 8);
		break;
	    case 'x': /* Hex */
		p = decode(p, &c, 16);
		break;
	    case '0':case'1':case'2':case'3':case'4':case'5':case'6':case'7':case'8':case'9':
		/* Decimal */
		p = decode(p-1, &c, 10);
		break;
	    case '\'': break;
	    case '"': break;
	    case '\\': break;
	    case ' ': case '\t':
		while(*p == ' ' || *p == '\t')
		    p++;
		if (*p++ != '\n')
		    yyerror(BADESC);
	    case '\n':
		while(*p == ' ' || *p == '\t')
		    p++;
		if (*p++ != '\\')
		    yyerror(BADESC);
		continue;
	    default:
		c = -1;
		p--;
		for(ct = ctrls; ct->code; ct++) {
		    if (strncmp(p, ct->code, strlen(ct->code)) == 0) {
			c = ct->ord;
			p += strlen(ct->code);
			break;
		    }
		}
		if (c == -1)
		    yyerror(BADESC);
		break;
	    }
	}
	if (c > 255)
	    yyerror("Character value > 255");
	*q++ = c;
    }
    *q = 0;
    return q - oq;
}

makefixop(ss, assoc, level)
char *ss;
{
    static int non[] = { OPN0,OPN1,OPN2,OPN3,OPN4,OPN5,OPN6,OPN7,OPN8,OPN9 };
    static int left[] = { OPL0,OPL1,OPL2,OPL3,OPL4,OPL5,OPL6,OPL7,OPL8,OPL9 };
    static int right[] = { OPR0,OPR1,OPR2,OPR3,OPR4,OPR5,OPR6,OPR7,OPR8,OPR9 };
    int t;

    switch(assoc) {
    case INFIX: t = non[level]; break;
    case INFIXL: t = left[level]; break;
    case INFIXR: t = right[level]; break;
    case NONFIX: t = assoc; break;
    default: fprintf(stderr, "Bad makefixop\n"); exit(1); break;
    }
    if (allletter(&ss[1])) {
	makeopr(ss+1, t);
    } else {
	makeinfix(ss, t);
    }
}

makefixopl(l, a, v)
list l;
{
    for(; tlist(l) != lnil; l = ltl(l))
	makefixop(lhd(l), a, v);
}

makeinfix(ss, token)
char *ss;
{
    register int i, l;
    char s[1000], *p;

    strcpy(s, ss);
    l = strlen(s);
    if (ninfix >= MAXINFIX || infixp+l+1 >= &infixstr[MAXISTR]) {
	error("Too many infixes.");
	return;
    }
    for(i = ninfix; i > 0; i--) {
	if (infixtab[i-1].ilen >= l)
	    break;
	infixtab[i] = infixtab[i-1];
    }
    infixtab[i].iname = infixp;
    strcpy(infixp, s);
    infixp += l+1;
    infixtab[i].itoken = token;
    infixtab[i].ilen = l-1;
    ninfix++;
/*printf("new fix '%s' %d %d\n", infixtab[i].iname, infixtab[i].ilen, infixtab[i].itoken);*/
}

makeopr(ss, t)
char *ss;
int t;
{
    struct opr *op;

    for(op = oprs; op->oprname; op++)
	;
    if (op - oprs >= MAXOPR)
	error("Too many oprs");
    op->oprname = installid(ss);
    op->oprtoken = t;
    op++;
    op->oprname = 0;
}

int
lookupopr(s)
char *s;
{
    struct opr *op;

    for(op = oprs; op->oprname; op++)
	if (strcmp(op->oprname, s) == 0)
	    return op->oprtoken;
    return OPN9;
}

yyinit()
{
    for(ninfix = 0; infixtab[ninfix].ilen; ninfix++)
	;
    ninfix++;
    saved = 0;
    yylineno = 1;
    lastchar = '\n';
}

static struct yytable *
lookup(name)
char *name;
{
    register struct yytable *p;

    for(p = yytable; p->name; p++)
	if (strcmp(name, p->name) == 0 && (p->token != NONFIX || zyzflag))
	    return p;
    return 0;
}


static int
letter(c)
register c;
{
    return	'a' <= c && c <= 'z' ||
		'A' <= c && c <= 'Z' ||
		'0' <= c && c <= '9' ||
		c == '_' || c == '\'' ||
		(!pedantic && c >= 0xc0 && c < 0x100 && c != 0xd7 && c != 0xf7);
}

static int
allletter(s)
char *s;
{
    for(;*s;s++)
	if (!letter(*s))
	    return 0;
    return 1;
}

static int
white(c)
register c;
{
    return c == '\n' || c == '\t' || c == ' ' || c == '\f' || c == '\013';
}

static int
operator(c)
register c;
{
    static char ops[] = "!#$%&*+./<=>?@\\^|~:-";

    if (c == '-')
	pedchk();
    return index(ops, c) ? 1 : 0;
}

static int
alloperator(p)
char *p;
{
    for(; *p; p++)
	if (!operator(*p))
	    return 0;
    return 1;
}

static
yygetc()
{
    int c;

    lastvec[++lastind % LASTMAX] = curchar;
    if (saved > 0) {
	c = savechar[--saved] & 0xff;
    } else {
	c = getc(yyin);
    }
    if (c == '\n') {
	yylineno++;
	curindent = 0;
    } else if (c == '\t') {
	curindent = (curindent / tabstop + 1) * tabstop;
    } else {
	curindent++;
    }
    if (c != EOF) {
	*yyp++ = c;
    }
    curchar = c;
    return c;
}

static
yyunget(c)
{
    if (c != EOF) {
	savechar[saved++] = c;
	if (c == '\n')
	    yylineno--;
	yyp--;
	curchar = lastvec[lastind-- % LASTMAX];
    }
    curindent--;		/* not correct for '\t' and '\n' */
}

static
yypeek()
{
    register int c;
    int oind;

    oind = curindent;
    c = yygetc();
    yyunget(c);
    curindent = oind;
    return c;
}

static
gobble(c)
register c;
{
    register int d;

    if (yypeek() == c) {
	(void)yygetc();
	return 1;
    } else
	return 0;
}

static
digit(c)
{
    return '0' <= c && c <= '9';
}

static
skipdigits()
{
    register int c;

    while('0' <= (c = yypeek()) && c <= '9')
	(void)yygetc();
}

static
pushindent(k)
{
    if (indindex >= MAXINDENT)
	error("Too many indent levels\n");
    indtab[indindex].indent = indentlevel;
    indtab[indindex++].kind = k;
}

static int
popindent(k)
{
    if (--indindex < 1)
	error("Too many popindent\n");
    if (indtab[indindex].kind != k)
	return SYNTAX_ERROR;
    else
	return RCURL;
}

popsoft()
{
    if (popindent(I_SOFT) != RCURL) {
	yyerror("Syntax error");
    }
}

static
yylex1()
{
    register int i, j, c, c1;
    register struct yytable *p;
    int t;
    unsigned char ibuff[100];
    char tt[1000];

    if (pushtoken >= 0) {
	t = pushtoken;
	pushtoken = -1;
	return t;
    }
    if (forcedeof)
	return EOF;
    for (;;) {
    again:
	if (lastchar == '\n' && yypeek() == '#' && curchar == '\n') {
	    char buf[1000];
	    while((c = yygetc()) != '\n' && c != EOF)
		;
	    *yyp = 0;
	    sscanf(&yytext[1], "%d \"%[^\"]", &yylineno, buf);
	    filename = copystring(buf);
	    goto again;
	}

	while(white(yypeek()))
	    (void)yygetc();
	indentlevel = curindent;
	yyp = yytext;
    	/* first try for an infix operator */
	for(i = 0; i < mlinf && yypeek() != '\n' && yypeek() != EOF; i++) {
	    ibuff[i] = yygetc();
	}
	if (alloperator(ibuff) && operator(yypeek())) {
	    /* More chars will make up a longer operator */
	    do {
		(void)yygetc();
	    } while(operator(yypeek()));
	    *yyp = 0;
	    if (ibuff[0] == '-' && ibuff[1] == '-') {
		t = COMM;
		goto comment;
	    }
	    t = OPN9;
	    goto identi;
	}
	ibuff[i] = 0;
	if (ibuff[0] == '-' && ibuff[1] == '-') {
	    t = COMM;
	    goto comment;
	}
	for(j = 0; j < ninfix; j++) {
	    while (infixtab[j].ilen < i) {
		/* Before chopping off last char of potential operator check if it is
		   a valid operator on its own. */
		if (alloperator(ibuff)) {
		    /* All chars are valid operator chars. */
		    *yyp = 0;
		    t = OPN9;
		    goto identi;
		}
	        yyunget(ibuff[--i]);
		ibuff[i] = 0;
	    }
	    if (i == 0)
	    	break;
	    if (strcmp(ibuff, infixtab[j].iname+1) == 0) {
	    	t = infixtab[j].itoken;
/*printf("opr '%s'=%d ", infixtab[j].iname, t);*/
		if (t == COMM) {
		comment:
		    /* Skip the comment */
		    while ((c = yygetc()) != '\n' && c != EOF)
		        ;
		    yyunget(c);
		    goto again;
		} else if (t == PLCOMM) {
		    int nest;

		    for(nest = 1; nest; nest--) {
			do {
			    while((c = yygetc()) != '-' && c != EOF) {
				if (c == '{' && yypeek() == '-')
				    nest++;
				yyp = yytext;
			    }
			} while (yypeek() != '}' && yypeek() != EOF);
			(void)yygetc();
		    }
		    goto again;
		} else if (t == ANNOT) {
		    while(!(yygetc() == ':' && yypeek() == '-'))
			;
		    yygetc(), yygetc();
		    yyp[-3] = 0;
		    if (zyzid && yytext[3] == '"') {
			/* special id */
			*rindex(yytext+4, '"') = 0;
			processbackslash(yybuf, yytext+4);
			yylval.uid = installid(yybuf);
			return yyp[-4] == 'C' ? CNAME : NAME;
		    } else if (zyzid && (yytext[3] == '#')) {
			yylval.uint = atoi(yytext+4);
			return INTCONST;
		    } else {
			yylval.uid = installid(yytext+3);
			return ANNOT;
		    }
		} else {
		    yylval.uid = infixtab[j].iname;
		    return t;
		}
	    }
	}
	c = yygetc();
	switch (c) {
	case EOF: 
	    if (oldindex) {
		return LEOF;
	    } else
		if (interactive) {
		    interactive = 0;
		    return THEEND;
		} else
		    return EOF;
	case ' ': 
	case '\t': 
	case '\n':
	    yyerror("illegal white space");
	    break;

	case '\'':
	    do {
		c = yygetc();
		if (c == EOF || c == '\n')
		    yyerror("Nonterminated character");
		if (c == '\\')
		    if (yygetc() == EOF)
			yyerror(BADESC);
	    } while (c != '\'');
	    *--yyp = 0;
	    yybuf[1] = 1;
	    if (processbackslash(yybuf, yytext+1) != 1)
		return SYNTAX_ERROR;
	    yylval.uid = installid(yybuf); 
	    return CHAR;
	case '"':
	    do {
		c = yygetc();
		if (c == EOF || c == '\n')
		    yyerror("Nonterminated string");
		if (c == '\\')
		    if (yygetc() == EOF)
			yyerror(BADESC);
	    } while (c != '\"');
	    *--yyp = 0;
	    processbackslash(yybuf, yytext+1);
	    /* Change all tabs back to \t */
	    { char *p, *q;
	      for(q = yybuf, p = yytext; *q; p++, q++) {
		  if ((*p = *q) == '\t')
		      *p++ = '\\', *p = 't';
	      }
	      *p = 0;
	    }
	    yylval.uid = installid(yytext);
	    return STRING;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	    skipdigits();
	    c = yygetc();
	    c1 = yypeek();
	    yyunget(c);
	    if (c == '.' && digit(c1) || c == 'e' || c == 'E') {
		if (c == '.') {
		    (void)yygetc();
		    skipdigits();
		    c = yypeek();
		}
		if (c == 'e' || c == 'E') {
		    if (c == 'E')
			pedchk();
		    (void)yygetc();
		    c = yypeek();
		    if (c == '-' || c == '+')
			(void)yygetc();
		    skipdigits();
		}
		*yyp = 0;
		yylval.uid = installid(yytext);
		return RATNUM;
	    } else {
		*yyp++ = 'I';
		*yyp = 0;
		yylval.uid = installid(yytext);
		return yytext[1] == 'I' ? DIGIT : INT;
	    }
	case '`':
	    yyp = yytext;
	    do {
		c = yygetc();
	    } while(letter(c));
	    *yyp = 0;
	    if (c != '`')
		return SYNTAX_ERROR;
	    yyp[-1] = 0;
	    t = lookupopr(yytext);
	    goto identi;
	case '_':
	    if (!letter(yypeek())) {
		*yyp = 0;
		yylval.uid = "_";
		return WILD;
	    }
		/* fall into ... */
	    def:
	default:
	    if (letter(c)) {
		do {
		    c = yygetc();
		} while(letter(c));
		yyunget(c);
		*yyp = 0;
		if (p = lookup(yytext)) {
		    if (!interactive && p->token >= LOAD)
			goto identif;
		    return p->token;
		} else {
		identif:
		    t = isupper(yytext[zyzflag]) ? CNAME : NAME;
		identi:
		    sprintf(tt, "%s%s", zyzflag ? "" : "_", yytext);
		    yylval.uid = installid(tt);
		    return t;
		}
	    } else if (operator(c)) {
		do {
		    c = yygetc();
		} while(operator(c));
		yyunget(c);
		*yyp = 0;
		t = OPN9;
		goto identi;
	    } else {
		return SYNTAX_ERROR;
	    }
	}
    }
}

static int lasttoken;
yylex2()
{
    register int r;
    static int first = 1;
    static int ptoken = -10;

    if (ptoken >= -1) {
	r = ptoken;
	ptoken = -10;
	return r;
    }
    yyp = yytext;
    r = yylex1();
    *yyp = 0;
    if (first && !interactive && !interfacef) {
	/* generate an LCURL if short module form */
	first = 0;
	if (r != MODULE && r != LCURL) {
	    pushindent(I_SOFT);
	    ptoken = r;
	    return LCURL;
	}
    }
    if (r == LCURL) {
	pushindent(I_HARD);
	return r;
    } else if (r == RCURL)
	return popindent(I_HARD);
    if (topkind == I_SOFT) {
	if (r == EOF || r == LEOF)
	    indentlevel = -1;
	if (indentlevel == topindent) {
	    ptoken = r;
	    return SEMI;
	} else if (indentlevel < topindent) {
	    pushtoken = r;
	    return popindent(I_SOFT);
	}
    }
    if ((lasttoken == WHERE || lasttoken == OF || lasttoken == LET) && r != LCURL) {
	pushindent(I_SOFT);
	ptoken = r;
	return LCURL;
    }   
    return r;
}

yylex()
{
    int r;

    r = yylex2();
    if (r == LEOF)
	popfile();

    lasttoken = r;
    if (debug)
	printf("'%s'=%d, ", yytext, r); fflush(stdout);
    return r;
}

char loadname[1024];

pushfile(f, s)
FILE *f;
char *s;
{
    oldfiles[oldindex].yylineno = yylineno;
    oldfiles[oldindex].curindent = curindent;
    oldfiles[oldindex].curchar = curchar;
    oldfiles[oldindex].name = filename;
    filename = copystring(s);
    if (saved > 0) {
	if (saved == 1) {
	    oldfiles[oldindex].save1 = savechar[--saved];
	} else {
	    fprintf(stderr, "saved > 1\n");
	    exit(1);
	}
    } else {
	oldfiles[oldindex].save1 = -1;
    }
    curchar = '\n';
    curindent = 0;
    indentlevel = INITIND;
    pushindent(I_HARD);
    oldfiles[oldindex++].file = yyin;
    yyin = f;
}

popfile()
{
    if (*tmpname) {
	unlink(tmpname);
	tmpname[0] = 0;
    }
    fclose(yyin);
    yyin = oldfiles[--oldindex].file;
    curindent = oldfiles[oldindex].curindent;
    yylineno = oldfiles[oldindex].yylineno;
    curchar = oldfiles[oldindex].curchar;
    free(filename);
    filename = oldfiles[oldindex].name;
    if (oldfiles[oldindex].save1 >= 0) {
	saved = 0;
	savechar[saved++] = oldfiles[oldindex].save1;
    }
    popindent(I_HARD);
}

switchto(s)
{
    FILE *f;
    int l;

    strcpy(loadname, s);
    l = strlen(loadname);
    if (loadname[l-2] == '.') {
	switch(loadname[l-1]) {
	case 'm':
	loadm:
	    if ((f = fopen(loadname, "r")) == NULL) {
		errmsg("Cannot open s\n", loadname);
		pushtoken = LEOF;
	    } else {
		/* to simple, sigh! pushfile(f); */
		char buf[1024];
		sprintf(tmpname, "/tmp/icurry%d", getpid());
		sprintf(buf, "/lib/cpp -C -I%s %s %s", incdir, loadname, tmpname);
		system(buf);
		fclose(f);
		pushfile(fopen(tmpname, "r"), loadname);
		pushtoken = MLOAD;
	    }
	    break;
	case 'o':
	loado:
	    if ((f = fopen(loadname, "r")) == NULL) {
		errmsg("Cannot open %s\n", loadname);
		pushtoken = LEOF;
	    } else {
		fclose(f);
		loadname[l-1] = 't';
		if ((f = fopen(loadname, "r")) == NULL) {
		    errmsg("Cannot open %s\n", loadname);
		    pushtoken = LEOF;
		} else {
		    loadname[l-1] = 'o';
		    pushfile(f, loadname);
		    pushtoken = OLOAD;
		}
	    }
	    break;
	    
	default:
	    error("Bad file name %s\n", loadname);
	    pushtoken = LEOF;
	}
    } else {
	struct stat sm, so;
	int rm, ro;

	strcpy(loadname+l, ".m");
	l += 2;
	rm = stat(loadname, &sm);
	loadname[l-1] = 'o';
	ro = stat(loadname, &so);
	if (ro == -1 || (unsigned long)sm.st_mtime > so.st_mtime) {
	    loadname[l-1] = 'm';
	    normmsg("Loading %s\n", loadname);
	    goto loadm;
	} else {
	    normmsg("Loading %s\n", loadname);
	    goto loado;
	}
    }
}

source(s)
char *s;
{
    char b[1024];
    FILE *f;

    strcpy(b, s);
    if ((f = fopen(b, "r")) == NULL) {
	errmsg("Cannot open %s\n", loadname);
    } else {
	pushfile(f, b);
    }
}

seteof()
{
    forcedeof = 1;
}

initlex()
{
    char *s;
    extern char *getenv();

    yyinit();
    s = getenv("LMLDIR");
    if (!s) {
	s = "/usr/local/lib/lmlc";
    }
    sprintf(incdir, "%s/lib/include", s);
    sprintf(empty_prel, "_%s/lib/PreludeEmpty.hi", s);
}

syntaxerror()
{
    pushtoken = SYNTAX_ERROR;
}

pushextra(t)
{
    pushtoken = t;
}

fixtype()
{
    fprintf(stderr, "fixtype\n");
    exit(1);
}

fixop()
{
    fprintf(stderr, "fixop\n");
    exit(1);
}

pedchk()
{
    if (pedantic) {
	yyerror("Not allowed in pedantic mode.\n");
    }
}
