%{
#include <stdio.h>
#include "include.h"
#include "listgen.h"
extern tree root;
extern impstuff iroot;
extern char empty_prel[];

int curryflag = 1;

#define UFRS (-2)
extern id installid();
extern tree niltree;
extern list Lnil;
extern int wantrcurl;
#define lsing(l) mklcons(l, Lnil)
#define ldub(l1, l2) mklcons(l1, lsing(l2))
extern int Eflag;

extern list lconc(), lapp();
extern tree mkterop(), mkbinop(), mkunop(), mkif(), mkand(), mkor(),
	    mknot(), mkfcomp(), mksection();
extern char *tupstr();
extern void pimpid();
extern char loadname[];

static tree mkcons();
static ttype checkinst();
static char *typname();

id negbig();
list nrev();
tree mlist(), mkapchain(), mklams(), checkpat(), cndp(), checkexp();
binding andthem();
binding fbind();
list checkcontext();
finfot finfofromstring();

static int ininterface = 0;

%}

%union {
	tree utree;
	list ulist;
	ttype uttype;
	atype uatype;
	binding ubinding;
	pbinding upbinding;
	finfot ufinfo;
	impidt uimpid;
	id uid;
	int uint;
	char *ustring;
	qual uqual;
	double ufloat;
	impstuff uimpstuff;
	expidt uexpid;
}

%token CASE CLASS DATA DEFAULT DERIVING ELSE HIDING IF
%token IMPORT INFIX INFIXL INFIXR INSTANCE INTERFACE
%token MODULE OF RENAMING THEN TO TYPE WHERE
%token NONFIX MNONFIX

%token LCURL RCURL SEMI COMMA LPAR RPAR AS ANNOT TILDE
%token WILD DCOLON ARROW LBRA RBRA BAR BACKSLASH DOTDOT DARROW
%token EQ RARROW MINUS
%token RATNUM CHAR INT STRING DIGIT INTCONST
%token CNAME NAME
%token LEOF THEEND SYNTAX_ERROR LOAD MLOAD OLOAD SOURCE LET

%nonassoc PREC_LAM
%nonassoc WHERE
%nonassoc IF THEN ELSE
%right ARROW
%left DCOLON
%nonassoc OPN0
%left OPL0
%right OPR0
%nonassoc OPN1
%left OPL1
%right OPR1
%nonassoc OPN2
%left OPL2
%right OPR2
%nonassoc OPN3
%left OPL3
%right OPR3
%nonassoc OPN4
%left OPL4
%right OPR4
%nonassoc OPN5
%left OPL5
%right OPR5
%nonassoc OPN6
%left OPL6 MINUS
%right OPR6
%nonassoc OPN7
%left OPL7
%right OPR7
%nonassoc OPN8
%left OPL8
%right OPR8
%nonassoc OPN9
%left OPL9
%right OPR9
%nonassoc CNAME NAME INT STRING CHAR RATNUM DIGIT WILD NONFIX INTCONST
%left PREC_AP CASE LPAR LBRA UMINUS TILDE
%left		P_ANNOT

%type <utree> exp aexp pat apat epat o_gd gd xexp
%type <ulist> ops texps tpats lpats imports exportlist context qual importelist qualn imports1 o_imports
%type <ulist> o_renaming renamings exports constrs atypes2 types apats alts importes
%type <ulist> o_gdfun gdfun itopdecls iimports o_fixes itopdecl1s
%type <ulist> names names1 enames enames1 satypes
%type <ufinfo> finfo
%type <uimpstuff> impspec fix renaming import importr typinfo o_exportlist o_deriving
%type <uimpid> itopdecl iimport
%type <ubinding> topdecl decl topdecls decls o_where_class o_where_inst valdef clsign icdecl o_where_iclass icdecls funbind clsigns
%type <ustring> STRING ANNOT
%type <uid> op conid varid varop tycon NAME CNAME name MINUS modid ARROW iop INT DIGIT int ename binop1 NONFIX varcon RATNUM opx
%type <uexpid> export importe
%type <uint> CHAR o_digit INTCONST derinfo
%type <uttype> type atype1 simple_or_type atype class_or_type con_simple simple class con_class con_inst inst context_or_type tyvar stype typeid satype
%type <uqual> qual1
%type <ufinfo> 
%type <upbinding> alt
%type <uatype> constr
%type <ustring> OPN0 OPN1 OPN2 OPN3 OPN4 OPN5 OPN6 OPN7 OPN8 OPN9
%type <ustring> OPL0 OPL1 OPL2 OPL3 OPL4 OPL5 OPL6 OPL7 OPL8 OPL9
%type <ustring> OPR0 OPR1 OPR2 OPR3 OPR4 OPR5 OPR6 OPR7 OPR8 OPR9

%%
top:	'i' commands end | module | 'p' sinterface;

end:	THEEND { seteof(); }

commands:commands command
         |
         /* empty */
         ;

command:exp SEMI				{ picmd(mkIexpr($1)); }
        |
        LET LCURL topdecls rcurl SEMI		{ picmd(mkIbinding(mkrbind($3))); }
        |
/*	LOAD STRING SEMI { switchto($2); } load
        |*/
	SOURCE STRING SEMI			{ source($2); }
	|
	LEOF					{ picmd(mkInull()); }
	|
        SEMI					{ picmd(mkInull()); }
        |
        error SEMI				{ picmd(mkInull()); }
        ;

/*
load:	OLOAD imports LEOF 		{ picmd(mkItload(mkstring(loadname), $2)); }
	|
	MLOAD module LEOF 		{ picmd(mkImload($2)); }
	|
    	LEOF				{ picmd(mkInull()); }
	;
*/

sinterface:	INTERFACE modid WHERE LCURL iimports o_fixes itopdecls rcurl	 { iroot = mkinterface($2, nrev(&$5), nrev(&$6), nrev(&$7)); }
		;
		;

/*********/

module:		MODULE modid o_exportlist WHERE LCURL
			 o_imports o_fixes topdecls rcurl
			{ root = mkhmodule($2, $3, nrev(&$6), nrev(&$7), mkrbind($8)); }
		|
		MODULE modid o_exportlist WHERE LCURL
			 imports rcurl
			{ root = mkhmodule($2, $3, nrev(&$6), Lnil, mknbind()); }
		|
		LCURL o_imports o_fixes topdecls rcurl
			{ root = mkhmodule("_Main", mkinone(), nrev(&$2), nrev(&$3), mkrbind($4)); }
		;



modid:		conid			{ $$ = $1; }
		|
    		varid			{ $$ = $1; pedchk(); }
		|
		STRING			{ $$ = $1; pedchk(); }
		;

imports:	imports1		{ $$ = $1; }
		|
    		/* empty */		{ $$ = Lnil; }
		;
o_imports:	/* empty */		{ $$ = Lnil; }
		|
		imports1 SEMI		{ $$ = $1; }
		;

imports1:	imports1 SEMI import	{ $$ = mklcons($3, $1); }
		|
		import			{ $$ = lsing($1); }
		;
import:		IMPORT modid { switchtoid(strcmp($2, "_Prelude") == 0 ? empty_prel : $2); ininterface++; } importr { $$ = $4; ininterface--; addinfixes($4); }
		;

importr:	INTERFACE modid WHERE LCURL iimports o_fixes itopdecls rcurl LEOF impspec o_renaming	 { $$ = mkimport($2, nrev(&$5), nrev(&$6), nrev(&$7), $10, $11); }
		;

impspec:	/* empty */		{ $$ = mkispec(0, Lnil); }
    		|
		importelist		{ $$ = mkispec(1, nrev(&$1)); }
		|
		HIDING importelist	{ $$ = mkispec(0, nrev(&$2)); }
		;

iimports:	/* empty */		{ $$ = Lnil; }
		|
		iimports iimport	{ $$ = mklcons($2, $1); }
		;
iimport:	IMPORT modid exportlist o_renaming SEMI { $$ = mkimpimport($2, nrev(&$3), $4); }
		;

itopdecls:	itopdecl1s		{ $$ = $1; }
		|
		/* empty */		{ $$ = Lnil; }
		;
itopdecl1s:	itopdecl1s SEMI itopdecl { $$ = mklcons($3, $1); }
		|
		itopdecl		{ $$ = lsing($1); }
		;


itopdecl:	TYPE con_simple EQ type		{ $$ = mkimpsyn($2, $4); adderrinfo(typname($2)); }
		|
		DATA con_simple o_deriving typinfo	{ $$ = mkimptype($2, $3, $4); adderrinfo(typname($2)); }
		|
		DATA con_simple EQ constrs o_deriving	{ $$ = mkimpeqtype($2, nrev(&$4), $5); adderrinfo(typname($2)); }
		|
		CLASS con_class o_where_iclass	{ $$ = mkimpclass($2, $3); adderrinfo(typname($2)); }
		|
		INSTANCE con_inst derinfo	{ $$ = mkimpinst($2, $3); }
		|
		names DCOLON type finfo		{ $$ = mkimpids($1, $3, $4); }
		|
		names DCOLON context DARROW type finfo	{ $$ = mkimpids($1, mktcontext($3, $5), $6); }
		;

typinfo:	/* empty */			{ $$ = mkinone(); }
		|
	  	ANNOT				{ int n; char buf[100]; if (sscanf($1, "%d,%[TF]", &n, buf) != 2) yyerror("Bad type info");
						  $$ = mkitypinfo(n, buf[0] == 'T'); }
	        ;

derinfo:	/* empty */			{ $$ = 0; }
		|
		ANNOT				{ char buf[100]; if (sscanf($1, "%[TF]", buf) != 1) yyerror("Bad instance info");
						  $$ = buf[0] == 'T'; }
                ;

o_deriving:	/* empty */		{ $$ = mkinone(); }
		|
		DERIVING name		{ $$ = mkisome(lsing($2)); }
		|
		DERIVING LPAR names RPAR { $$ = mkisome(nrev(&$3)); }
		;

finfo	: /* missing */			{ $$ = mknofinfo(); } |
	  ANNOT				{ $$ = finfofromstring($1); }
	  ;

o_where_iclass:	/* empty */		{ $$ = mknbind(); }
		|
    		WHERE LCURL icdecls rcurl { $$ = $3; }
		;
icdecls:	icdecl			{ $$ = $1; }
		|
		icdecls SEMI icdecl	{ $$ = mkabind($1, $3); }
		;
icdecl:		names DCOLON type	{ $$ = mksbind($1, $3); }
		|
		names DCOLON context DARROW type	{ $$ = mksbind($1, mktcontext($3, $5)); }
		;

o_exportlist:	exportlist		{ $$ = mkisome(nrev(&$1)); }
		|
		/* empty */		{ $$ = mkinone(); }
		;
o_renaming:	RENAMING LPAR renamings RPAR	{ $$ = $3; }
		|
		/* empty */		{ $$ = Lnil; }
		;

exportlist:	LPAR exports RPAR	{ $$ = $2; }
                |
                LPAR RPAR               { $$ = Lnil; }
		;
exports:	export			{ $$ = lsing($1); }
		|
		exports COMMA export	{ $$ = mklcons($3, $1); }
		;

export:		ename			{ $$ = mkexpid($1); }
		|
		ename LPAR DOTDOT RPAR	{ $$ = mkexppdd($1); }
		|
		ename DOTDOT		{ $$ = mkexpdd($1); }
		|
		ename LPAR enames RPAR	{ $$ = mkexpl($1, $3); }
		;

importelist:	LPAR importes RPAR	{ $$ = $2; }
		;
importes:	importe			{ $$ = lsing($1); }
		|
		importes COMMA importe	{ $$ = mklcons($3, $1); }
		;

importe:	ename			{ $$ = mkexpid($1); }
		|
		ename LPAR DOTDOT RPAR	{ $$ = mkexppdd($1); }
		|
		ename LPAR enames RPAR	{ $$ = mkexpl($1, $3); }
		;

renamings:	renaming		{ $$ = lsing($1); }
		|
		renamings COMMA renaming	{ $$ = mklcons($3, $1); }
		;
renaming:	name TO name		{ $$ = mkirename($1, $3); }
		|
		name TO WILD		{ $$ = mkirename($1, "_"); }
		;

ename:		name			{ $$ = $1; }
/* turn this off for now		|
		varop			{ $$ = $1; }*/
		;
name:		varcon			{ $$ = $1; }
		;
names:		/* empty */	{ $$ = Lnil; }
		|
		names1		{ $$ = nrev(&$1); }
		;
names1:		name		{ $$ = lsing($1); }
		|
		names COMMA name { $$ = mklcons($3, $1); }
		;
enames:		/* empty */	{ $$ = Lnil; }
		|
		enames1		{ $$ = nrev(&$1); }
		;
enames1:	ename		{ $$ = lsing($1); }
		|
		enames COMMA ename { $$ = mklcons($3, $1); }
		;

o_fixes:	o_fixes fix		{ $$ = mklcons($2, $1); }
		|
		/* empty */		{ $$ = Lnil; }
		;
fix:		INFIXL o_digit ops SEMI	{ if (!ininterface) makefixopl($3, INFIXL, $2); $$ = mkifix($3, 1, $2); }
		|
		INFIXR o_digit ops SEMI	{ if (!ininterface) makefixopl($3, INFIXR, $2); $$ = mkifix($3, 2, $2); }
		|
		INFIX o_digit ops SEMI	{ if (!ininterface) makefixopl($3, INFIX, $2); $$ = mkifix($3, 0, $2); }
		|
		MNONFIX ops SEMI	{ if (!ininterface) makefixopl($2, NONFIX, 9); $$ = mkifix($2, 5, 9); }
		;
o_digit:	DIGIT			{ $$ = atoi($1); }
		|
		/* empty */		{ $$ = 9; }
		;

ops:		ops COMMA iop		{ $$ = mklcons($3, $1); }
		|
		iop			{ $$ = lsing($1); }
		;
iop:		op			{ $$ = $1; }
		|
		STRING			{ $$ = $1; pedchk(); }
		;

topdecls:	topdecls SEMI topdecl	{ $$ = mkabind($1, $3); }
		|
		topdecl			{ $$ = $1; }
		;
topdecl:	TYPE con_simple EQ type		{ $$ = mkebind($2, $4); adderrinfo(typname($2)); }
		|
		DATA con_simple EQ constrs o_deriving	{ $$ = mktbind($2, nrev(&$4), $5); adderrinfo(typname($2)); }
		|
		CLASS con_class o_where_class	{ $$ = mkcbind($2, $3); adderrinfo(typname($2)); }
		|
		INSTANCE con_inst o_where_inst	{ $$ = mkibind($2, $3); }
		|
		DEFAULT LPAR RPAR		{ $$ = mkubind(Lnil); }
		|
		DEFAULT LPAR type RPAR		{ $$ = mkubind(lsing($3)); }
		|
		DEFAULT typeid			{ $$ = mkubind(lsing($2)); }
    		|
		DEFAULT LPAR types RPAR		{ $$ = mkubind(nrev(&$3)); }
		|
		decl				{ $$ = $1; }
		;
o_where_inst:	/* empty */			{ $$ = mknbind(); }
		|
		WHERE LCURL decls rcurl		{ $$ = $3; }
		;
o_where_class:	WHERE LCURL clsigns rcurl	{ $$ = $3; }
		|
		/* empty */			{ $$ = mknbind();}
		;
con_simple:	simple				{ $$ = $1; }
		|
		context DARROW simple		{ $$ = mktcontext($1, $3); }
		;
con_class:	class				{ $$ = $1; }
		|
		context DARROW class		{ $$ = mktcontext($1, $3); }
		;
typeid:		tycon				{ $$ = mktname($1, Lnil); }
		|
		tycon atype			{ $$ = mktname($1, lsing($2)); }
		|
		tycon atypes2			{ $$ = mktname($1, $2); }
		;

con_inst:	tycon inst			{ $$ = mktname($1, lsing($2)); }
		|
		context DARROW tycon inst	{ $$ = mktcontext($1, mktname($3, lsing($4))); }
		;

inst:		type			{ $$ = checkinst($1); }
		;
decls:		decls SEMI decl		{ $$ = mkabind($1, $3); }
		|
		decl			{ $$ = $1; }
		;
decl:		names DCOLON type	{ $$ = mksbind($1, $3); }
		|
		names DCOLON context DARROW type	{ $$ = mksbind($1, mktcontext($3, $5)); }
		|
		valdef			{ $$ = $1; }
		;
		
valdef:		funbind			{ $$ = $1; }
		;

type:		atype1			{ $$ = $1; }
		|
		type ARROW type		{ $$ = mktname($2, ldub($1, $3)); }
		|
		simple_or_type		{ $$ = $1; }
		;

atypes2:	atypes2 atype		{ $$ = mklcons($2, $1); }
		|
		atype atype		{ $$ = ldub($2, $1); }
		;

simple_or_type:	tycon			{ $$ = mktname($1, Lnil); }
		|
		class_or_type		{ $$ = $1; }
		|
		tycon atypes2		{ $$ = mktname($1, nrev(&$2)); }
		;
class_or_type:	tycon atype		{ $$ = mktname($1, lsing($2)); }
		;

atype:		tycon			{ $$ = mktname($1, Lnil); }
		|
		atype1			{ $$ = $1; }
		;

atype1:		tyvar			{ $$ = $1; }
		|
		LPAR RPAR		{ $$ = mktname("_()", Lnil); }
		|
		context_or_type		{ $$ = $1; }
		|
		LBRA type RBRA		{ $$ = mktname("PList", lsing($2)); }
		;
types:		types COMMA type	{ $$ = mklcons($3, $1); }
		|
		type COMMA type		{ $$ = ldub($3, $1); }
		;

context_or_type: LPAR types RPAR	{ $$ = mktname(tupstr($2, 0), nrev(&$2)); }
		|
		LPAR type RPAR		{ $$ = $2; }
		;


simple:		simple_or_type		{ $$ = checksimple($1); }
		;

constrs:	constrs BAR constr	{ $$ = mklcons($3, $1); }
		|
		constr			{ $$ = lsing($1); }
		;

constr:		name satypes		{ $$ = mkatc($1, nrev(&$2)); }
		|
		satype opx stype		{ $$ = mkatc($2, ldub($1, $3)); }		/* satype should be stype, but this does not parse correctly */
		;

satype:		atype			{ $$ = $1; }
		|
		atype excl		{ $$ = mktstrict($1); }
		;

stype:		type			{ $$ = $1; }
		|
		type excl		{ $$ = mktstrict($1); }
		;

excl:		AS
		;

satypes:	satypes satype		{ $$ = mklcons($2, $1); }
		|
		/* empty */		{ $$ = Lnil; }
		;

/* This very yucky, but YACC isn't powerful enough to distinguish C => T and T due to tuple types
** and parenthesised contexts */
context:	context_or_type		{ $$ = checkcontext($1); }
		|
		class			{ $$ = lsing($1); }
		;

class:		class_or_type		{ $$ = checkclass($1); }
		;

clsigns:	clsigns SEMI clsign	{ $$ = mkabind($1, $3); }
		|
		clsign			{ $$ = $1; }
		;

clsign:		names DCOLON type	{ $$ = mksbind($1, $3); }
		|
		valdef			{ $$ = $1; }
		;

funbind:	pat o_gd EQ exp o_gdfun	{ $$ = fbind($1, $2, $4, $5); adderrinfo(leftmostid($1)); }
		;

o_gd:		gd				{ $$ = $1; }
		|
		/* empty */			{ $$ = 0; }
		;
o_gdfun:	o_gdfun gdfun		{ $$ = mklcons($2, $1); }
		|
		/* empty */		{ $$ = Lnil; }
		;
apats:		apats apat		{ $$ = mklcons($2, $1); }
		|
		apat			{ $$ = lsing($1); }
		;

gdfun:		gd EQ exp		{ $$ = mklcons($1, $3); /* misuse! */ }
		;

exp:		xexp			{ $$ = checkexp($1); }
		;

/* xexps is either an expression or a pattern, use exp or epat to get the check */
xexp:		aexp			{ $$ = $1; }
		|
		xexp aexp	%prec PREC_AP	{ $$ = mkap($1, $2); }
		|
		xexp OPN0 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPN1 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPN2 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPN3 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPN4 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPN5 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPN6 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPN7 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPN8 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPN9 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPL0 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPL1 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPL2 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPL3 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPL4 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPL5 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp MINUS xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPL6 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPL7 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPL8 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPL9 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPR0 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPR1 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPR2 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPR3 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPR4 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPR5 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPR6 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPR7 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPR8 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		xexp OPR9 xexp		{ $$ = mkbinop($2, $1, $3); }
		|
		MINUS aexp %prec UMINUS	{ $$ = mkunop("_negate", $2); }
		|
		BACKSLASH apats o_gd ARROW xexp %prec PREC_LAM	{ $$ = mklams($2, $3, $5); }
		|
		IF xexp THEN xexp ELSE xexp	{ $$ = mkterop("Pif", $2, $4, $6); }
		|
		xexp WHERE LCURL decls rcurl	{ $$ = mkletv(mkrbind($4), $1); }
		|
		xexp DCOLON atype		{ $$ = mkrestr($1, $3); }
		|
		xexp DCOLON context_or_type DARROW atype { $$ = mkrestr($1, mktcontext(checkcontext($3), $5)); }
		|
		xexp DCOLON class_or_type DARROW atype	{ $$ = mkrestr($1, mktcontext(checkclass($3), $5)); }
		|
	        aexp ANNOT %prec P_ANNOT	{ $$ = mkeannot($1, $2); }
		;

aexp:		name		{ $$ = mkident($1); }
		|
		name AS apat	{ $$ = mkas($1, $3); }		/* pattern */
		|
		int		{ $$ = mkbignum($1); }
		|
		CHAR		{ $$ = mkcharr($1); }
		|
		STRING		{ $$ = mkstring($1); }
		|
		INTCONST	{ $$ = mkinteger($1); }
		|
		RATNUM		{ $$ = mkratnum($1); }
		|
    		LPAR RPAR	{ $$ = mkident("_()"); }
		|
		LPAR xexp RPAR	{ $$ = $2; }
		|
		LPAR texps RPAR	{ $$ = mktuple(nrev(&$2)); }
		|
		LBRA RBRA	{ $$ = niltree; }
		|
		LBRA xexp RBRA	{ $$ = mkcons($2, niltree); }
		|
		LBRA texps RBRA	{ $$ = mlist($2); }
		|
		LBRA xexp DOTDOT RBRA	{ $$ = mklistf(L_FROM, lsing($2)); }
		|
		LBRA xexp COMMA xexp DOTDOT RBRA	{ $$ = mklistf(L_FROM_BY, ldub($2, $4)); }
		|
		LBRA xexp DOTDOT xexp RBRA	{ $$ = mklistf(L_FROM_TO, ldub($2, $4)); }
		|
		LBRA xexp COMMA xexp DOTDOT xexp RBRA	{ $$ = mklistf(L_FROM_BY_TO, mklcons($2, ldub($4, $6))); }
		|
		LBRA xexp BAR qual RBRA	{ $$ = mklistg($2, $4); }
                |
                LBRA xexp BAR RBRA      { $$ = mklistg($2, Lnil); }
		|
		CASE xexp OF LCURL alts rcurl	{ $$ = mkcasee($2, nrev(&$5)); }
		|
    		WILD		{ $$ = mkident("_"); }			/* pattern! */
		|
		TILDE apat	{ $$ = mklazyp($2); }			/* pattern! */
		|
		LPAR xexp varop RPAR	{ $$ = mkap(mkident($3), $2); pedchk(); }
		|
		LPAR binop1 xexp RPAR	{ $$ = mksection($2, $3); pedchk(); }
		;

texps:		texps COMMA xexp		{ $$ = mklcons($3, $1); }
		|
		xexp COMMA xexp		{ $$ = ldub($3, $1); }
		;

gd:		BAR xexp			{ $$ = $2; }
		;

qual:		qualn			{ $$ = nrev(&$1); }

qualn:		qualn COMMA qual1	{ $$ = mklcons($3, $1); }
		|
		qual1			{ $$ = lsing($1); }
		;
qual1:		epat RARROW xexp	{ $$ = mkqgen($1, $3); }
		|
		xexp			{ $$ = mkqfilter($1); }
		;
epat:		xexp			{ $$ = checkpat($1); }
		;

alts:		alts SEMI alt		{ $$ = mklcons($3, $1); }
		|
		alt			{ $$ = lsing($1); }
		;

alt:		pat o_gd ARROW exp	{ $$ = mkppat(cndp($1, $2), $4); }
		;

pat:		apat			{ $$ = $1; }
		|
    		apat apats		{ $$ = mkapchain($1, $2); }
		|
		pat OPN0 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPN1 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPN2 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPN3 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPN4 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPN5 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPN6 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPN7 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPN8 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPN9 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPL0 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPL1 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPL2 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPL3 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPL4 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPL5 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat MINUS pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPL6 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPL7 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPL8 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPL9 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPR0 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPR1 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPR2 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPR3 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPR4 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPR5 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPR6 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPR7 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPR8 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		pat OPR9 pat		{ $$ = mkbinop($2, $1, $3); }
		|
		MINUS int		{ $$ = mkbignum(negbig($2)); }
		;

apat:		name			{ $$ = mkident($1); }
		|
		name AS apat		{ $$ = mkas($1, $3); }
		|
		int			{ $$ = mkbignum($1); }
		|
		RATNUM			{ $$ = mkratnum($1); }
		|
		CHAR			{ $$ = mkcharr($1); }
		|
		STRING			{ $$ = mkstring($1); }
		|
		WILD			{ $$ = mkident("_"); }
		|
		LPAR RPAR		{ $$ = mkident("_()"); }
		|
		LPAR pat RPAR		{ $$ = $2; }
		|
		LPAR tpats RPAR		{ $$ = mktuple(nrev(&$2)); }
		|
		LBRA RBRA		{ $$ = niltree; }
		|
		LBRA lpats RBRA		{ $$ = mlist($2); }
		|
		TILDE apat		{ $$ = mklazyp($2); }
		;
tpats:		tpats COMMA pat		{ $$ = mklcons($3, $1); }
		|
		pat COMMA pat		{ $$ = ldub($3, $1); }
		;
lpats:		lpats COMMA pat		{ $$ = mklcons($3, $1); }
		|
		pat			{ $$ = lsing($1); }
		;

varid:		NAME		{ $$ = $1; }
		|
		LPAR varop RPAR	{ $$ = $2; }
		;
varop:		binop1 { $$ = $1; } | MINUS{$$=$1;};
binop1:		opx { $$ = $1; } | COMMA{$$="_,"; pedchk(); };
opx:		OPN0{$$=$1;}|OPN1{$$=$1;}|OPN2{$$=$1;}|OPN3{$$=$1;}|OPN4{$$=$1;}|
		OPN5{$$=$1;}|OPN6{$$=$1;}|OPN7{$$=$1;}|OPN8{$$=$1;}|OPN9{$$=$1;}|
		OPL0{$$=$1;}|OPL1{$$=$1;}|OPL2{$$=$1;}|OPL3{$$=$1;}|OPL4{$$=$1;}|
		OPL5{$$=$1;}|OPL6{$$=$1;}|OPL7{$$=$1;}|OPL8{$$=$1;}|OPL9{$$=$1;}|
		OPR0{$$=$1;}|OPR1{$$=$1;}|OPR2{$$=$1;}|OPR3{$$=$1;}|OPR4{$$=$1;}|
		OPR5{$$=$1;}|OPR6{$$=$1;}|OPR7{$$=$1;}|OPR8{$$=$1;}|OPR9{$$=$1;};
conid:		CNAME		{ $$ = $1; };
op:		varop		{ $$ = $1; };
varcon:		varid		{ $$ = $1; } | conid { $$ = $1; };
int:		DIGIT { $$=$1; } | INT { $$=$1; };
tycon:		conid		{ $$ = $1; } ;
tyvar:		NAME		{ $$ = mktvar(typeno($1)); }

rcurl:		SEMI rcurl0	{ pedchk(); }	/* allow extra ; at the end */
		|
    		rcurl0
    		;

rcurl0:		{ wantrcurl = 1; } rcurl1 { wantrcurl = 0; }
		;

rcurl1:		RCURL
    		|
		error		{ yyerrok; popsoft(); }
    		;

%%

binding
andthem(l)
list l;
{
	if (tlist(ltl(l)) == lnil)
		return (binding)lhd(l);
	else
		return mkabind(lhd(l), andthem(ltl(l)));
}

tree
mkapchain(f, args)
tree f;
list args;
{
	if (tlist(args) == lnil)
		return f;
	else
		return mkap(mkapchain(f, ltl(args)), lhd(args));
}

tree
mlist(l)
list l;
{
	tree r;

	for(r = niltree; tlist(l) != lnil; l = ltl(l))
		r = mkcons(lhd(l), r);
	return r;
}

binding
fbind(p, gd, exp, gdl)
tree p;
tree gd, exp;
list gdl;
{
    tree t;
    pbinding pr;
    binding bl;

    t = cndp(p, gd);
    nrev(&gdl);
    bl = mkpbind(lsing(mkppat(t, exp)));
    for(; tlist(gdl) != lnil; gdl = ltl(gdl)) {
	pr = mkppat(mkcondp(p, lhd(lhd(gdl))), ltl(lhd(gdl)));
	bl = mkabind(bl, mkpbind(lsing(pr)));
    }
    return bl;
}

#if 0
id
funname(p)
pbinding p;
{
    tree t = gppat(p);
    while(ttree(t) == ap)
	t = gfun(t);
    return gident(t);
}

binding
bindl(l)
list l;
{
    /* take a list of function bindings and split it into the various functions */
    binding b, p;
    id fname;
    list fl;

	b = 0;
    while(tlist(l) != lnil) {
	fl = Lnil;
	for(fname = funname(lhd(l)); tlist(l) != lnil && strcmp(fname, funname(lhd(l))) == 0; l = ltl(l)) {
	    fl = mklcons(lhd(l), fl);
	}
	p = mkpbind(fl);
	b = b ? mkabind(p, b) : p;
    }
    return b;
}
#endif

int
allvars(l)
list l;
{
    for(; tlist(l) != lnil; l = ltl(l))
	if (tttype(lhd(l)) != tvar)
	    return 0;
    return 1;
}

ttype
checksimple(t)
ttype t;
{
    /* check that we have a type name with variables only */
    if (tttype(t) != tname || !allvars(gtypel(t)))
	syntaxerror();
    return t;
}

ttype
checkclass(t)
ttype t;
{
    list l;

    /* Check that we have a type constructor with a single type variable. */
    if (tttype(t) != tname || tlist(l = gtypel(t)) != lcons ||
	tlist(ltl(l)) != lnil || tttype(lhd(l)) != tvar)
	syntaxerror();
    return t;
}

unimpl()
{
	fprintf(stderr, "unimpl\n");
	exit(1);
}

switchtoid(i)
id i;
{
    char name[1024];
    static char *prefixes[] = { "", 0 };
    static char *suffixes[] = { "", ".hi", ".ci", 0 };
    char *p, **s, **pre;
    FILE *f;

    for(pre = prefixes; *pre; pre++) {
	strcpy(name, *pre);
	strcat(name, i+1);
	p = name + strlen(name);
	for(s = suffixes; *s; s++) {
	    strcpy(p, *s);
	    if ((f = fopen(name, "r")) != NULL) {
		pushfile(f, name);
		return;
	    }
	}
    }
    error("Cannot open interface file %s", i+1);
}

tree
mklams(l, g, e)
list l;
tree g, e;
{
    nrev(&l);
    if (tlist(ltl(l)) == lnil)
	return mklam(cndp(lhd(l), g), e);
    else
	return mklam(lhd(l), mklams(ltl(l), g, e));
}

tree
cndp(p, c)
tree p, c;
{
    return c ? mkcondp(p, c) : p;
}

list
checkcontext(t)
ttype t;
{
    /* if t is a tuple type, extract list and check parts for class satisfaction */
    /* else it must be a single class */

    if (tttype(t) == tname && gtypeid(t)[1] == '#') {
	list p;
	
	for(p = gtypel(t); tlist(p) == lcons; p = ltl(p))
	    checkclass(lhd(p));
	return gtypel(t);
    } else {
	checkclass(t);
	return lsing(t);
    }
}

finfot
finfofromstring(s)
char *s;
{
    char args[100], res[10];
    int frs;

    args[0] = res[0] = '_';
    if (sscanf(s, ",%[TF],%d", res+1, &frs) == 2) {
	return mkfinfo("_", installid(res), frs);
    } else if (sscanf(s, "%[TF],%[TF],%d", args+1, res+1, &frs) == 3) {
	return mkfinfo(installid(args), installid(res), frs);
    } else if (sscanf(s, ",%[TF]", res+1) == 1) {
	return mkfinfo("_", installid(res), UFRS);
    } else if (sscanf(s, "%[TF],%[TF]", args+1, res+1) == 2) {
	return mkfinfo(installid(args), installid(res), UFRS);
    } else {
	return mknofinfo();
    }
}

id
negbig(s)
char *s;
{
    char buf[10000];

    buf[0] = '-';
    strcpy(&buf[1], s);
    return installid(buf);
}

static tree mkcons(h, t)
tree h, t;
{
	return mkap(mkap(mkident("_:"), h), t);
}

static ttype
checkinst(t)
ttype t;
{
    list p;

    if (tttype(t) != tname) {
	syntaxerror();
	return;
    }
    for(p = gtypel(t); tlist(p) == lcons; p = ltl(p))
	if (tttype(lhd(p)) != tvar) {
	    syntaxerror();
	    return;
	}
    return t;
}

static char *
typname(t)
ttype t;
{
    switch(tttype(t)) {
    case tname:
	return gtypeid(t);
    case tcontext:
	return typname(gctype(t));
    default:
	return 0;
    }
}

