FILE *sf;

printtop(f)
FILE *f;
{
    FILE *oldsf;
    int foo[5000];

    oldsf = sf;
    sf = f;
    print(*ep++);
    sf = oldsf;
}

printi(i)
int i;
{
    fprintf(sf, "%d", i);
    if (aflag)
	putc(' ', sf);
}

printd(p)
struct {int tag, fi[2]; } *p;
{
    union { int i[2]; double d; } u;
    u.i[0] = p->fi[0]; u.i[1] = p->fi[1];
    fprintf(sf, "%g", u.d);
    if (aflag)
	putc(' ', sf);
}

static
usleep(d)
unsigned long d;
{
#ifdef SYSV
#else
    struct timeval tv;

    tv.tv_sec = d / 1000000;
    tv.tv_usec = d % 1000000;
    select(0, (int *)0, (int *)0, (int *)0, &tv);
#endif
}

#define S_NORMAL 1
#define S_NORMAL_CLOSE 2
#define S_TOFILE 3
#define S_TOFILEA 4
#define S_HIATON 5
#define S_MHIATON 6
#define S_DELAY 7
#define MAXNAME 1024
printc(c)
int c;
{
    static int state = S_NORMAL;
    static int oldstate;
    static char name[MAXNAME];
    static int ni;
    extern sigintr();

    switch (state) {
    case S_TOFILE:
    case S_TOFILEA:
	if (c == '\n') {
	    name[ni] = 0;
	    sf = fopen(name, state == S_TOFILEA ? "a" : "w");
	    if (sf == NULL) {
		fprintf(stderr, "Cannot write to %s\n", name);
		finish(1);
	    }
	    state = S_NORMAL_CLOSE;
	} else if (ni < MAXNAME-1) {
	    name[ni++] = c;
	}
	break;
    case S_HIATON:
    case S_MHIATON:
	if (c < 0)
	    Hflag = 0;
	else {
	    Hflag = 1;
	    Ttime = c;
	    MergeHiaton = state == S_MHIATON;
	}
	state = oldstate;
	break;
    case S_DELAY:
	usleep(c*1000);
	state = oldstate;
	break;
    case S_NORMAL:
    case S_NORMAL_CLOSE:
	if (c < 0) {
	    if (c == CHIATON[1]) {
		oldstate = state;
		state = S_HIATON;
	    } else if (c == CMHIATON[1]) {
		oldstate = state;
		state = S_MHIATON;
	    } else if (c == CCBREAK[1]) {
		set_tty(1);
	    } else if (c == CCOOKED[1]) {
		set_tty(0);
	    } else if (c == CCFLUSH[1]) {
		fflush(sf);
	    } else if (c == CUNBUFF[1]) {
		setbuf(sf, NULL);
	    } else if (c == CINTRON[1]) {
		signal(SIGINT, sigintr);
	    } else if (c == CINTROFF[1]) {
		signal(SIGINT, SIG_IGN);
	    } else if (c == CDELAY[1]) {
		oldstate = state;
		state = S_DELAY;
	    } else {
		if (state == S_NORMAL_CLOSE) {
		    (void)fclose(sf);
		} else {
		    (void)fflush(sf);
		}
		state = S_NORMAL;
		if (c == TOSTDOUT[1]) {
		    sf = ofiles[1];
		} else if (c == TOSTDERR[1]) {
		    sf = ofiles[2];
		} else if (c == TONEWS[1]) {
		    sf = grab_news();
		} else if (c == TOFILE[1]) {
		    state = S_TOFILE;
		    ni = 0;
		} else if (c == TOFILEA[1]) {
		    state = S_TOFILEA;
		    ni = 0;
		} else if (c == TOFILE3[1]) {
		    sf = ofiles[3];
		} else if (c == TOFILE4[1]) {
		    sf = ofiles[4];
		} else {
		    sf = 0;
		}
		if (sf == 0) {
		    fprintf(stderr, "Output to unopened file.\n");
		    finish(1);
		}
	    }
	} else {
	    putc(c, sf);
	    if (c == '\n') {		/* Line buffered output */
		fflush(sf);		/* Is this to slow ? */
	    }
	    if (aflag)
		putc(' ', sf);
	}
	break;
    default:
	fprintf(stderr, "Internal state error in print.\n");
	finish(1);
    }
}

prints(s)
char *s;
{
    fputs(s, sf);
    if (aflag)
	putc(' ', sf);
    if (index(s, '\n')) {
	fflush(sf);
    }
}

printbvek(p)
int *p;
{
    int i, j;
    fprintf(sf, "{BVEK:%d ", p[1]);
    for(i = 2; i < p[1]+2; i++){
	for(j = 0; j < 32; j++){
	    if(p[i] & (1 << j)){
		fprintf(sf, "1");
	    }else{
		fprintf(sf, "0");
	    }
	}
	fprintf(sf, " ");
    }
    fprintf(sf, "}");
}

/*ARGSUSED*/
printerr(p)
int **p;
{
    fprintf(stderr, "Illegal node to print\n");
    finish(1);
}
