module -- himport
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/types.t.t"
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../expr/pprint.t"
#include "../expr/impexp.t.t"
#include "../expr/impexp.t"
#include "../expr/einfo.t.t"
#include "../expr/constr.t.t"
#include "../misc/misc.t"
#include "../expr/tinfo.t"
#include "renameutil.t"
#include "renametype.t"
#include "renenv.t"
#include "renameclass.t"
#include "classutil.t"
#include <Option>
#include <OK>
-- Sort out the imported stuff to a module.
export genimpenv;
rec genimpenv penv (mkimport mid imports fixs oents show fltr rens) u =
	-- Filter out visible entities
	let ents = if show then expose oents fltr else oents in
        let mids = idtostr mid
        and ff = mkff Vimported mid fixs in
        let renmap = map (\(mkids s,mkids d).(s, d)) rens in
        -- Split into parts
	let types = filter istypeish ents
	and vals = filter isval ents
	and insts = filter isinst ents in
	let ns = concmap impnames imports in
	-- rens is wrong for constructors and methods!!!
        let renos xs = if null ns then xs else map (\(id as mkid _ s _ _).updorig id (assocdef s ns [])) xs in
	-- Make an environment out of the imported stuff.  Use this environment to do renaming inside.
	let rec xenv = rjoin (rlist Ktype (renos (tenvl@instl))) (rlist Kvalue (renos (venvl@conl@metl@defl)))
	and (tenvl, u1) = gentype ff env types u
	and (venvl, u2) = genval ff env vals u1
	and conl = gencon tenvl
	and metl = genmet tenvl
	and defl = gendef tenvl
	and (instl, u3) = Umap (ginst ff env) insts u2
	and env = rjoin xenv penv in

        let exenv = if null rens & ~ show & null fltr then 
	                 xenv 
		    else 
			let fltrs = map (idtostr o expid) fltr in
			let r1 = rmapfilter Kvalue (chgid renmap show fltrs) xenv in
			let r2 = rmapfilter Ktype  (chgid renmap show fltrs) r1 in
			/*rrehash*/ r2 in
--trace ("genimpenv of "@mids@show_list primpid oents@"\n"@"types="@show_list (\(s,i).s) tenvl@" vals="@show_list (\(s,i).s) venvl)
--trace("genimpenv of "@mids@show_list prid (concmap (\(mkfixid ids _).ids) fixs)@ " " @ show_list (prid o impid) oents)
--trace ("genimpenv of "@mids@" "@itos u@" "@itos (u3+1))
        let rec mid = (mkid u3 mids (idi_module (concmap (mkexpo exenv) ents)) (ff mid)) in
	(rjoin1 exenv Kmodule mid, u3+1)

-- Change an identifier according to import spec, or remove if not visible at all
and chgid rens show fltrs (mkid u s v on) =
    let m = mem s fltrs in
    if show & ~m | ~show & m then
	None
    else
	Some (mkid u (assocdef s rens s) v on)

and expose es fs = map (expose1 (map expid (filter isexpid fs))) es
and expose1 lfs (mkimpeqtype t _ od) & (mem (tname t) lfs) = mkimptype t od (0, false)
||  expose1 lfs i = i

and mkexpo env i =
    let find i = rfind Kvalue (idtostr i) env
    and findt t = rfind Ktype (idtostr (tname t)) env
    and findc c = rfind Ktype (idtostr (clsname c)) env in
    case i in
	mkimpid i _ _ : [mkexpid (find i)]
    ||  mkimptype t _ _ : [mkexpid (findt t)]
    ||  mkimpeqtype t _ _ : [mkexpidall (findt t)]
    ||  mkimpsyn t _ : [mkexpid (findt t)]
    ||  mkimpclass t mkbnull : [mkexpid (findc t)]
    ||  mkimpclass t _ : [mkexpidall (findc t)]
    ||  mkimpinstance t _ : []
    ||  mkimpimport _ _ _ : []
    ||  mkimpids is _ _ : map (mkexpid o find) is
    end
and updname (i as mkid x y z w) s = if s = y then i else mkid x s z w
and ginst ff env (mkimpinstance ot flg) u = 
	buildinstid ff u ot (renin env ot) flg

and TCLS = []
and gentype ff env types u = Umap (gent1 ff env) types u
and gent1 ff env (mkimptype t od (nc,fl)) u =
    let od' = case od in Some [] : None || Some xs : Some (map (\(mkids s).rfind Ktype s env) xs) end in	-- no auto derive
    case tpart t in
	mktcons (mkids s) tvs : 
	    let tn = rentype env t in
	    let ti = mktinfo tn nc false fl [] in
            let rec ii = mkid u s (idi_type tn (length tvs) ti TCLS od') (ff ii) in
	    (ii, u+1)
    -- Below is a special case when the unique number has already been assigned (true for P->)
    ||  mktcons i tvs : 
            let s = idtostr i in 
	    let tn = rentype env t in
	    let ti = mktinfo tn 0 false false [] in
	    let rec ii = mkid (id_no i) s (idi_type tn (length tvs) ti TCLS od') (ff ii) in
            (ii, u)
    end
||  gent1 ff env (mkimpeqtype t cs od) u =
    let od' = case od in None : Some [] || Some xs : Some (map (\(mkids s).rfind Ktype s env) xs) end in	-- no auto derive
    case tpart t in
	mktcons (mkids s) tvs : 
	    let (u1, t', cs') = renbt ff env u t cs in
	    let ti = mktinfo t' (length cs') false (isflat cs') cs' in
            let rec ii = mkid u1 s (idi_type t' (length tvs) ti TCLS od') (ff ii) in
	    (ii, u1+1)
    -- Special case again for _#
    ||  mktcons i tvs : let s = idtostr i in 
	    -- Code as above !!!
	    let (u1, t', cs') = renbt ff env u t cs in
	    let ti = mktinfo t' (length cs') false (isflat cs') cs' in
	    let rec ii = mkid (id_no i) s (idi_type t' (length tvs) ti TCLS od') (ff ii) in
	    (ii, u1)
    end
||  gent1 ff env (mkimpsyn t1 t2) u =
    case tpart t1 in
	mktcons (mkids s) tvs : 
	    let rec ii = mkid u s (idi_syn (rentype env t1) (length (getTvars t1)) (rentype env t2)) (ff ii) in
	    (ii, u+1)
    end
||  gent1 ff env (mkimpclass (cl as mkcdecl _ (mkassert (mkids s) _)) b) u =
	let rec (u1, cl', ms) = rencls env s cli u cl (flatsyns (listify b)) ff
	and cli = clsi cl' ms [] [] 0 in
        let rec ii = mkid u1 s (idi_class cli) (ff ii) in
        (ii, u1+1)
||  gent1 _ _ ii _ = fail ("No match in gent1 on :"@primpid ii)

and rencls env ms cli u (mkcdecl aas a) its f =
    let a' = rencontext env a in
    let cl' = mkcdecl (sortcon (map (rencontext env) aas)) a' in
    let rec its' = map2 (\n.\(i,tt).
			 let tt' = rentype env tt in
			 let s = idtostr i in
			 let mi = makemetid u n s cli f in
			 let ctt = mktcontype [a'] tt' in
			 let di = makedefid u n s ms ctt f in
			 (di, mi, ctt))
			(from 0) its
    in (u+length its*2, cl', its')

and genval ff env vals u = Uconcmap (genv1 ff env) vals u
and genv1 ff env (mkimpid (mkids s) t f) u = 
    let rec i = mkid u s (idi_var (var_global f) (let t' = rentype env t in Ohastype t' (getTvars t'))) (ff i) in
    ([i], u+1)

-- Special case for renamed (P#)
||  genv1 _ _ (mkimpid i _ _) u = ([i], u)

||  genv1 ff env (mkimpids is t f) u =
    let vi = idi_var (var_global f) (let t' = rentype env t in Ohastype t' (getTvars t')) in
    let f (mkids s) k = let rec ii = mkid k s vi (ff ii) in ii in
    (map2 f is (from u), u+length is)


and isflat ats = all (\(mkcons _ xs).length xs = 0) ats

and gencon sis = concmap genc1 sis
and genc1 (mkid _ _ (idi_type _ _ ti _ _) _) = map (\(mkcons i _).i) (get_cs_from_tinfo ti)
||  genc1 _ = []

and genmet sis = concmap genm1 sis
and genm1 (mkid _ _ (idi_class (clsi _ its _ _ _)) _) = map (\(_,i,_).i) its
||  genm1 _ = []
and gendef sis = concmap gend1 sis
and gend1 (mkid _ _ (idi_class (clsi _ its _ _ _)) _) = map (\(i,_,_).i) its
||  gend1 _ = []

and impnames (mkimpimport (mkids m) is iis) = map (\ei.let i = expid ei in let (mkids sn) = assocdef i iis i in (sn, [m; idtostr i])) is
and isinst (mkimpinstance _ _) = true
||  isinst _ = false
end
