module -- flag decoder
#include <OK>
export	Debug, Strict, Semistrict, Gflag, ImpDebug, Fullname, Indir, EvalOpt,
	NoC, Parallel, NoVector, Profile, NoSubst, Stingy, nuflag, Verbose,
	basename, Code, NoUnrec, Type, NoEvalupdunw, NoZeroFill, Statistics,
	InFlic, NoMOpt, TypeCheck, NoSimpl, NoStrictAnal, NoBConv, NoGOpt,
	NoNoeval, CaseOpt, NoChkInd, SparkKind, NoAsimpl, TestEval, Curry,
	EnterHole, NoElimdup, DoExtra, CopyRet, CopyIndir, NoToprec, 
	TopShow, PrOrignames, FlatNames, NoPrelude, BothTypes, AllowRedef,
	ExportCheck, Pedantic, AutoDerive, Relax,
        PrErrmap,
	PrGRCG, PrNoGcheck, PrSpillMsg, PrGBblock,
	PrInput, PrRename, PrConstr, PrRemmatch, PrRemdeep, PrAddfrom,
	PrRemSign, PrRemClass, PrRemLazy, PrGenderiv, PrRemzf, PrClasstrans,
	PrEcnv, PrType, PrApconv, PrEqtrans, PrSimpl, PrOutFlic, PrStrict,
	PrAddclose, PrLambdalift, PrBconv, PrAddarity, PrGcodeUnopt,
	PrGcode, PrMcode, PrSize, PrMtrans, PrAddrestr, PrCurry, PrPredef,
	PrGAny, PrGLive, PrGFlow, PrGContents, PrGDup, PrGSave, PrGTemp,
	PrGJoin, PrG2Op, PrGSpill,
	Test, TestN;
rec
    args = conc (filter isaflag argv)
and isaflag ('-'.c._) = ~ mem c "pf"
 || isaflag _ = false
and isflag ('-'._) = true
 || isflag _ = false
and basename =
	case filter (not o isflag) argv in
	   [] : Yes ""
	|| [name] : let n = name@".p" in
		    case openfile n in
			Yes s : Yes name
		    ||  No s : No (s@" "@n)
		    end
	|| _ : No "More than one input file"
	end
and no = chr 0
and TestN       = length (filter (\a.a="-ftest") argv)
and hasopt c	= mem c args
and has c name	= mem ('-'.'f'.name) argv | hasopt c
and phas c name	= mem ('-'.'f'.name) argv | hasopt c
and Curry	= has no "curry"
and PrCurry	= has no "pcurry"
and Debug	= has 'D' "debug"
and ImpDebug	= has 'I' "import-debug"
and Strict	= has 'S' "strict"
and Semistrict	= has 'H' "semi-strict"
and Gflag	= has 'G' "G-code"
and Fullname	= has 'Z' "fullname"
and Indir	= has 'N' "indir"
and EvalOpt	= ~has 'E' "no-eval-opt"
and NoNoeval	= has '`' "no-noeval"
and NoAsimpl	= has no "no-asimpl"
and CaseOpt	= has '|' "caseopt"
and NoC		= has 'C' "no-C-scheme"
and Parallel	= has 'P' "parallel"
and NoVector	= has 'v' "no-vector"
and Profile	= has 'p' "profile"
and NoSubst	= has 'U' "no-subst"
and Stingy	= has 'Y' "stingy"
and nuflag	= has 'V' "nu"
and Verbose	= has 'Q' "verbose"
and NoMOpt	= has 'M' "no-M-opt"
and NoUnrec	= has 'U' "no-unrec"
and NoEvalupdunw= has '*' "no-evalupdunw"
and NoChkInd	= has '"' "no-chkind"
and Type	= ~has no "no-type"
and BothTypes	= has no  "both"
and AllowRedef	= has no  "allow-redef"
and ExportCheck	= ~has no  "no-export-check"
and Statistics	= has ' ' "statistics"
and EnterHole	= has no  "enter-hole"
and TypeCheck	= Type | PrType
and NoSimpl	= has 'N' "no-simpl"
and NoStrictAnal= has 's' "no-strict-anal"
and NoBConv	= has 'B' "no-B-conv"
and NoGOpt	= has 'q' "no-G-opt"
and Code	= has 'u' "code"
and InFlic	= has 'F' "in-flic"
and NoZeroFill	= ~has no "zero-fill"
and NoElimdup	= has no "no-elimdup"
and SparkKind	= if has no "spark-call" then 'c' else if has no "no-spark" then 'n' else 'i'
and TestEval	= has no "test-eval"
and CopyRet	= ~has no "no-copy-ret"
and CopyIndir	= has no "copy-indir"
and FlatNames	= ~has no "no-flat-names"
and NoPrelude   = has no "no-prelude"
and NoToprec	= has no "no-toprec"
and Pedantic	= has no "pedantic"
and AutoDerive  = has no "auto-derive"	| Pedantic
and Relax       = has no "relax"
and PrOrignames	= phas no "orignames"
and PrAll	= phas no "all"
and PrErrmap	= phas no  "errmap"
and PrInput	= phas '1' "input"	| PrAll
and PrRename	= phas '2' "rename"	| PrAll
and PrConstr	= phas '3' "constr"	| PrAll
and PrRemmatch	= phas '4' "remmatch"	| PrAll
and PrRemSign	= phas no "rem-sign"	| PrAll
and PrRemClass	= phas no "rem-class"	| PrAll
and PrRemLazy	= phas no "rem-lazy"	| PrAll
and PrGenderiv	= phas no "genderiv"	| PrAll
and PrRemzf	= phas no "remzf"	| PrAll
and PrRemdeep	= phas '#' "remdeep"	| PrAll
and PrEcnv	= phas '5' "Ecnv"	| PrAll
and PrAddrestr	= phas no "addrestr"    | PrAll
and PrAddfrom	= phas no "addfrom"	| PrAll
and PrType	= phas '6' "ptype"	| PrAll
and PrApconv	= phas '^' "apconv"	| PrAll
and PrEqtrans	= phas '7' "eqtrans"	| PrAll
and PrClasstrans= phas no "classtrans"	| PrAll
and PrPredef	= phas no "predef"	| PrAll
and PrSimpl	= phas 'c' "simpl"	| PrAll
and PrOutFlic	= phas 'f' "out-flic"
and PrStrict	= phas '8' "pstrict"	| PrAll
and PrAddclose	= phas '9' "addclose"	| PrAll
and PrLambdalift= phas 'a' "lambdalift"	| PrAll
and PrBconv	= phas 'b' "bconv"	| PrAll
and PrAddarity	= phas 'd' "addarity"	| PrAll
and PrGcodeUnopt= phas 'h' "Gcode-unopt"	| PrAll
and PrGcode	= phas 'g' "gcode"	| PrAll
and PrMcode	= phas 'm' "mcode"	| PrAll
and PrSize	= phas 'z' "size"	| PrAll
and PrMtrans	= phas no "mtrans"	| PrAll

and TopShow	= phas no "top-show"		-- Only for interactiv

and PrGLive	= phas no "g-live"
and PrGFlow	= phas no "g-flow"
and PrGContents	= phas no "g-contents"
and PrGDup	= phas no "g-dup"
and PrGSave	= phas no "g-save"
and PrGTemp	= phas no "g-temp"
and PrGJoin	= phas no "g-join"
and PrG2Op	= phas no "g-2-op"
and PrGRCG	= phas no "g-rcg"
and PrGSpill	= phas no "g-spill"
and PrGBblock	= phas no "g-bblock"
and PrNoGcheck	= phas no "no-gcheck"
and PrSpillMsg	= phas no "spill-msg"
and PrGAny	= PrGLive|PrGFlow|PrGContents|PrGDup|PrGSave|PrGTemp|PrGJoin
and DoExtra	= (f argv
		   where rec f [] = 1
		       ||    f (x.xs) = if head 10 x = "-fdo-extra" then
			                    stoi (tail 10 x)
					else
					    f xs)
and Test        = has no "test"
end
