module
#include "../expr/constr.t.t"
#include "../Expr/Expr.t.t"
#include "../Gcode/Gcodedef.t.t"
#include "../Gcode/Gprint.t"
#include "../misc/setofid.t"
#include "../misc/flags.t"
#include "mcodedef.t.t"
#include "movetext1.t"
#include "mutil.t"
#include "mutil1.t"
#include "mstrid.t"
#include "mpush.t"
#include "meval.t"
#include "mbigop.t"
#include "mbasicop.t"
#include "mpop.t"
#include "mconstr.t"
#include "mtype.t"
#include "mmkapl.t"
#include "mconstrret.t"
#include "mcbasic.t"
#include "msplit.t"
#include "mupdate.t"
#include "mconstrupd.t"
#include "mbconstr.t"
#include "mlabel.t"
#include "mjmp.t"
#include "mjfun.t"
#include "malloc.t"
#include "mmove.t"
#include "mcase.t"
#include "mget.t"
#include "mfunstart.t"
#include "mret.t"
#include "mjglobal.t"
#include "mjmethod.t"
#include "mmemcheck.t"
#include "mspark.t"

export mmain, M;
rec 
   M t 0 (G as PUSHGLOBAL _.MKAPLV _._) V S = mmemcheck t G V S
|| M t 1 (PUSHGLOBAL i.MKAPLV m.UPDATE n.G) V S =
	M t 1 (PUSHGLOBAL i. rept m MKAP @ UPDATE n. G) V S
|| M t 1 (PUSHGLOBAL i.MKAPLV m.G) V S = mvap t G m i V S
|| M t g (PUSHGLOBAL i.G) V S = mpushglobal t g G i V S
|| M t g (PUSH n.G) V S = mpush t g G n V S
-- evalupdunw disturbs profiling
|| M t g (EVAL.UPDATE 1.UNWIND.G) V S & (~(NoEvalupdunw | Profile)) =
	mevalupdunw t g G V S

-- Here is a real hack until TJ has figured out how to do it right.
|| M t g (EVAL.(g1 as SPLIT _ _ _).G) V S =
	let l=Label (t+10000) in meval (t+1) g (JMP l.LABEL l.g1.G) V S
-- End hack.

|| M t g (EVAL.G) V S = meval t g G V S
|| M t g (TEVAL.G) V S = mteval t g G V S
|| M t g (SPARK.G) V S = mspark t g G V S
|| M t g (BIGOP op.JFALSE l.G) V S = mbigjrel t G op l V S
|| M t g (BIGOP op.G) V S = mbigop t G op V S
|| M t g (BASICOP op.JFALSE l.G) V S = mjrel t G op l V
|| M t g (BASICOP op.G) V S = mbasicop t g G op V S
|| M t g (POP n.G) V S = mpop t g G n V S
|| M t g (CONSTR (Gstring[]) _ _.G) V S = M t g (CNIL 0.G) V S
|| M t g (CONSTR (Gstring[c]) _ _.G) V S = 
		M t g (CNIL 0.CBASIC Gbchar (ord c).CPAIR 1.G) V S
|| M t g (CONSTR (Gstring (c.s)) _ _.G) V S = 
		M t g (CSTRING s.CBASIC Gbchar (ord c).CPAIR 1.G) V S
|| M t g (CONSTR Gint  x _.G) V S = M t g (CBASIC Gbint  x.G) V S
|| M t g (CONSTR Gchar x _.G) V S = M t g (CBASIC Gbchar x.G) V S
|| M t g (CONSTR Gtype v n.G) V S = M t g (mconstr v n @ G) V S
|| M t g (CONSTR (Gfloat s) _ _.G) V S = mcfloat t g G s V S
|| M t g (CONSTR (Ginteger s) _ _.G) V S = mcinteger t g G s V S

|| M t g (CNIL m.UPDATE n.POP n1.RET.G) V S &(n-1=n1) =
		mcnilret t g G m n1 V S
|| M t g (CNIL m.UPDATE n.G) V S = mcnilupdate t g G m n V S
|| M t g (CNIL m.G) V S = mcnil t g G m V S
|| M t g (CPAIR m.UPDATE n.POP n1.RET.G) V S &(n-1=n1) =
		mcpairret t g G m n1 V S
|| M t g (CPAIR m.UPDATE n.G) V S = mcpairupdate t g G (mpairtag m) n V S
|| M t 1 (CPAIR m.G) V S = mcpair t (mpairtag m) G V S
|| M t g (CTAG m.UPDATE n.POP n1.RET.G) V S &(n-1=n1) =
		mctagret t g G m n1 V S
|| M t g (CTAG m.UPDATE n.G) V S = mctagupdate t g G m n V S
|| M t 1 (CTAG m.G) V S = mctag t G m V S 
|| M t 1 (CVEK m.G) V S = mcvek t G m mvektag (const m) V S
|| M t g (MKAP.UPDATE n.G) V S = mcpairupdate t g G maptag n V S
|| M t 1 (MKAP.G) V S = mcpair t maptag G V S
|| M t g (MKAPL m.G) V S = mmkapl t g G m V S
|| M t g (CBASIC bc x.UPDATE n.POP n1.RET.G) V S &(n-1=n1) =
		mcbasicret t g G bc x n1 V S
|| M t g (CBASIC bc x.UPDATE m.G) V S = mcbasicupdate t g G bc x m V S
|| M t g (CBASIC bc x.G) V S = mcbasic t g G bc x V S
|| M t g (CSTRING s.G) V S = mcstring t g G s V S
|| M t g (SPLIT bs v n.G) V S = M t g (msplit bs v n @ G) V S
|| M t g (SPLITTAG.G) V S = msplittag t g G V S
|| M t g (SPLITPAIR b1 b2.G) V S = msplitpair t g b1 b2 G V S
|| M t g (SPLITVEK bs m.G) V S = msplitvek t g bs G m V S

|| M t g (UPDATE m.G) V S = mupdate t g G m V S
|| M t g (BCONSTR bc.UPDATE n.POP n1.RET.G) V S &(n-1=n1) =
		mbconstrret t g G bc n1 V S
|| M t g (BCONSTR bc.UPDATE m.G) V S = mbconstrupdate t g G bc m V S
|| M t 1 (BCONSTR bc.G) V S = mbconstr t G bc V S
|| M t g (LABEL l.G) V S = mlabel t G l
|| M t g (JMP l.G) V S = mjmp t G l
|| M t g (JFALSE l.G) V S = mjfalse t G V l
|| M t g (JTRUE l.G) V S = mjtrue t G V l
|| M t 1 (JFUN m.G) V S = mjfun t G m S
|| M t 1 (CALLFUN m.G) V S = mcallfun t G m V S
|| M t g (UNWIND.G) V S = munwind t G S
|| M t 1 (ALLOC(m).G) V S = malloc t G m V S
|| M t g (MOVE m.G) V S = mmove t g G m V S
|| M t g (CASE n cl ldef.G) V S = mcase t G n cl ldef V 
|| M t g (GETTAG.CASE n cl ldef.G) V S = mgettagcase t g G n cl ldef V S
|| M t g (PUSHBASIC x.G) V S = mpushbasic t g G x V S
|| M t g (GET.G) V S = mget t g G V S
|| M t g (GETTAG.G) V S = mgettag t g G V S
|| M t g (GETMETHOD k.G) V S = mgetmethod k t g G V S
|| M t g (FUNSTART i m.G) V S = mfunstart t G i m
|| M t g (SFUNSTART i m.G) V S = msfunstart t G i m
|| M t g (FUNEND.G) V S = mfunend t g G V S
|| M t g (CMVECTOR i is.G) V S = mmvector i is t g G V S
|| M t g (RET.G) V S = mret t G S
|| M t g (JGLOBAL m i.G) V S = mjglobal t G i m
|| M t g (CALLGLOBAL m i.G) V S = mcallglobal t G i m
|| M t g (SCALLGLOBAL m i.G) V S = mscallglobal t G i m
|| M t g (JMETHOD m i.G) V S = mjmethod t G i m S
|| M t g (CALLMETHOD m i.G) V S = mcallmethod t G i m S
|| M t g (AMODE _.G) V S = M t g G V S
|| M t 0 (i.G) V S = mmemcheck t (i.G) V S
|| M t g [] V S = ([], [], [], [], 0)
|| M _ g (i._) _ _ = fail ("M:g="@itos g@"g="@Gprint [i])

and mmain gcode =
	let (c, _, _, _, _) = M 0 0 gcode [] []
	in movetext1 c
end
