module
#include "../mcode/mcodedef.t.t"
#include "../mcode/mprint.t"
#include "mtrans.t"
--
-- Register allocation
-- sp	- value stack pointer
-- bp	- heap pointer
-- di	- pointer stack pointer
-- si,[abcd]x - mcode registers
-- cx	- some return values
-- bx	- scratch
-- ax	- 

#define RDX 3

export assemblercode, Aregs, Dregs, usecase, use3op,
	argcreg, tagreg, bigeqreg, indreg;
rec
    Aregs = [4; 2; RDX] @ fail "Out of A-regs"
and Dregs = [2; RDX; 4] @ fail "Out of D-regs"
and usecase max low high cnt =  cnt>=4 & (high-low)<cnt*4
and use3op = false
and argcreg = reg 2
and tagreg  = reg 2
and bigeqreg= reg 2
and indreg  = reg 4

#ifdef sun386
and trname ('_'.n) = n
||  trname n = n
#else
#define trname
#endif

and dreg    = reg 1	-- Not the best choice?
and rax     = reg 1
and rcx	    = reg 2
and rdx     = reg RDX
and Spreg   = reg Spr
and Hpreg   = reg Hpr
and Vpreg   = reg Vpr
and Hpr = 5
and Spr = 6
and Vpr = 7
and regname 0 = "%ebx"	-- make r0 an "address" reg
||  regname 1 = "%eax"
||  regname 2 = "%ecx"
||  regname RDX = "%edx"
||  regname 4 = "%esi"
||  regname 5 = "%edi"
||  regname 6 = "%ebp"
||  regname 7 = "%esp"
and bytereg r =
	case regname r in
	   [_;_;c;_] : ['%';c;'l']
	end
and
    re r c = regname r @ c

and otag oeval c = "oeval" @ c
 || otag ounwind c = "ounwind" @ c
 || otag ojfun c = "ojfun" @ c
 || otag omkapl c = "omkapl" @ c
 || otag ogettag c = "ogettag" @ c
 || otag ogc c = "ogc" @ c
 || otag ocmp c = "ocmp" @ c
 || otag oprint c = "oprint" @ c
 || otag onb c = "onb" @ c
 || otag onp c = "onp" @ c
 || otag oargs c = "oargs" @ c
 || otag ovno c = "ovno" @ c
 
and ojcc eq c = "je" @ c
 || ojcc ne c = "jne" @ c
 || ojcc lt c = "jl" @ c
 || ojcc gt c = "jg" @ c
 || ojcc le c = "jle" @ c
 || ojcc ge c = "jge" @ c
 || ojcc ltstack c = "jb" @ c
 || ojcc ltheap c = "jb" @ c
 || ojcc gtstack c = "ja" @ c
 || ojcc geheap c = "jae" @ c
 
 
and scc eq c = "sete" @ c
 || scc ne c = "setne" @ c
 || scc lt c = "setl" @ c
 || scc gt c = "setg" @ c
 || scc le c = "setle" @ c
 || scc ge c = "setge" @ c
 || scc ltstack c = "setb" @ c
 || scc ltheap c = "setb" @ c
 || scc gtstack c = "seta" @ c
 || scc geheap c = "setae" @ c
 
and oop add c = "addl" @ c
 || oop sub c = "subl" @ c
 || oop mul c = "imull" @ c
 
and 
    amode (Vp) c = "%esp" @ c
 || amode (Vind i) c = itos (4*i) @ "(%esp)" @ c
 || amode (Vrel _) c = fail "amode Srel\n"
 || amode (pushV) c = fail "amode pushV"
 || amode (popV) c = fail "amode popV"
 
 || amode (Sp) c = "%ebp" @ c
 || amode (Sind i) c = itos (4*i) @ "(%ebp)" @ c
 || amode (Srel _) c = fail "amode Srel\n"
 || amode (pushS) c = fail "amode pushS"
 || amode (popS) c = fail "amode popS"
 
 || amode (hp) c = "%edi" @ c
 || amode (hpind i) c = itos (4*i) @ "(%edi)" @ c
 || amode (hprel i) c = fail "amode hprel\n"
 || amode (tohp) c = fail "amode tohp"
 
 || amode (reg i) c = re i c
 || amode (regind r i) c = itos(4*i) @ "(" @ re r (')'.c)
 || amode (regrel _ _) c = fail "amode regrel\n"

 || amode (glob i) c = trname i @ c
 || amode (idlit s) c = '$'.trname s @ c
 || amode (retaddr s) c = '$'.trname s @ c
 || amode (const n) c = '$'.itos n @ c
 
and amode1 a1 c = amode a1 ('\n'.c)
and amode2 a1 a2 c = amode a1 (','.amode a2 ('\n'.c))
and amode3 a1 a2 a3 c = amode a1 (','.amode a2 (','.amode a3 ('\n'.c)))

and ok1 (Sp)	  = true
||  ok1 (Vp)	  = true
||  ok1 (hp)	  = true
||  ok1 (const _) = true
||  ok1 (idlit _) = true
||  ok1 (retaddr _) = true
||  ok1 (reg _)   = true
||  ok1 _         = false
and okop a1 a2 = ok1 a1 | ok1 a2
and lea  a1 (a2 as reg r) c = "\tleal\t" @ amode2 a1 a2 c
||  lea  (glob s) pushV c = push (idlit s) c
||  lea  (glob s) a2 c = move (idlit s) a2 c
||  lea  (regind r i) pushV c = push (reg r) (aop add (const (4*i)) (Vind 0) c)
||  lea  (regind r i) a2 c = move (reg r) a2 (aop add (const (4*i)) a2 c)
and move a1 a2 c & (ok1 a1) = "\tmovl\t" @ amode2 a1 a2 c
||  move a1 (a2 as reg _) c = "\tmovl\t" @ amode2 a1 a2 c
--||  move a1 a2 c = move a1 dreg (move dreg a2 c)
-- SLOW TRICK: do not destroy dreg
||  move a1 a2 c = push a1 (pop a2 c)
and push a c = "\tpushl\t"@amode1 a c
and pop a c = "\tpopl\t"@amode1 a c
and comp (a1 as reg _) (const 0) c = "\ttestl\t" @ amode2 a1 a1 c
||  comp a1 a2 c & (okop a1 a2) = "\tcmpl\t" @ amode2 a2 a1 c
||  comp a1 a2 c = move a1 dreg (comp dreg a2 c)
-- SLOW TRICK: does not destroy dreg.  Not always correct!
--||  comp a1 a2 c = xchg a1 dreg (comp dreg a2 (xchg a1 dreg c))
and xchg a1 a2 c = "\txchgl\t" @ amode2 a1 a2 c
and aop add (const 1) a1 c = "\tincl\t" @ amode1 a1 c
||  aop sub (const 1) a1 c = "\tdecl\t" @ amode1 a1 c
||  aop add (const 0) a1 c = c
||  aop sub (const 0) a1 c = c
||  aop mul (a1 as const _) (a2 as reg _) c = '\t'.oop mul ('\t'.amode3 a1 a2 a2 c)
||  aop op a1 a2 c & (okop a1 a2) = '\t'.oop op ('\t'.amode2 a1 a2 c)
||  aop op a1 a2 c = move a1 dreg (aop op dreg a2 c)

and aspr ""       ams      = ""
||  aspr ('^'.'^'.'^'.cs) (glob k.ams) = amode (glob (itos (stoi k*4+8))) (aspr cs ams)
||  aspr ('^'.'^'.cs) (glob k.ams) = amode (glob (itos (stoi k*4))) (aspr cs ams)
||  aspr ('^'.cs) (am.ams) = amode am (aspr cs ams)
||  aspr (c.cs)   ams      = c.aspr cs ams
 
and isconst (const _) = true
 || isconst _ = false

and isrdx (reg RDX) = true
 || isrdx (regind RDX _) = true
 || isrdx _ = false

and isbad x = isconst x | isrdx x

and
    ins (Mmove a Vp.c) = ins (Mmove a Vpreg.c)
 || ins (Mmove a Sp.c) = ins (Mmove a Spreg.c)
 || ins (Mmove a hp.c) = ins (Mmove a Hpreg.c)
 || ins (Mmove Vp a.c) = ins (Mmove Vpreg a.c)
 || ins (Mmove Sp a.c) = ins (Mmove Spreg a.c)
 || ins (Mmove hp a.c) = ins (Mmove Hpreg a.c)

 || ins (Mmove a pushS.c) = ins (Mmove (Srel(-1)) Sp. Mmove a (Sind 0). c)
 || ins (Mmove popS a.c) = ins (Mmove (Sind 0) a.Mmove (Srel 1) Sp.c)
 || ins (Mmove (const 0) a2.Mop2 sub a1 a2'.c) & (a2=a2') =
	move a1 a2 ("\tnegl\t" @ amode1 a2 (ins c))

 || ins (Mmove (hprel i)    a.c) = lea (regind Hpr i) a (ins c)
 || ins (Mmove (Vrel  i)    a.c) = lea (regind Vpr i) a (ins c)
 || ins (Mmove (Srel  i)    a.c) = lea (regind Spr i) a (ins c)
 || ins (Mmove (regrel r i) a.c) = lea (regind r i) a (ins c)

 || ins (Mmove popV pushV.c) = ins c
 || ins (Mmove a pushV.c) = push a (ins c)
 || ins (Mmove popV a.c) =  pop  a (ins c)

 || ins (Mmove a1 a2.c) = move a1 a2 (ins c)
 || ins (Mcalltag t r.c) = "\tcall\t*"@otag t ("("@re r (")\n" @ ins c))
 || ins (Mjumptag t r.c) = "\tjmp\t*"@otag t ("("@re r (")\n" @ ins c))
 || ins (Mjump l.c) = "\tjmp\t" @ l @ '\n'.ins c
			-- Sequent assembler bug, should be
			-- "\tjmp\t"@l"\n"@ins c
 || ins (Mjumpf l.c) = "\tleal\t"@l@",%eax\n\tjmp\t*%eax\n"@ins c
 || ins (Mjumpind a.c) = "\tjmp\t*"@amode a (ins c)
 || ins (Mcall a.c) = "\tcall\t" @ a @ '\n'.ins c
 || ins (Mcallind a.c) = "\tcall\t*"@amode a (ins c)
 || ins (Mreturn.c) = "\tret\n" @ ins c
 || ins (Mjcond cc l.c) = '\t'. ojcc cc ('\t'.l @ "\n" @ ins c)
 || ins (Mlabel l.c) = l @ ":\n" @ ins c
 || ins (Mcompare a1 a2.c) = comp a1 a2 (ins c)

 || ins (Mop3 _ _ _ _._) = fail "3-op arith"

-- div&mod could be better
 || ins (Mop2 div a1 a2.c) =
		(if a2 = rax then "" else ins [Mmove a2 rax]) @
		(if a2 = rdx then "" else push rdx "") @
		(if isbad a1 then push rcx (move a1 rcx "") else "") @
		("\tcltd\n"@
		("\tidivl\t"@amode1 (if isbad a1 then rcx else a1)
		(if isbad a1 then pop rcx "" else "") @
		((if a2 = rax then "" else ins [Mmove rax a2]) @
		(if a2 = rdx then "" else pop rdx "") @
		(ins c))))
 || ins (Mop2 mod a1 a2.c) =
		(if a2 = rax then "" else ins [Mmove a2 rax]) @
		(if a2 = rdx then "" else push rdx "") @
		(if isbad a1 then push rcx (move a1 rcx "") else "") @
		("\tcltd\n"@
		("\tidivl\t"@amode1 (if isbad a1 then rcx else a1)
		(if isbad a1 then pop rcx "" else "") @
		(if a2 = rdx then "" else move rdx a2 (pop rdx "")) @
		(ins c)))

-- || ins (Mop2 mul (a1 as reg _) a2.c) = aop mul a1 a2 (ins c)
-- || ins (Mop2 mul a1 a2.c) = move a1 dreg (aop mul dreg a2 (ins c))
 || ins (Mop2 mul a1 (a2 as reg _).c) = aop mul a1 a2 (ins c)
 || ins (Mop2 mul a1 a2.c) = move a2 dreg (aop mul a1 dreg (move dreg a2 (ins c)))

 || ins (Mop2 op a1 a2.c) = aop op a1 a2 (ins c)

 || ins (Mboolcc cc (a as reg r).c) =
	'\t'.scc cc ('\t'.bytereg r@"\n"@
	"\tandl\t" @ amode2 (const 1) a (
	ins c))
 || ins (Mboolcc cc a.c) = ins (Mboolcc cc dreg.Mmove dreg a.c)

 || ins (Mcase a l h _ ls x.c) =
 	let t = 'L'.itos x in
 	move a rax
	(let r = comp rax (const(h-l))
("\tja\t"@t@"_2\n\tjmp\t*"@t@"_1(,%eax,4)\n"
@t@"_1:\n")
	@ itlist (\l.\r."\t.long\t"@l@"\n"@r) ls (t@"_2:\n"@ins c)
	in
	if l = 0 then r else (aop sub (const l) rax r))

 || ins (Mdata.c) = "\t.data\n" @ ins c
 || ins (Mtext.c) = "\t.text\n" @ ins c
 || ins (Mword (glob  a).c) = "\t.long\t" @ trname a @ "\n" @ ins c
 || ins (Mword (idlit a).c) = "\t.long\t" @ trname a @ "\n" @ ins c
 || ins (Mword (const i).c) = "\t.long\t" @ itos i @ "\n" @ ins c
 || ins (Mfloat s.c) = "\t.double\t0D"@s@"\n" @ ins c
 || ins (Mstring s.c) = itlist (\x.\p.
 				  "\t.byte\t" @ itos(ord x)@"\n"@p) s 
				 ("\t.byte\t0\n\t.align\t2\n"@ins c)
 				
 || ins (Mexport a.c) = "\t.globl\t" @ a @ "\n" @ ins c
 || ins (Mcom s.c) = "/ " @ s @ "\n" @ ins c
 || ins (Masm s l.c) = aspr s l @ "\n" @ ins c
 || ins (Malign.c) = "\t.align\t2\n" @ ins c
 || ins (Mfunbegin _.c) = ins c
 || ins (Mfunend .c) = ins c
 || ins [] = []
 || ins (m._) = fail ("ins: strange Mcode " @ mprint [m])

and prel = ".file \"unknown\"\n.set oeval,0\n.set ounwind,4\n.set ojfun,8\n.set omkapl,12\n.set ogettag,16\n.set ogc,20\n.set ocmp,24\n.set oprint,28\n.set ospark,32\n"
and assemblercode m = prel @ ins (mtrans m)

end
