/*
 * LML compiler front end for cray machine
 */

#include <stdio.h>
#include <signal.h>
#ifdef SYSV
union wait	{
    int	w_status;		/* used in syscall */
    /*
     * Terminated process status.
     */
    struct {
	unsigned short	w_Termsig:7;	/* termination signal */
	unsigned short	w_Coredump:1;	/* core dump indicator */
	unsigned short	w_Retcode:8;	/* exit code if w_termsig==0 */
    } w_T;
} w_S;
#define	w_termsig	w_T.w_Termsig
#define w_coredump	w_T.w_Coredump
#define w_retcode	w_T.w_Retcode

#define vfork() fork()
#else
#include <sys/wait.h>
#endif
extern char *getenv(/* char * */);
extern char *malloc(/* unsigned */);
extern char *mktemp(/* char * */);
extern char *strcat(/* char *, char * */);
extern char *strcpy(/* char *, char * */);
extern char *index(/* char *, int */);
extern char *rindex(/* char *, int */);
#define LMLDIR "LMLDIR"			/* Environment name of lml directory */
#define VLMLDIRDEF "/usr/local/lib/vlmlc"	/* Default place to look */
#define VLMLENV "LMLDIR=/usr/local/lib/vlmlc"	/* should be LMLDIR=LMLDIRDEF */
#define LMLDIRDEF "/usr/local/lib/lmlc"	/* Default place to look */
#define LMLENV "LMLDIR=/usr/local/lib/lmlc"	/* should be LMLDIR=LMLDIRDEF */
#define TMPNAME "/tmp/lmlcXXXXXX"	/* Temp name template */
#define AOUT "a.out"
#define CPP "/lib/cpp"			/* preprocessor */
#define AS "/bin/as"			/* assembler */
#define GAS "/usr/pd/gas"
#ifdef CRAY
#define LD "/bin/cc"			/* linker */
#else
#define LD "/bin/ld"                    /* linker */
#endif
#define Strcpy(a,b) (void)strcpy(a,b)
#define Strcat(a,b) (void)strcat(a,b)
#define Malloc(u) malloc((unsigned)(u))
#define Fflush(f) (void)fflush(f)
#define Fclose(f) (void)fclose(f)
    
char *prefix,				/* Where to look for things */
     *lib = "/lib",			/* directory for runtime stuff & standard functions */
    *clib = "/hlib",			/* directory for runtime stuff & standard functions */
    *include = "/include",		/* include files */
    *parse = "/bin/lmlp",		/* parser */
    *cparse = "/bin/curryp",		/* parser */
    *comp = "/bin/lmlcomp",		/* compiler */
    *runtime = "/runtime.o",		/* runtime routines */
    *runtime_p = "/runtime_p.o";	/* profile runtime routines */
#ifdef CRAY
char *rt2[] = {"/crun.o", "/rtcray.o", "\0"};
#else
char *rt2[] = { "\0" };
#endif
char   *liba   = "/lib.a";			/* standard functions */
char   *liba_p = "/lib_p.a";		/* profile standard functions */
#ifndef CRAY
char *libc = "-lc",			/* C library */
    *libm = "-lm",		        /* C math library */
    *libc_p = "-lc_p",			/* C profile library */
    *libm_p = "-lm_p",		        /* C math library */
    *libg = "-lg",			/* Debug library */
    *libpps = "-lpps",			/* Parallel library */
    *libseq = "-lseq",			/* Parallel library */
#ifdef SUNOS40
    *crt0 = "/usr/lib/crt0.o",		/* C startup */
    *crt0_p = "/usr/lib/mcrt0.o",	/* C profiling startup */
    *crt0_pg = "/usr/lib/gcrt0.o",	/* C profiling startup */
    *crt1 = "/usr/lib/Mcrt1.o";		/* more startup */
#else /* SUNOS40 */
    *crt0 = "/lib/crt0.o",		/* C startup */
    *crt0_p = "/lib/mcrt0.o",		/* C profiling startup */
    *crt0_pg = "/usr/lib/gcrt0.o";	/* C profiling startup */
#endif /* SUNOS40 */
#endif /* CRAY */

char *tmppre = TMPNAME;			/* temp name prefix */
char *tmps, *tmpm, *tmpi, *tmpp, *tmpt, *tmpg, *tmpot;
char *prog;				/* program name */
char *outfile = AOUT;			/* name of result */
char **lmlenv;				/* environment with LMLDIR */
int cflag = 0;				/* separate compilation */
int Sflag = 0;				/* keep .s file */
int Gflag = 0;				/* keep .g file */
int gflag = 0;				/* link for debug */
int tflag = 1;				/* do typechecking */
int verbose = 0;			/* verbose front end */
int pflag = 0;				/* do profiling */
int pgflag = 0;				/* do graph profiling */
int bothtypes = 0;			/* print both import files */
int pedantic = 0;			/* be fuzzy about Haskell */
#ifdef vG
int nuflag = 1;
int Pflag = 0;				/* parallel version of the code */
int statistics = 0;
#else
int nuflag = 0;
int Pflag = 0;				/* parallel version of the code */
int statistics = 0;
#endif
int xflag = 0;				/* Use a compiler program other
					   that the production one */
int curry = 0;				/* compile curry instead */
int bad = 0;
int usegas = 0;

#define MAXARGS 500
struct args {
    int nflags;
    char *flags[MAXARGS];
    int nargs;
    char *args[MAXARGS];
};

struct args ppargs = { 1, {"-C"}, 0, {0}};
#ifdef SYSV
struct args ldargs = { 0, {0}, 0, {0} };
#else /* SYSV */
#ifdef SUNOS40
#ifdef mc68000
struct args ldargs = { 6, {"-dc", "-dp", "-e", "start", "-X", "-L/usr/lib/f68881" }, 0, {0} };
#endif
#ifdef sparc
struct args ldargs = { 5, {"-dc", "-dp", "-e", "start", "-X"}, 0, {0} };
#endif
#ifdef sun386
struct args ldargs = { 5, {"-dc", "-dp", "-e", "_start", "-X"}, 0, {0} };
#endif
#else /* SUNOS40 */
struct args ldargs = { 1, {"-X"}, 0, {0} };
#endif /* SUNOS40 */
#endif /* SYSV */
struct args ldeargs = { 0, {0}, 0, {0} };
struct args asargs = { 1, {"-o"}, 0, {0} };
struct args cargs  = { 0, {0}, 1, {"-"} };
struct args pargs  = { 0, {0}, 0, {0} };
struct args rmargs = { 0, {0}, 0, {0} };

/*VARARGS2*/
error(ecode, msg, a1, a2, a3)
char *msg;
{
    fprintf(stderr, "%s: ", prog);
    fprintf(stderr, msg, a1, a2, a3);
    fprintf(stderr, "\n");
    if (ecode) {
	unlinkfiles();
	exit(ecode);
    }
}

addflag(ap, str)
struct args *ap;
char *str;
{
    if (ap->nflags >= MAXARGS)
	error(1, "Too many arguments");
    ap->flags[ap->nflags++] = str;
}

addarg(ap, str)
struct args *ap;
char *str;
{
    if (ap->nargs >= MAXARGS)
	error(1, "Too many arguments");
    ap->args[ap->nargs++] = str;
}

addarga(ap, str)
struct args *ap;
char *str;
{
    char *p;
    
    p = Malloc(strlen(str) + 1);
    if (p == 0)
	error(1, "Out of memory.");
    Strcpy(p, str);
    addarg(ap, p);
}

delarg(ap, n)
struct args *ap;
{
    ap->nargs -= n;
}

delflag(ap, n)
struct args *ap;
{
    ap->nflags -= n;
}

char *
setprefix(p, d)
char *p, *d;
{
    char *t;
    t = Malloc(strlen(p)+strlen(d)+1);
    if (t == 0)
	error(1, "Out of memory.");
    Strcpy(t, p);
    Strcat(t, d);
    return t;
}

intr()
{
    unlinkfiles();
    exit(1);
}

init()
{
    extern char **environ;
    int i;
    
    prefix = getenv(LMLDIR);
    if (prefix == 0) {
	prefix = nuflag ? VLMLDIRDEF : LMLDIRDEF;
	for(i = 0; environ[i] != 0; i++)
	    ;
	lmlenv = (char **)malloc((i+2)*sizeof(char *));
	lmlenv[0] = nuflag ? VLMLENV : LMLENV;
	for(i = 0; lmlenv[i+1] = environ[i]; i++)
	    ;
    } else {
	lmlenv = environ;
    }
    if (curry) {
        parse = setprefix(prefix, cparse);
	lib = setprefix(prefix, clib);
    } else {
        parse = setprefix(prefix, parse);
	lib = setprefix(prefix, lib);
    }
    if(!xflag)
	comp = setprefix(prefix, comp);
    (void)mktemp(tmppre);
    tmps = setprefix(tmppre, ".s");
    tmpm = setprefix(tmppre, ".m");
    tmpi = setprefix(tmppre, ".i");
    tmpp = setprefix(tmppre, ".p");
    tmpt = setprefix(tmppre, ".t");
    tmpot = setprefix(tmppre, ".ot");
    tmpg = setprefix(tmppre, ".g");
    include = setprefix(lib, include);
    runtime = setprefix(lib, pflag ? runtime_p : runtime);
    { int i;
      for(i=0;*(rt2[i]);i++)
	rt2[i] = setprefix(lib, rt2[i]);
    }
    liba = setprefix(lib, pflag ? liba_p : liba);
#ifndef CRAY
    crt0 = pflag ? (pgflag ? crt0_pg : crt0_p) : crt0;
    libc = pflag ? libc_p : libc;
    libm = pflag ? libm_p : libm;
#endif
    addarg(&ppargs, setprefix("-I", include));
}

xsignal(s)
{
    if (signal(s, SIG_IGN) != SIG_IGN)
	(void)signal(s, intr);
}

main(argc, argv)
int argc;
char *argv[];
{
    prog = argv[0];
    {
	char *p;
	p = rindex(prog, "/");
	if (!p)
	    p = prog;
	if (strcmp(p, "hbc") == 0)
	    curry++;
    }
    xsignal(SIGINT);
    xsignal(SIGHUP);
    xsignal(SIGTERM);
    if (argv[0][0] == 'v')
	nuflag++;
    argc--, argv++;
    while (argc && argv[0][0] == '-') {
	while (*++*argv) {
	    if (strcmp(*argv, "-pedantic") == 0) {
		pedantic++;
		goto nextarg;
	    }
	    switch(**argv) {
	    case 'C':
		curry++;
		break;
	    case 'n':
		if (strcmp(*argv, "nuG") == 0 || strcmp(*argv, "nu") == 0) {
		    nuflag++;
		    goto nextarg;
		} else
		    goto badarg;
	    case 'w':	/* compiler debug flags */
		addarg(&cargs, "-Pall");
		break;
	    case 'c':
		cflag++;
		break;
	    case 'o':
		if (--argc <= 0)
		    error(1, "-o name missing");
		outfile = *++argv;
		goto nextarg;
	    case 'S':
		Sflag++;
		break;
	    case 'G':
		Gflag++;
		break;
	    case 'v':
		verbose++;
		addarg(&cargs, "-fverbose");
		break;
	    case 'P':
		Pflag ^= 1;
		break;
	    case 't':
		tflag = 0;
		break;
	    case 'Z':
		addflag(&pargs, "-Z");
		addarg(&cargs, "-ffullname");
		break;
	    case 'z':
		addflag(&pargs, "-z");
		break;
	    case 'H':
		addflag(&cargs, *argv-1);
		goto nextarg;
	    case 'D':
	    case 'I':
		addflag(&ppargs, *argv-1);
		goto nextarg;
	    case 'f':
		if (strcmp(*argv-1, "-fboth") == 0)
		    bothtypes++;
		addarg(&cargs, *argv-1);
		goto nextarg;
	    case 'X':
		addarg(&cargs, *argv+1);
		goto nextarg;
	    case 'Y':
		addflag(&cargs, *argv+1);
		goto nextarg;
	    case 'p':
		pflag++;
		if (argv[0][1] == 'g') {
		    pgflag++;
		    goto nextarg;
		}
		break;
	    case 'x':
		xflag++;
		if (--argc <= 0)
		    error(1, "-x name missing");
		comp = *++argv;
		goto nextarg;
	    case 'g':
		gflag++;
		break;
	    case 'a':
		statistics ^= 1;
		break;
	    default:
	badarg:
		fprintf(stderr, "Strange flag %s\n", *argv);
		goto nextarg;
	    }
	}
    nextarg:
	argc--, argv++;
    }
    if (pedantic) {
	addarg(&cargs, "-fpedantic");
	addarg(&pargs, "-P");
    }
    if (Pflag)
	nuflag++;
    if (getenv("nuG"))
	nuflag++;
    if (nuflag) {
/*	statistics ^= 1;*/
	addarg(&cargs, "-fnu");
/*	usegas++;*/
    }
    if (Pflag)
	addarg(&cargs, "-fparallel");
    if (statistics)
	addarg(&cargs, "-fstatistics");
    init();
    if (tflag)
	addarg(&cargs, "-ftype");
    else
	addarg(&cargs, "-fno-type");
    if (Gflag)
	addarg(&cargs, "-fG-code");
    else
	addarg(&cargs, "-fcode");
    if (pflag) {
	addarg(&cargs, "-fprofile");
    }
    if (curry) {
	addarg(&cargs, "-fcurry");
    }
#ifndef CRAY
    addarg(&ldargs, crt0);
#endif
#if defined(SUNOS40) && defined(sun3)
    addarg(&ldargs, crt1);
#endif /* SUNOS40 */
    addarg(&ldargs, runtime);
    {int i;
     for(i=0;*(rt2[i]);i++)
       addarg(&ldargs, rt2[i]);
    }
    while(--argc >= 0)
	processfile(*argv++);
    if (!bad && !cflag && !Sflag && !Gflag)
	linkit();
    rmofiles();
    unlinkfiles();
    exit(bad);
}

unlinkfiles()
{
    (void)unlink(tmps);
    (void)unlink(tmpi);
    (void)unlink(tmpp);
    (void)unlink(tmpt);
    (void)unlink(tmpm);
    (void)unlink(tmpg);
    (void)unlink(tmpot);
}

linkit()
{
    int i;

#ifndef CRAY
    if (gflag) {
	addarg(&ldargs, libg);
    }
#endif
#ifdef sequent
    if (Pflag) {
	addarg(&ldargs, libpps);
    }
#endif
    addarg(&ldargs, liba);
    for(i = 0; i < ldeargs.nargs; i++)
	addarg(&ldargs, ldeargs.args[i]);
#ifdef sequent
    addarg(&ldargs, libseq);
#endif
#ifndef CRAY
    addarg(&ldargs, libm);
    addarg(&ldargs, libc);
#endif
    addflag(&ldargs, "-o");
    addflag(&ldargs, outfile);
    (void)run(LD, &ldargs);
}

rmofiles()
{
    int i;
    
    for(i = 0; i < rmargs.nargs; i++)
	(void)unlink(rmargs.args[i]);
}

#define PLMLSRC 0
#define PHASKELLSRC 1
#define POBJ 2
#define PASSRC 3

int
splitname(src, dst)
char *src, *dst;
{
    char *p;

    Strcpy(dst, src);
    if (p = rindex(dst, '.')) {
	*p++ = 0;
	if (strcmp(p, "m") == 0)
	    return PLMLSRC;
	else if (strcmp(p, "hs") == 0 || strcmp(p, "has") == 0)
	    return PHASKELLSRC;
	else if (strcmp(p, "s") == 0)
	    return PASSRC;
	else {
	    return -1;
	}
    } else {
	return -1;
    }
}

processfile(name)
char *name;
{
    char fname[1024], *suf, *osuf;

    switch(splitname(name, fname)) {
    case PHASKELLSRC:
	suf = "hi";
	osuf = "t";
	goto comp;
    case PLMLSRC:
	suf = "t";
	osuf = "hi";
    comp:
	if (!lmlfile(name)) {
	    if (Gflag) {
		Strcat(fname, ".g");
		copy(tmpg, fname, "w");
	    } else if (Sflag) {
		Strcat(fname, ".s");
		copy(tmps, fname, "w");
	    } else {
		Strcat(fname, ".o");
		if (!asmfile(tmps, fname))
		    ofile(fname);
	    }
	    strcpy(&fname[strlen(fname)-1], suf);
	    if (!equalfiles(tmpt, fname)) {
		copy(tmpt, fname, "w");
	    }
	    if (bothtypes) {
		strcpy(rindex(fname, '.')+1, osuf);
		if (!equalfiles(tmpot, fname)) {
		    copy(tmpot, fname, "w");
		}
	    }
	}
	break;
    case PASSRC:
	Strcat(fname, ".o");
	if (!asmfile(name, fname))
	    ofile(fname);
	break;
    default:
	if (strncmp(name, "-l", 2) == 0)
	    addarga(&ldeargs, name);
	else
	    addarga(&ldargs, name);
	break;
    }
}

ofile(s)
char *s;
{
    addarga(&ldargs, s);
    if (!cflag)
	addarga(&rmargs, s);
}

copy(from, to, mode)
char *from, *to, *mode;
{
    FILE *f, *t;
    int n;
    char buff[1024];
    
    if ((f = fopen(from, "r")) == NULL)
	error(1, "Cannot open %s", from);
    if ((t = fopen(to, mode)) == NULL)
	error(1, "Cannot open %s", to);
    while(n = fread(buff, 1, sizeof buff, f))
	(void)fwrite(buff, 1, n, t);
    Fclose(f);
    Fclose(t);
}

equalfiles(from, to)
char *from, *to;
{
    register int r, i;
    register int nf, nt;
    register FILE *f, *t;
    char fbuff[1024], tbuff[1024];
    
    if ((t = fopen(to, "r")) == NULL)
	return 0;
    if ((f = fopen(from, "r")) == NULL)
	error(1, "Cannot open %s", from);
    for(;;) {
	nf = fread(fbuff, 1, sizeof fbuff, f);
	nt = fread(tbuff, 1, sizeof tbuff, t);
	if (nf != nt) {
	    r = 0;
	    break;
	}
	if (nf == 0) {
	    r = 1;
	    break;
	}
	for(i = 0; i < nf; i++) {
	    if (fbuff[i] != tbuff[i]) {
		r = 0;
		break;
	    }
	}
	if (i != nf)
	    break;
    }
    Fclose(f);
    Fclose(t);
    return r;
}

asmfile(name, oname)
char *name, *oname;
{
    int r;
    
    addarg(&asargs, oname);
    addarg(&asargs, name);
    r = run(usegas ? GAS : AS, &asargs);
    delarg(&asargs, 2);
    return r;
}

lmlfile(name)
char *name;
{
    int r;
    
    addarg(&ppargs, name);
    addarg(&ppargs, tmpm);
    r = run(CPP, &ppargs);
    delarg(&ppargs, 2);
    if (r) return r;
    
    addarg(&pargs, tmpm);
    addarg(&pargs, tmpp);
    r = run(parse, &pargs);
    delarg(&pargs, 2);
    if (r) return r;
    
    addarg(&cargs, tmppre);
    r = run(comp, &cargs);
    delarg(&cargs, 1);
    
    return r;
}

run(name, ap)
char *name;
struct args *ap;
{
    char *args[2*MAXARGS+1];
    int i, j, r;
    
    i = 0;
    args[i++] = name;
    for(j = 0; j < ap->nflags; j++)
	args[i++] = ap->flags[j];
    for(j = 0; j < ap->nargs; j++)
	args[i++] = ap->args[j];
    args[i] = 0;
    if (verbose) {
	for(j=0; j<i; j++)
	    fprintf(stderr, "%s ", args[j]);
	fprintf(stderr, "\n");
    }
    r = callsys(name, args);
    bad |= r;
    return r;
}

callsys(f, v)
char *f, **v;
{
    int t;
    union wait st;

    t = vfork();
    if (t == -1) {
	error(1, "No more processes\n");
    }
    if (t == 0) {
	execve(f, v, lmlenv);
	fprintf(stderr, "Can't find %s\n", f);
	Fflush(stdout);	/* ??? */
	_exit(100);
    }
    while (t != wait(&st))
	;
    if (st.w_termsig != 0) {
	if (st.w_termsig != SIGINT) {
	    error(0, "Fatal error in %s\n", f);
	}
	return 1;
    }
    return st.w_retcode;
}
