/*
** Implementaion of encode/decode operations.
*/

#include <stdio.h>

#if defined(sequent) || defined(sun) || defined(mips)
#define IEEE
#endif
#if defined(sun)
#define BIGENDIAN
#endif

#ifdef BIGENDIAN
#define L 1
#define H 0
#else
#define L 0
#define H 1
#endif

#include "apm.h"
double frexp(), ldexp();

extern int *DFLOAT[], *PAIR0[], *BIGNUM[], *INT[];
extern int **mknode(), **mknode1();

/*
** Encode a mantissa (an Integer) and an exponent (an Int) as a floating point number.
** f = mant * 2^expo
** This operation is not as efficient as it coule be, but it's portable.
*/
int **
dencode(expo, mant)
int **mant, **expo;
{
    int iexp = (int)expo[1];		/* The exponent as an int */
    APM man = (APM)mant[1];		/* The mantissa as a bignum */
    union { double d; int i[2]; } u;
    double r;
    double base = BASE;
    int i;
    int e;
    
    /* Convert bignum to a double */
    for(r = 0.0, i = man->length-1; i >= 0; i--)
	r = r * base + man->data[i];
    /* Load new exponent */
/*printf("dencode ldexp %g %d\n", r, iexp);*/
    r = ldexp(r, iexp);
    if (man->sign < 0)
	r = -r;
    u.d = r;
    return mknode(DFLOAT, u.i[0], u.i[1]);
}

#ifdef IEEE
/* divide the long long number h,l by n. Return remainder and leave quotient in place. */
/* n must be < 65536 !!! */
static int
ldiv(hp, lp, n)
long *lp, *hp, n;
{
    unsigned short s2;
    int t, s1;

    s2 = *hp % n;
    *hp /= n;
    t = (s2 << 16) + ((*lp >> 16) & 0xffff);
    s1 = t / n;
    t = ((t % n) << 16) + (*lp & 0xffff);
    *lp = (s1 << 16) + t / n;
    return t % n;
}
#endif

/*
** Decode a floating point number into a mantissa an an exponent.
** This operation is tricky to do in a portable and efficient way!
** Current implementation is really bad!
*/
#define NBIGIT 4		/* max number of bigits to store the number */
int **
ddecode(p)
struct { int **t; int fi[2]; } *p;
{
#ifdef IEEE
    /* Do some bit fiddling on IEEE */
    int low, high, iexp, sign;
    APM man;
    int **bman;

    low = p->fi[L];
    high = p->fi[H];
    man = apm_alloc(NBIGIT);
    man->sign = 1;
    if (low == 0 && high == 0) {
	man->length = 0;
	iexp = 0;
    } else {
	man->length = 4;
	iexp = ((high >> 20) & 0x7ff) - 1024 - 51;
	sign = high;
	high = (high & 0x000fffff) | 0x00100000;
	man->data[0] = ldiv(&high, &low, BASE);
	man->data[1] = ldiv(&high, &low, BASE);
	man->data[2] = ldiv(&high, &low, BASE);
	man->data[3] = ldiv(&high, &low, BASE);
	if (sign < 0)
	    man->sign = -1;
    }
#else
    union { double d; int i[2]; } u;
    double r, sc;
    int iexp;
    APM man;
    int i, b;
    double base = BASE;
    int **bman;

    u.i[0] = p->fi[0]; u.i[1] = p->fi[1];
    r = u.d;

/*printf("ddecode r=%g\n", r);*/
    man = apm_alloc(NBIGIT);
    man->sign = 1;
    if (r == 0.0) {
	man->length = 0;
	iexp = 0;
    } else {
	man->length = NBIGIT;
	if (r < 0.0) {
	    man->sign = -1;
	    r = -r;
	}
	for(sc = 1.0, i = 0; i < NBIGIT; i++)
	    sc *= base;
	r /= sc;
/*printf("ddecode / r=%g\n", r);*/
	r = frexp(r, &iexp);
/*printf("ddecode frexp r=%g, iexp=%d\n", r, iexp);*/
	for(i = NBIGIT-1; i >= 0; i--) {
	    r *= base;
	    b = (int)r;
/*printf("ddecode r=%g b=%d\n", r, b);*/
	    man->data[i] = b;
	    r -= b;
	}
	if (r >= 0.5)
	    man->data[0]++;
    }
#endif
    apm_trim(man);
    bman = mknode1(BIGNUM, man);
/*printf("ddecode man="); fprintb(stdout, bman); printf("\n");*/
    return mknode(PAIR0, bman, mknode1(INT, iexp));
}
