#ifdef sparc
#include <alloca.h>
#endif

#include "apm.h"

APM
apm_add(num1, num2)
APM num1;
APM num2;
{
    int length1;
    int length2;
    int len;
    int n;
    short sign;
    short tempval;
    short carry;
    short c1;
    short c2;
    short base = BASE;
    APM result;

    if (num1->sign < 0 && num2->sign >= 0) {
	num1->sign = 1;
	result = apm_sub(num2, num1);
	num1->sign = -1;
	return result;
    }
    else if (num1->sign >= 0 && num2->sign < 0) {
	num2->sign = 1;
	result = apm_sub(num1, num2);
	num2->sign = -1;
	return result;
    }

    sign = num1->sign;

    length1 = num1->length;
    length2 = num2->length;
	
    if (length1 > length2)
	len = length1;
    else
	len = length2;

    len++;
    result = apm_alloc(len);

    carry = 0;
    for (n = 0; n < len - 1; ++n) {
	if (n >= length1) {
	    c1 = 0;
	} else {
	    c1 = num1->data[n];
	}
	if (n >= length2) {
	    c2 = 0;
	} else {
	    c2 = num2->data[n];
	}
	tempval = c1 + c2 + carry;
	result->data[n] = tempval % base;
	carry = tempval / base;
    }

    result->data[n] = carry;
    result->length = len;
    result->sign = sign;
    apm_trim(result);

    return result;
}

APM
apm_sub(num1, num2)
APM num1;
APM num2;
{
    int length1;
    int length2;
    int len;
    int n;
    short tempval;
    short borrow;
    short c1;
    short c2;
    short base = BASE;
    APM result;

    if (num1->sign < 0 && num2->sign >= 0) {
	num1->sign = 1;
	result = apm_add(num2, num1);
	num1->sign = -1;
	result->sign = -result->sign;
	return result;
    } else if (num1->sign >= 0 && num2->sign < 0) {
	num2->sign = 1;
	result = apm_add(num1, num2);
	num2->sign = -1;
	return result;
    }

    length1 = num1->length;
    length2 = num2->length;
	
    if (length1 > length2)
	len = length1;
    else
	len = length2;

    len++;
    result = apm_alloc(len);

    borrow = 0;
    for (n = 0; n < len - 1; ++n) {
	if (n >= length1) {
	    c1 = 0;
	} else {
	    c1 = num1->data[n];
	}
	if (n >= length2) {
	    c2 = 0;
	} else {
	    c2 = num2->data[n];
	}
	tempval = (c1 + borrow) - c2;
	if (tempval < 0) {
	    borrow = -1;
	    tempval += base;
	}
	else {
	    borrow = 0;
	}
	result->data[n] = tempval;
    }

    if (borrow == 0) {
	result->data[n] = 0;
	result->length = len;
	result->sign = 1;
    }
    else {
	int carry = 1;
	int basem1 = base - 1;
	result->data[n] = basem1;
	for (n = 0; n < len; ++n) {
	    int value = result->data[n];
	    value = (basem1 - value) + carry;
	    result->data[n] = value % base;
	    carry = value / base;
	}
	result->sign = -1;
    }

    if (num1->sign < 0) {
	result->sign = -(result->sign);
    }

    result->length = len;
    apm_trim(result);

    return result;
}

APM
apm_mul(num1, num2)
APM num1;
APM num2;
{
    int length1;
    int length2;
    int len;
    int n1;
    int n2;
    int sum;
    short sign;
    short base = BASE;
    short carry;
    long tempval;
    APM result;

    sign = num1->sign * num2->sign;

    length1 = num1->length;
    length2 = num2->length;
	
    len = length1 + length2;
    result = apm_alloc(len);

    apm_zero_shorts(result->data, len);

    for (n1 = 0; n1 < length1; ++n1) {
	carry = 0;
	sum = n1;
	for (n2 = 0; n2 < length2; ++n2, ++sum) {
	    tempval = num1->data[n1];
	    tempval *= num2->data[n2];
	    tempval += result->data[sum] + carry;
	    result->data[sum] = tempval % base;
	    carry = tempval / base;
	}
	result->data[sum] = carry;
    }

    result->length = len;
    result->sign = sign;
    apm_trim(result);

    return result;
}

#define short_alloc(n) ((short *)alloca(((n)*sizeof(short))))

/*
 * For division, I use the algorithm described in Knuth, "The Art of
 * Computer Programming, Volume 2, Seminumerical Algorithms", second
 * edition, pp. 255-260.
 */
int
apm_div(resultp, remainderp, num1, num2)
APM *resultp;
APM *remainderp;
APM num1;
APM num2;
{
    APM temp;
    short *dividend;
    short *divisor;
    short *xdivisor;

    int i;
    int j;
    int n;
    int uJ;
    int vJ;
    int M;
    int N;
    int MplusN;
    int Nplus1;
    int MplusNplus1;
    int length1;
    int length2;
    int offset;
    int left;
    int frac;
    short divN1;
    short divN2;
    short sign;
    short base;
    short scaleFactor;
    short borrow;
    short qHat;
    long temp1;
    long temp2;
    long temp3;

    base = BASE;

    if (num2->length <= 0) {
	/*
	 * Division by zero.
	 */
	APM result = apm_alloc(0);
	result->length = 0;
	result->sign = 1;
	*resultp = result;
	if (remainderp)
	    *remainderp = result;
	return 0;
    }

    if (num1->length <= 0) {
	/*
	 * Dividend is zero, so result is zero.
	 */
	APM result = apm_alloc(0);
	result->length = 0;
	result->sign = 1;
	*resultp = result;
	if (remainderp)
	    *remainderp = result;
	return 1;
    }

    sign = num1->sign * num2->sign;

    length1 = num1->length;
    length2 = num2->length;

    if (length2 == 1) {
	/* Small divisor */
	int divis;

	temp = apm_alloc(length1);
	divis = num2->data[0];
	temp1 = 0;
	for(i = length1 - 1; i >= 0; i--) {
	    temp1 = temp1 * base + num1->data[i];
	    temp->data[i] = temp1 / divis;
	    temp1 %= divis;
	}
	temp->length = length1;
	temp->sign = sign;
	*resultp = temp;
	apm_trim(temp);
	if (remainderp) {
	    temp = apm_alloc(1);
	    temp->data[0] = temp1;
	    temp->length = 1;
	    temp->sign = num2->sign;
	    apm_trim(temp);
	    *remainderp = temp;
	}
	return 1;
    }

    if (length1 < length2) {
	/* No use to divide */
	APM result = apm_alloc(0);
	result->length = 0;
	result->sign = 1;
	*resultp = result;
	if (remainderp)
	    *remainderp = num1;
	return 1;
    }

    N = length2;
    M = length1 - N;

    Nplus1 = N + 1;
    MplusN = M + N;
    MplusNplus1 = MplusN + 1;

    temp = apm_alloc(M);

    dividend = short_alloc(MplusNplus1);

    divisor = short_alloc(Nplus1);
    xdivisor = short_alloc(Nplus1);

    apm_copy_shorts(dividend, num1->data, MplusN);
    apm_copy_shorts(divisor, num2->data, N);
    divisor[N] = 0;

    /*
     * Knuth: step D1.
     */
    scaleFactor = base / (divisor[N - 1] + 1);
    if (scaleFactor <= 1) {
	dividend[MplusN] = 0;
    } else {
	dividend[MplusN] = apm_scalar_mul(dividend, dividend, MplusN, scaleFactor);
	apm_scalar_mul(divisor, divisor, N, scaleFactor);
    }

    divN1 = divisor[N - 1];
    divN2 = divisor[N - 2];

    /*
     * Knuth: steps D2 and D7.
     */
    for (j = 0, vJ = M, uJ = MplusN; j <= M; ++j, --vJ, --uJ) {
	/*
	 * Knuth: step D3.
	 */
	temp1 = dividend[uJ];
	temp1 *= base;
	temp1 += dividend[uJ - 1];

	if (dividend[uJ] == divN1) {
	    qHat = base - 1;
	} else {
	    temp2 = temp1 / divN1;
	    qHat = (short)temp2;
	}

	temp2 = divN2;
	temp2 *= qHat;

	temp3 = divN1;
	temp3 *= qHat;
	temp3 = temp1 - temp3;
	temp3 *= base;
	temp3 += dividend[uJ - 2];

	if (temp2 > temp3)
	    --qHat;

	/*
	 * Knuth: step D4.
	 */
	xdivisor[N] = apm_scalar_mul(xdivisor, divisor, N, qHat);
	borrow = apm_array_sub(&dividend[vJ], xdivisor, Nplus1);

	/*
	 * Knuth: step D5.
	 */
	if (borrow == 0) {
	    temp->data[vJ] = qHat;
	} else {
	    /*
	     * Knuth: step D6.
	     */
	    temp->data[vJ] = qHat - 1;
	    divisor[N] = 0;
	    apm_array_add(&dividend[vJ], divisor, Nplus1);
	}
    }

    /*
     * Knuth: step D8.
     */
    temp->length = M + 1;
    temp->sign = sign;
    apm_trim(temp);

    *resultp = temp;

    if (remainderp) {
	temp = apm_alloc(length2);
	temp1 = 0;
	for(i = length2 - 1; i >= 0; i--) {
	    temp1 = temp1 * base + dividend[i];
	    temp->data[i] = temp1 / scaleFactor;
	    temp1 %= scaleFactor;
	}
	temp->length = length2;
	temp->sign = num1->sign;
	apm_trim(temp);
	*remainderp = temp;
    }

#ifdef mips
    alloca(0);
#endif
    return 1;
}

APM
apm_neg(num)
APM num;
{
    APM temp;

    temp = apm_alloc(num->length);
    temp->length = num->length;
    temp->sign = num->length ? -num->sign : 1;
    apm_copy_shorts(temp->data, num->data, num->length);
    return temp;
}

int
apm_compare(num1, num2)
APM num1;
APM num2;
{
    int n;
    int len;
    int length1, length2;
    int res;
    short tempval;
    short borrow;
    short c1;
    short c2;
    short base = BASE;

    if (num1 == num2) {
	return (0);
    }

    if (num1->sign < num2->sign)
	return -1;
    else if (num1->sign > num2->sign)
	return 1;

    length1 = num1->length;
    length2 = num2->length;
	
    if (length1 > length2)
	len = length1;
    else
	len = length2;

    borrow = 0;
    res = 0;
    for (n = 0; n <= len - 1; ++n) {
	if (n >= length1) {
	    c1 = 0;
	} else {
	    c1 = num1->data[n];
	}
	if (n >= length2) {
	    c2 = 0;
	} else {
	    c2 = num2->data[n];
	}
	tempval = (c1 + borrow) - c2;
	if (tempval < 0) {
	    borrow = -1;
	    tempval += base;
	}
	else {
	    borrow = 0;
	}
	res |= tempval;
    }

    if (borrow == 0)
	return res ? num1->sign : 0;
    else
	return -num1->sign;
}

short
apm_array_add(result, addend, length)
short *result;
short *addend;
int length;
{
    int n;
    short tempval;
    short carry = 0;
    short base = BASE;

    for (n = 0; n < length; ++n) {
	tempval = result[n] + carry + addend[n];
	result[n] = tempval % base;
	carry = tempval / base;
    }

    return (carry);
}

short
apm_array_sub(result, subtrahend, length)
short *result;
short *subtrahend;
int length;
{
    int n;
    short tempval;
    short borrow = 0;
    short base = BASE;

    for (n = 0; n < length; ++n) {
	tempval = (result[n] + borrow) - subtrahend[n];
	if (tempval < 0) {
	    result[n] = tempval + base;
	    borrow = -1;
	}
	else {
	    result[n] = tempval;
	    borrow = 0;
	}
    }
    return (borrow);
}

short
apm_scalar_mul(result, multiplicand, length, multiplier)
short *result;
short *multiplicand;
int length;
short multiplier;
{
	int n;
	long tempval;
	short carry = 0;
	short base = BASE;

	for (n = 0; n < length; ++n) {
		tempval = multiplicand[n];
		tempval *= multiplier;
		tempval += carry;
		result[n] = (short)(tempval % base);
		carry = (short)(tempval / base);
	}
	return (carry);
}

void
apm_copy_shorts(to, from, num)
short *to;
short *from;
int num;
{
    if (num)
	do {
	    *to++ = *from++;
	} while(--num);
}

void
apm_zero_shorts(to, num)
short *to;
int num;
{
    if (num)
	do {
	    *to++ = 0;
	} while(--num);
}

/* Specific for this base!! */

int
apm_to_int(num)
APM num;
{
    int len = num->length;
    int n0 = len > 0 ? num->data[0] : 0;
    int n1 = len > 1 ? num->data[1] : 0;
    int n2 = len > 2 ? num->data[2] : 0;
    return num->sign * (n0 + n1*BASE + n2*BASE*BASE);
}

APM
apm_from_int(i)
int i;
{
    APM r = apm_alloc(3);
    unsigned u;

    if (i < 0) {
	r->sign = -1;
	u = -i;
    } else {
	r->sign = 1;
	u = i;
    }
    r->length = 3;
    r->data[0] = u % BASE;
    u /= BASE;
    r->data[1] = u % BASE;
    u /= BASE;
    r->data[2] = u % BASE;
    apm_trim(r);
    return r;
}

void
apm_trim(num)
APM num;
{
    while(num->length > 0 && num->data[num->length-1] == 0)
	num->length--;
/*    num->alloclen = (sizeof(struct apm_struct) + (num->length-1)*sizeof(short) + sizeof(int *)-1) / sizeof(int *);*/
#if 0
    if (num->length == 0)
	num->sign = 0;
#endif
}

static
pa(n)
APM n;
{
    int i;

    printf("%s ", n->sign < 0 ? "-" : "+");
    for(i = n->length-1; i >= 0; i--)
	printf("%04d ", n->data[i]);
    printf("\n");
}
