--
-- $Header: /ufs/usr.src/local/lml/src/expr/RCS/subst.m,v 2.14 88/02/23 16:46:37 augustss Exp $
--
module -- subst
--
-- substitute an expression for an identifier
--
#include "id.t"
#include "types.t.t"
#include "einfo.t.t"

export subst;
rec

    subst s i t =
	case t in
	   (mkap f a) :  mkap (subst s i f) (subst s i a)
	|| (mklam e1 e) : mklam e1 (subst s i e)
	|| (mkcase e cl) : mkcase (subst s i e) (map substp cl)
	|| (mkletv b e) : mkletv (substb b) (subst s i e)
	|| (mkident i1) : if eqid i i1 then s else t
	|| (mkmodule i fl il el b) : mkmodule i fl il el (substb b)
	|| (mkconst _) : t
	|| (mkconstr c el) : mkconstr c (map (subst s i) el)
	|| (mkcondp p c) : mkcondp (subst s i p) (subst s i c)
	|| (mklazyp p) : mklazyp (subst s i p)
	|| (mkinfo t e) : mkinfo (substt s i t) (subst s i e)
	|| (mkerror _) : t
	|| (mkfailmatch _) : t
	end
where rec
    substb d =
	case d in
	   (mkbrec b) : mkbrec (substb b)
	|| (mkband b1 b2) : mkband (substb b1) (substb b2)
	|| (mkblocal b1 b2) : mkblocal (substb b1) (substb b2)
	|| (mkbpat pl) : mkbpat (map substp pl)
	|| (mkbmulti p e) : let (np,ne) = substp (p,e) in mkbmulti np ne
	|| (mkbtype _ _ _) : d
	|| (mkbnull) : d
	end
and
    substp (p, e) = (p, subst s i e)
and
    substt s i (spark is) = spark (map (\i1.if eqid i i1 then let (mkident ni)=s in ni else i1) is)
||  substt s i t = t
end
