module -- einfo
#include "../misc/flags.t"
#include "id.t"
#include "einfo.t.t"
#include "ttype.t"
export preinfo, prfinfo, framesize_of_finfo, arity_of_finfo, hprfinfo;
    preinfo strict s = "("@s@"){STRICT}"
||  preinfo inline s = "("@s@"){INLINE}"
||  preinfo noeval s = s@"`"
||  preinfo chkind s = s@"``"
||  preinfo (restr t) s = "("@s@":"@prttype t@")"
||  preinfo (spark is) s = "("@s@") {SPARK "@mix (map idtostr is) " " @ "}"
||  preinfo (doeval is) s = "("@s@") {EVAL "@mix (map idtostr is) " " @ "}"
||  preinfo (trestr t) s = "("@s@"::"@prttype t@")"
||  preinfo (noarrow t) s = "("@s@"{NOARROW "@prttype t@"})"
||  preinfo notchk s = "(("@s@"){NOTCHK})"
||  preinfo (forcearity n) s = "("@s@"{FARITY "@itos n@"})"
||  preinfo overload s = "(("@s@"){OVERLOAD})"
and
    prfinfo f_unk = ""
||  prfinfo (finfo a ss s i) = ('{'.map p ss@[','; p s]@(if nuflag then ','.itos i else "")@"}"
	where p true = 'T'
	   || p false= 'F')
and
    hprfinfo f_unk = ""
||  hprfinfo (finfo a ss s i) = ("{-:"@map p ss@[','; p s]@(if nuflag then ','.itos i else "")@":-}"
	where p true = 'T'
	   || p false= 'F')
and framesize_of_finfo f_unk = -1
||  framesize_of_finfo (finfo _ _ _ n) = n
and arity_of_finfo f_unk = -1
||  arity_of_finfo (finfo n _ _ _) = n
end
