module -- hprexport
-- Print the export list of a module.
#include "Expr.t.t"
#include "../expr/types.t.t"
#include "../expr/ttype.t.t"
#include "../expr/constr.t.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/ttype.t"
#include "../expr/einfo.t"
#include "../misc/flags.t"
#include "../misc/util.t"
#include "../misc/misc.t"
#include "../expr/impexp.t.t"
#include "../expr/impexp.t"
#include "../expr/tinfo.t"
#include "../rename/renenv.t"
#include "../rename/renameutil.t"
#include <OK>
#include <Option>
export hprexport;
rec hprexport env (Emodule i oooexps _) =
        let ooexps = reverse oooexps in
        let mids = idtostr i in
        let esyns = filter id_issyn (map expid ooexps) in			-- exported synonyms
        let oexps = map (eexpsyn esyns) ooexps in				-- expand synonyms that are not visible
	let exps0 = concmap expimp oexps in					-- add stuff from exported "import"
	let ids = concmap collid exps0 in					-- all identifiers in the interface
        let iexps0 = filter (\e.id_visibility (expid e) = Vimported) exps0 in	-- identifiers that are not from this module
        let iexpsi = map expid iexps0 in					-- same but with mkexp* stripped
        let iids = filter (\i.id_visibility i = Vimported &			-- identifiers (types) that are visible in the interface,
			      ~(member eqid i iexpsi | idinprelude i)) ids in	--           imported (not from Prelude), but not exported.
        let iiexps = map mkexpid (mkseteq xeq iids) in				-- extra exports due to these
        let iexps = iexps0 @ iiexps in						-- all that needs to be reexported
        let exps = exps0 @ iiexps in						-- new export list
        let eids = concmap ecollid exps0 in					-- identifiers that are (re-)exported from this interface
	let nonexp = filter (not o id_is_visible) ids in			-- in the interface, but not visible
        let badexp = filter (not o okexp) oexps in				-- invalid exports ids
	let dupexp = getdups eqid ltid (map expid oexps) in			-- duplicate exports
        if badexp ~= [] then
	    No ("Cannot export "@mixmap (oprid o expid) badexp ", ")
        else if dupexp ~= [] then
	    No ("Duplicates in export list "@mixmap oprid dupexp ", ")
	else if nonexp ~= [] & ExportCheck then 
	    No ("Module "@hprid i@" should export "@mixmap hprid (mkseteq eqid nonexp) ", ") 
	else 
	    Yes ("interface "@hprid i@" where {\n"@
--		 (concmap hmkimps o group eqmodule o remdupi o sort ltorig) iexps @  ******** looks nice, but is wrong under multiple renamings
                 concmap hmkimps (map (\e.[e]) iexps) @
		 concmap hprfix eids @
		 mix (map prexp exps@prinst (idtostr i) eids env) ";\n"@
		 "\n}\n")

and eqmodule i1 i2 = hd (id_orignames (expid i1)) = hd (id_orignames (expid i2))
and eqorig e1 e2 = ieqorig (expid e1) (expid e2)
and ltorig e1 e2 = iltorig (expid e1) (expid e2)
and ieqorig (mkid _ _ _ on1) (mkid _ s2 _ on2) = on1 = on2
and iltorig (mkid _ _ _ on1) (mkid _ s2 _ on2) = on1 < on2
and xeq i1 i2 = eqid i1 i2 & idtostr i1 = idtostr i2

and prexp (mkexpid (i as (mkid _ _ (idi_var (var_global f) (Ohastype t _)) _))) =
	hprid i@" :: "@hprttype t@"  "@hprfinfo f
||  prexp (mkexpid (i as (mkid _ _ (idi_var _ (Ohastype t _)) _))) =
	hprid i@" :: "@hprttype t
||  prexp (mkexpidall (mkid _ _ (idi_type t _ ti _ od) _)) =
      let cs = get_cs_from_tinfo ti in
      "data "@hprttype t@" = "@mix (map (\(mkcons i ys).hprid i@concmap (\(t,b).' '.phprttype t@if b then "@" else "") ys) cs) " | "@ prd od
||  prexp (mkexpid (mkid _ _ (idi_type t _ ti _ od) _)) =
      let cs = get_cs_from_tinfo ti in
      "data "@hprttype t	----- where?? @prd od
||  prexp (mkexpidall (mkid _ _ (idi_class (clsi t dmts _ _ _)) _)) =
      "class "@hprclass t@" where {\n"@mix (map prdmt dmts) ";\n"@"\n    }"
||  prexp (mkexpid (mkid _ _ (idi_class (clsi t _ _ _ _)) _)) =
      "class "@hprclass t
||  prexp (mkexpid (mkid _ _ (idi_syn t1 n t2) _)) =
      "type "@hprttype t1@" = "@hprttype t2
||  prexp (mkexpidmodall _) = ""
||  prexp e = "-- STRANGE EXPORT: "@prexpid e
and phprttype (t as mktvar _) = hprttype t
||  phprttype (t as mktcons _ []) = hprttype t
||  phprttype t = "("@hprttype t@")"
and hprclass c = hprttype (cdecl2type c)
and okexp (mkexpid    (mkid _ _ (idi_var _ _) _)) = true
||  okexp (mkexpidall (mkid _ _ (idi_type _ _ _ _ _) _)) = true
||  okexp (mkexpid    (mkid _ _ (idi_type _ _ _ _ _) _)) = true
||  okexp (mkexpidall (mkid _ _ (idi_class _) _)) = true
||  okexp (mkexpid    (mkid _ _ (idi_class _) _)) = true
||  okexp (mkexpid    (mkid _ _ (idi_syn _ _ _) _)) = true
||  okexp (mkexpidmodall (mkid _ _ (idi_module _) _)) = true
||  okexp _ = false
and prdmt (_,m,t) = "    "@hprid m @ " :: " @ hprttype (tpart t)
and prd None = ""
||  prd (Some is) = " deriving ("@mix (map hprid is) ", " @ ")"
and hprfix i =
    case id_fixity i in
	Infix  n : "infix  "@itos n@" "@opr i@";\n"
    ||  InfixL n : "infixl "@itos n@" "@opr i@";\n"
    ||  InfixR n : "infixr "@itos n@" "@opr i@";\n"
    ||  Nofixity : ""
    end
and opr i =
	let s = prid i in
	if isalpha (hd s) then
		"`"@s@"`"
	else
		s
and hprid i = oprid i
and parit s =
    if ~isalpha (hd s) then
	"("@s@")"
    else
	s
-- Collect ids that must be exported from an export id
and collid (mkexpid (i as (mkid _ _ (idi_var _ (Ohastype t _)) _))) = collidt t
||  collid (mkexpidall (mkid _ _ (idi_type t _ ti _ od) _)) = 
      let cs = get_cs_from_tinfo ti in
      collidt t @ concmap (\(mkcons i ys).concmap (\(t,b).collidt t) ys) cs
||  collid (mkexpid (i as mkid _ _ (idi_type _ _ _ _ od) _)) = []
||  collid (mkexpidall (mkid _ _ (idi_class (clsi t dmts _ _ _)) _)) =
      collidt (cdecl2type t) @ concmap (\(_,_,t).collidt t) dmts
||  collid (mkexpid (mkid _ _ (idi_class (clsi t _ _ _ _)) _)) = collidt (cdecl2type t)
||  collid (mkexpid (mkid _ _ (idi_syn _ _ t) _)) = collidt t
||  collid _ = []
and collidt (mktcontype ts t) = map (\(mkassert i _).i) ts @ collidt t
||  collidt (mktcons i ts) = i . concmap collidt ts
||  collidt _ = []
-- Collect exported ids from an export id
and ecollid (mkexpid (i as (mkid _ _ (idi_var _ _) _))) = [i]
||  ecollid (mkexpidall (i as mkid _ _ (idi_type _ _ ti _ od) _)) = i . map (\(mkcons i ys).i) (get_cs_from_tinfo ti)
||  ecollid (mkexpid (i as mkid _ _ (idi_type _ _ _ _ od) _)) = [i]
||  ecollid (mkexpidall (i as mkid _ _ (idi_class (clsi t iits _ _ _)) _)) = i . map (\(_,i,_).i) iits
||  ecollid (mkexpid (i as mkid _ _ (idi_class _) _)) = [i]
||  ecollid (mkexpid (i as mkid _ _ (idi_syn _ _ _) _)) = [i]
||  ecollid _ = []
and ecollidt (mktcontype ts t) = ecollidt t
||  ecollidt (mktcons i ts) = [i]
||  ecollidt _ = []

-- An instance declaration should be exported if the class or the type is
-- exported.
and prinst mid eids env =
    let is = filter (expinst mid eids) (rids Ktype env)
    in map (\(mkid _ _ (idi_inst t _ _) _)."instance "@hprttype (idecl2type t)) is
and expinst mid eids (mkid n s (idi_inst t _ false) (Orignames _ _ (m._))) =
    case t in
	mkidecl _ ci ti _ : member eqid ci eids | member eqid ti eids | (AllowRedef & m = mid) /*| idinprelude ci & idinprelude ti & m=mid*/
    end
||  expinst _ _ _ = false
and hmkimps es =
    let m = hd (id_orignames (expid (hd es))) in
    let ids = concmap ecollid es in
    "import "@tl m@"("@mixmap hmkimp1 es ", "@")"@
    case filter (\i.idtostr i ~= oname i) ids in
	[] : ";\n"
    ||  sns : " renaming (" @ mix (map (\i.tl (oname i) @ " to " @ tl (idtostr i)) sns) ", " @ ");\n"
    end
and hmkimp1 e = tl (oname (expid e)) @ (case e in mkexpid _ : "" || _ : "(..)" end)
and expimp (mkexpidmodall (mkid _ _ (idi_module es) _)) = es
||  expimp i = [i]

and oname i = last (id_orignames i)

-- remove duplications in export list
and remdupi (x1.x2.xs) & (oname (expid x1) = oname (expid x2)) =
    if expmore x1 x2 then
	remdupi (x1.xs)
    else
	remdupi (x2.xs)
||  remdupi (x.xs) = x.remdupi xs
||  remdupi [] = []
-- does first export more than second
and expmore _ (mkexpid _) = true
||  expmore _ _ = false

-- Expand synonyms that are not externally visible.
and eexpsyn es e = (eexps e
where rec
    eexps (mkexpid i) = mkexpid (iexpsyn i)
||  eexps (mkexpidall i) = mkexpidall (iexpsyn i)
||  eexps (mkexpidsome i is) = mkexpidsome (iexpsyn i) is
||  eexps (mkexpidmodall i) = mkexpidmodall (iexpsyn i)
and iexpsyn (mkid u s iv on) = mkid u s (ivexp iv) on
and ivexp (idi_var vi (Ohastype t n)) = idi_var vi (Ohastype (tsynexp t) n)
||  ivexp (idi_type t x (mktinfo y i a b cs) z w) = idi_type (tsynexp t) x (mktinfo y i a b (map (\(mkcons q tbs).(mkcons q (mapfst tsynexp tbs))) cs)) z w
||  ivexp (idi_syn t1 n t2) = idi_syn t1 n (tsynexp t2)
||  ivexp (idi_class (clsi t iits ss ins n)) = idi_class (clsi t (mapthd tsynexp iits) ss ins n)
||  ivexp iv = iv
and invissyn (mktcons (i as mkid _ _ (idi_syn _ _ _) _) _) = ~(member eqid i es | idinprelude i)
||  invissyn _ = false
and tsynexp (mktcontype k t) = mktcontype k (tsynexp t)
||  tsynexp (mktcons i ts) =
    let ts' = map tsynexp ts in
    while invissyn synexpand (mktcons i ts')
||  tsynexp t = t
)
and idinprelude i = inprelude (id_orignames i)
end
