module
#include "misc.t"
#include "matrix.t"
#include "board.t"
#include "tetr.t"
export tetris;
rec
tetris ts input =
let xystart = (5, 1) in
let yinc (x, y) = (x, y+1)
and xadd dx b (x, y) t = if ~outside b (x+dx, y) t then (x+dx, y) else (x, y)
in
let rec f b xy (c.cs) (ts as t.ts') =
	if c = HIATON then
		if hitb b xy t then
			new b xy xy ts cs
		else
			let xy' = yinc xy in
			bmove t t xy xy' @ f b xy' cs ts
	else let move dx = let xy' = xadd dx b xy t in
			   bmove t t xy xy' @ f b xy' cs ts
	     and rotate =  let t' = rot t in
			   if outside b xy t' then
				f b xy cs ts
			   else
				bmove t t' xy xy @ f b xy cs (t'.ts')
	     and drop = let xy' = droppos b xy t in
			bmove t t xy xy' @ new b xy xy' ts cs
	     in
	     case c in
		'Q' :	quit (score b) ts' cs
	     || '4' :	move (-1)
	     || 'j' :	move (-1)
	     || '6' :	move 1
	     || 'l' :	move 1
	     || '5' :	rotate
	     || 'k' :	rotate
	     || '2' :	drop
	     || ' ' :	drop
	     || '8' :   let b' = inclevel b in drawboard b' @ dodelay (getlevel b) @ f b' xy cs ts
	     || _ :	f b xy cs ts
	     end
and new b src dst (t.(ts' as (t'._))) cs =
	let xy' = xystart in
	let (out1, b') = updscore b src dst in
	let (out2, b'') = setb b' dst t in
	if outside b xy' t' then out1 @ quit (score b) ts' cs else
	out1 @ out2 @ b_set t' xy' @ f b'' xy' cs ts'
in
let level = getstartlevel in
let sb = startboard level in
[CCBREAK] @ dodelay level @ Clear @
drawboard sb @
b_set (hd ts) xystart @
f sb xystart input ts
and y_or_n ('y'.cs) y n = y cs
||  y_or_n ('n'.cs) y n = n cs
||  y_or_n (_.cs) y n = y_or_n cs y n
and quit s ts cs = 
	let (c1.r) = cs in
	hiatonic (-1) @ MoveTo 0 23 @ "Hit any key to continue" @ seq c1 ("\n"@updhigh s) @
	"Another game?" @ y_or_n cs (tetris ts) (\x."\n"@[CCOOKED])
end
