-- muntest4.m
--
-- The Munich graphics model, implemented in NeWS
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- Rubics cube demo

module

#include "munout.t"
#include "munin.t"

export  StartPos,Twist,Z1,Z2,Z3,Z4,Z5,Z6,Z7,Z8,Z9,
	A1,A2,A3,A4,A5,A6,A7,A8,A9,Invert,Reset;

rec     StartPos = Repeat 9 Red @ Repeat 9 Blue @ Repeat 9 MediumAquamarine @
                   Repeat 9 Magenta @ Repeat 9 Goldenrod @ Repeat 9 White

and     Repeat 0 c = []
||      Repeat n c = c . Repeat (n-1) c

and     Twist table (last,this) = (this,GetGroups this 1 this table)

and     Z1 = [[16;28;39;27];[17;29;38;24];[18;30;37;21];[46;52;54;48];
	      [47;49;53;51]]

and     Z2 = [[13;31;42;26];[14;32;41;23];[20;15;33;40]]

and     Z3 = [[1;7;9;3];[4;8;6;2];[10;34;45;25];[12;36;43;19];[11;35;44;22]]

and     Z4 = [[7;18;54;45];[9;12;52;39];[8;15;53;42];[31;29;33;35];
	      [28;30;36;34]]

and     Z5 = [[4;17;51;44];[6;11;49;38];[5;14;50;41]]

and     Z6 = [[1;16;48;43];[3;10;46;37];[2;13;47;40];[19;21;27;25];
	      [22;20;24;26]]

and     Z7 = [[1;21;52;34];[4;20;49;31];[7;19;46;28];[10;16;18;12];
	      [11;13;17;15]]

and     Z8 = [[2;24;53;35];[8;22;47;29];[32;5;23;50]]

and     Z9 = [[3;27;54;36];[9;25;48;30];[6;26;51;33];[37;39;45;43];
	      [40;38;42;44]]

and     A1 = map reverse Z1

and     A2 = map reverse Z2

and     A3 = map reverse Z3

and     A4 = map reverse Z4

and     A5 = map reverse Z5

and     A6 = map reverse Z6

and     A7 = map reverse Z7

and     A8 = map reverse Z8

and     A9 = map reverse Z9

and     Invert = [[1;54];[2;51];[3;48];[4;53];[5;50];[6;47];[7;52];[8;49];
		  [9;46];[10;30];[11;29];[12;28];[13;33];[14;32];[15;31];
		  [16;36];[17;35];[18;34];[19;39];[20;42];[21;45];[22;38];
		  [23;41];[24;44];[25;37];[26;40];[27;43]]

and     Reset (last,this) = (this,StartPos)

and     GetGroups orglist n [] table = []
||      GetGroups orglist n (oh.ot) table =
	   let rec NextElem = Group n table
	   in if NextElem = 0 then oh.GetGroups orglist (n+1) ot table
	      else select NextElem orglist .GetGroups orglist (n+1) ot table

and     Group n [] = 0
||      Group n (h.t) = 
	   let rec NextElem = Cycle n h (hd h)
	   in if NextElem = 0 then Group n t else NextElem

and      Cycle n [] first = 0
||       Cycle n [h] first = if n = h then first else 0
||       Cycle n (h.t1.t2) first = if n = h then t1 else Cycle n (t1.t2) first

end
