-- News graphics definitions module
--
-- ps.m contains various useful routines for communicating
-- NeWS, indepenant of any graphics model. It also contains
-- a few odd routines that have been found helpful in my other programs.

module

-- PostScript functions

export GraphicsModel,PsStr,PsNum,PsNums,PsAtom,FromToStep,CMap,max;

rec GraphicsModel fname =
	PsStr fname @ "LoadFile pop\n"

and PsStr str =
	"(" @ str @ ") "

and PsNum n = itos n @ " "

and PsNums [] = " "
||  PsNums (h.t) = PsNum h @ PsNums t

and PsAtom a = "/" @ a @ " "

-- Miscellaneous functions

and FromToStep f t s = if f > t then []
		       else f . FromToStep (f+s) t s

and CMap = concmap

and max l = 
    let rec maxsub n [] = n
    ||      maxsub n (h.t) = if n > h then maxsub n t else maxsub h t
    in maxsub 0 l
end
