-- noodle.m
--
-- A graphical querying package for a knowledge base. After Pasta III.
--
-- By Andrew Dwelly (C) 1989 ECRC gmbh Munich
--
-- Notes :
--  This has been written primarily to test the use of Dialogue combinators
--  in a larger project, to see if there are problems scaling up. The 
--  project choesen is a remake of the Pasta III program being worked on
--  elsewhere in ECRC, allowing us to make some comaprison between the
--  structures developed here, and those used in the original.

#include "ps.t"
#include "munout.t"
#include "munin.t"
#include "fonts.t"
#include "gdc.t"
#include "tree.t"
#include "style.t"
#include "stylemenu.t"
#include "stylenoodle.t"
#include "apcontnoodle.t"

let rec

-- Dialogue Definitions --

    Noodle = Objects [Application; MainWindow] []

and MainWindow = Inherit (OpenNoodleWindow (300^100) 60)
			 (DrawMainWindow,MainMenuRules) 

and MainMenuRules s l = [OCons 0 (SIsMs Lft Dep Main) MainMenu]

and DrawMainWindow = Join (SInMs Lft Dep Main)
			  (SText Main (100^35) Helvetica 32 Black "Noodle")

and MainMenu = PopUpMenuAt Lft (Vert Helvetica 18) Root 2
	       ["Workspace"~>NewWorkspace;
		"Query" ~> QueryDialogue;
		"Quit" ~> QuitDialogue]

and NewWorkspace = 
    Objects [Inherit (OpenNoodleWindow (700^500) 60) WSStaticMenu]

and WSStaticMenu = StaticMenuObj Lft (Vert Helvetica 18) Child (10^10)
		   ["Entities" ~> MenuTest "Entities";
		    "Relations" ~> MenuTest "Relations";
		    "Properties" ~> MenuTest "Properties";
		    "New Query" ~> MenuTest "New Query"]

and QueryDialogue cl = NullDialogue

and QuitDialogue cl = Send (MessApp "/Q")

-- Window definitions --

and Main = EldestChild

-- State control --

and StartState = (InitDS,[])

in Dialogue Noodle StartState input

