-- dict.m
-- 
-- Started 21.12.88
-- By A.Dwelly
--
-- Associates items in a list of pairs.

module

export Exists,Assoc,Find,Remove,ShowDict;

rec

------------------------
-- Dictionry Routines --
------------------------

    Exists lft [] = false
||  Exists lft ((s,rht).t) = if s = lft then true else Exists lft t

and Assoc lft rht dict = if Exists lft dict then dict else (lft,rht).dict

and Find s ((lft,rht).t) = if s = lft then rht else Find s t

and Remove rht [] = [] 
||  Remove rht ((l,r).t) = if rht = r then Remove rht t
			   else (l,r).Remove rht t 
and ShowDict dict =
    let ShowRec (s,n) = "\"" @ s @ "\"," @ itos n @ ";"
    in " [" @ concmap ShowRec dict @ "]"

end
