module

#include "tenvt.t"

export lextenv;

-- lextenv : List Char -> List parse_tenvLextype
--       convert a string to a list of lexical tokens

local

  idchar c = isalnum c | c = '_' | c = '\''
  
  and
 
  symbchar c = 
	  '!' = c 		--  !
	| '#' < c & c < '(' 	--  $ % & '
	| '*' < c & c < '0'  	--  + , - . /
	| ';' < c & c < 'A' 	--  < = > ? @ 
	| 'Z' < c & c < 'a' 	--  [ \ ] ^ _ ` 
	| '|' = c		--  |
	| '~' = c		--  ~

  -- for simplicity, I assume that the following characters cannot 
  -- occur in symbolic names  " # * : ; { }
  -- Thus, I can handle fewer symbolic names than the LML compiler can.

in

  rec
      lextenv [] = []
  ||  lextenv ('n'.'o'.'n'.'f'.'i'.'x'.' '.tail) = 
	  let (fixity, ';'.rest) = take (~= ';') tail
	  in  lextenv rest
  ||  lextenv ('i'.'n'.'f'.'i'.'x'.' '.tail) = 
	  let (fixity, ';'.rest) = take (~= ';') tail
	  in  lextenv rest
  ||  lextenv ('i'.'n'.'f'.'i'.'x'.'r'.' '.tail) = 
	  let (fixity, ';'.rest) = take (~= ';') tail
	  in  lextenv rest
  ||  lextenv ('t'.'y'.'p'.'e'.' '.tail) =
	  let (typedecl, ';'.rest) = take (~= ';') tail
	  in  lextenv rest
  ||  lextenv ('{'.tail) = let (sinfo, '}'.rest) = take (~= '}') tail
		       in  lextenv rest
  ||  lextenv (' '.tail)  = lextenv tail
  ||  lextenv ('\n'.tail) = lextenv tail
  ||  lextenv ('\t'.tail) = lextenv tail
  ||  lextenv ('i'.'m'.'p'.'o'.'r'.'t'.' '.tail) = lextenv tail
  ||  lextenv (';'.tail) = parse_tenvCSEMI . lextenv tail
  ||  lextenv (':'.tail) = parse_tenvCCOLON. lextenv tail
  ||  lextenv ('('.tail) = parse_tenvCLPAR . lextenv tail
  ||  lextenv (')'.tail) = parse_tenvCRPAR . lextenv tail
  ||  lextenv ('-'.'>'.tail) = parse_tenvCARROW . lextenv tail
  ||  lextenv ('#'.tail) = 
	  case take isdigit tail
	  in  [], rest 	      : parse_tenvCTIMES . lextenv rest
	  || (ds as _._),rest : parse_tenvCCONST ('#'.ds) . lextenv rest
	  end

  ||  lextenv ('*'.tail) = 
	  let i,rest = take idchar tail
	  in parse_tenvCVAR i . lextenv rest

  ||  lextenv ('_'.tail) =
	  let alphaname,rest_a = take idchar tail
	  in let symbname,rest_s = take symbchar tail
	     in if length alphaname > length symbname
		then parse_tenvCCONST ('_'.alphaname) . lextenv rest_a
		else parse_tenvCCONST ('_'.symbname)  . lextenv rest_s

  ||  lextenv (id as c._) & (isalpha c) =
	  let i,rest   = take idchar id
	  in parse_tenvCCONST i . lextenv rest

  ||  lextenv (id as c._) & (symbchar c) =
	  let i,rest   = take symbchar id
	  in parse_tenvCCONST i . lextenv rest

  ||  lextenv (x.tail) = fail ("Illegal character: " @ [x] @ "\n")

end -- local

end -- module

