-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "syntaxt.t"

export unlex;

-- unlex : convert a list of lexical tokens back to a string of characters

unlex syms = mix (map pr syms) " " where
    	pr (prsCACTION f) =
	    let $,str,$ = f (fail "Internal error") in "{" @ str @ "}"
    ||  pr prsCBAR = "|"
    ||  pr prsCCOLON  = ":"
    ||  pr prsCFUNCTION = "%function"
    ||  pr prsCINCLUDE = "%include"
    ||  pr prsCLEFT =  "%left"
    ||  pr prsCMARK = "%%"
    ||  pr prsCNONASSOC = "%nonassoc"
    ||  pr prsCPREC =  "%prec"
    ||  pr prsCRETURN = "%return"
    ||  pr prsCRIGHT = "%right"
    ||  pr prsCSTART = "%start"
    ||  pr prsCTOKEN = "%token"
    ||  pr (prsCID f) = let $,str = f in str
    ||  pr prsCSEMI =  ";"

end
