-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "actions.t"
#include "conflict.t"
#include "itemset.t"

export transitions;

-- transitions : The actions that should be done in each state on each valid
--  	    	 input symbol.  Returns a tuple for each state (listitem)
--  	    	 where the first is the actions on terminal inputs, and
--  	    	 the second on nonterminals.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/transition.m,v 1.1 88/04/19 17:05:56 pelle Exp $"
and
    transitions (grammar as prods,$,$,$,$,$,$,$,$,$,$) =
	map mktrans (itemset grammar)
        where
    	    mktrans ((core,$),no,(nact,tact,ract)) =
	        (let
		    alltact,warn =
		        resolve
			    grammar
			    (concmap mkred ract @ mapsnd Shift tact)
	    	in
		    (no,mapsnd Shift nact,alltact), (warn,comment core))
	    where
		mkred (prod,syms) = map (,Reduce prod) (NSsettolist syms)
            and
	    	comment = map comcore
		where
		    comcore (prod,tllen) =
			let
			    lhs,rhs,$,$,$ =
				hd (filter (\ ($,$,$,$,pno) . pno=prod) prods)
			in let
			    rhsleft = length rhs - tllen
			in
			    lhs,head rhsleft rhs,tail rhsleft rhs,prod

end
