-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

export emptytab, insert, lookup;

-- This module implements a symboltable.  It is implemented as an AVL-tree.

-- insert sym tab : Insert symbol "sym" in table "tab".  Return value is a
--		    pair of the value representing the symbol and the new
--		    symbol table.

-- lookup tab sym : Look for the symbol represented by "sym" in the table
--		    "tab", returning the symbol.

-- emptytab : An empty symbol table.


local rec
type
    Symtabtype *sym = Symtab (Symtree *sym) (Inttree *sym) Int
and type
    Symtree *sym =
    	Empty + Node (Symtree *sym) (*sym#Int) (Symtree *sym) Balance
and type
    Inttree *sym = INode (Inttree *sym) *sym (Inttree *sym)
and type
    Balance = Left + Even + Right
and type
    Newtree *t = Old Int + New *t + Bigger *t
in rec
    noInttree = fail "Symtab misused!\n"
and
    emptytab = Symtab Empty noInttree 0
and
    insert symbol (tab as Symtab st it n) =
	case syminsert symbol n st in
	    Old i : i, tab
	||  New st' : n+1, Symtab st' (intinsert symbol (n+1) it) (n+1)
	||  Bigger st' : n+1, Symtab st' (intinsert symbol (n+1) it) (n+1)
	end
and
    syminsert symbol n Empty = Bigger (Node Empty (symbol,n+1) Empty Even)
||  syminsert symbol $ (t as Node $ (sym,n) $ $) & (symbol = sym) = Old n
||  syminsert symbol n (Node left (sym as s,$) right bal) & (symbol < s) =
	case syminsert symbol n left in
	    (old as Old $) : old
	||  New new_left : New (Node new_left sym right bal)
	||  Bigger new_left :
		case bal in
		    Left : New
			case new_left in
			    Node left' sym' right' Left :
				Node left' sym'
				    (Node right' sym right Even) Even
			||  Node left' sym' right' Right :
				case right' in
				    Node left'' sym'' right'' Left :
					Node
					    (Node left' sym' left'' Even)
					    sym''
					    (Node right'' sym right Right)
					    Even
				||  Node left'' sym'' right'' Even :
				    	Node
					    (Node left' sym' left'' Even)
					    sym''
					    (Node right'' sym right Even)
					    Even
				||  Node left'' sym'' right'' Right :
				    	Node
					    (Node left' sym' left'' Left)
					    sym''
					    (Node right'' sym right Even)
					    Even
				end
			end
		||  Even : Bigger (Node new_left sym right Left)
		||  Right : New (Node new_left sym right Even)
		end
	end
||  syminsert symbol n (Node left (sym as s,$) right bal) & (symbol > s) =
	case syminsert symbol n right in
	    (old as Old $) : old
	||  New new_right : New (Node left sym new_right bal)
	||  Bigger new_right :
	    	case bal in
		    Left : New (Node left sym new_right Even)
		||  Even : Bigger (Node left sym new_right Right)
		||  Right : New
		    	case new_right in
			    Node left' sym' right' Left :
			    	case left' in
				    Node left'' sym'' right'' Left :
				    	Node
					    (Node left sym left'' Even)
					    sym''
					    (Node right'' sym' right' Right)
					    Even
				||  Node left'' sym'' right'' Even :
				    	Node
					    (Node left sym left'' Even)
					    sym''
					    (Node right'' sym' right' Even)
					    Even
				||  Node left'' sym'' right'' Right :
				    	Node
					    (Node left sym left'' Left)
					    sym''
					    (Node right'' sym' right' Even)
					    Even
				end
			||  Node left' sym' right' Right :
			    	Node (Node left sym left' Even)
				    sym' right' Even
			end
		end
	end
and
    intinsert s 1 $ = INode noInttree s noInttree
||  intinsert s n (INode left sym right) =
    	if odd n
	    then INode left sym (intinsert s (n/2) right)
	    else INode (intinsert s (n/2) left) sym right
and
    lookup (Symtab $ it $) n = -- No check on "n"
    	(look it n where rec
	    look (INode $ sym $) 1 = sym
	||  look (INode left $ right) n =
	    	look (if odd n then right else left) (n/2))
end

end
