-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "progtype.t"

export printmodule;

-- printmodule indent module : Convert a module of datatype "Module" to a
--			       list of strings describing the same module
--			       but in concrete syntax.

printmodule maxlinelen incr indent (MkModule includes imports exports binding)=
    map (doindent indent)
    	([
	"module";
	""
	] @
	map (\imp. "#include \"" @ imp @ "\"") includes @
	imports @
	[
	"";
	"export " @ mix exports ", " @ ";";
	""
	]) @
    printbinding indent binding @
	[
	"";
	doindent indent "end"
	]
    where
    	local
	    linelen = maxlinelen - 5
	and
    	    I x = x
	and (rec
	    	maplast f flast [last] = [flast last]
	    ||  maplast f flast (notlast . tl as $.$) =
	    	    f notlast . maplast f flast tl)
	and (rec
	    	minlen e =
		    case e in
		    	Aexp id : length id + 1
		    ||  App l : Sum (map minlen l) + 2
		    ||  Tuple l : Sum (map minlen l) + 2
		    ||  $ : maxlinelen
		    end)
	and (rec
		insertlpar ((b as ' ').t) = b . insertlpar t
	    ||	insertlpar (t as nb.$) & (nb ~= ' ') = '('.t)
	in rec
    	    printbinding indent (Funb (p,e)) =
		maplast I (@ " =") (printexpr indent p) @
		printexpr (indent+incr) e
    	||  printbinding indent (Type id tyvars cs) =
	    	doindent indent "(type" .
    	    	doindent
		    (indent+incr)
		    (id @ (concmap (doindent 1) tyvars) @ " =") .
	    	conc
		    (maplast
		    	(maplast I (@ " +"))
			(maplast I (@ ")"))
			(map (printexpr (indent+2*incr)) cs))
    	||  printbinding indent (And binds) =
    	    	mix
		    (map (printbinding (indent+incr)) binds)
		    [doindent indent "and"]
    	||  printbinding indent (Rec bind) =
    	    	doindent indent "rec" .
    	    	(printbinding newindent bind
	    	where
	    	    newindent =
	    	    	let same = indent and more = indent+incr
		    	in  case bind in
		    	    	Funb $ : more
		    	    ||  Type $ $ $ : more
		    	    ||  And $ : same
		    	    ||  Local $ $ : more
		    	    end)
    	||  printbinding indent (Local locald exported) =
    	    	doindent indent "local" .
	    	printbinding (indent+incr) locald @
	    	doindent indent "in" .
	    	printbinding (indent+incr) exported @
	    	[doindent indent "end"]
    	and
    	    printexpr indent (Aexp id) = [doindent indent id]
    	||  printexpr indent (Case e cases) =
	    	(if minlen e + indent + 7 <= linelen
		    then
		    	[doindent indent ("case" @ hd (printexpr 1 e) @ " in")]
	    	    else
	    	    	doindent indent "case" .
		    	printexpr (indent+incr) e @
		    	[doindent indent "in"]) @
		(conc
		    (maplast
		    	(maplast I (@ " ||"))
		    	I
		    	(map (printcase (indent+incr)) cases)) @
	    	[doindent indent "end"]
		where
		    printcase indent (p,e) =
		    	if minlen p + minlen e + 3 + indent > linelen
			    then
			    	maplast I (@ ":") (printexpr indent p) @
				printexpr (indent+incr) e
			    else
			    	[hd (printexpr indent p) @ ":" @
				 hd (printexpr 1 e)])
    	||  printexpr indent (Let bind exp) =
    	    	doindent indent "let" .
	    	printbinding (indent+incr) bind @
	    	doindent indent "in" .
	    	printexpr (indent+incr) exp
    	||  printexpr indent (Lambda p e) =
    	    	doindent indent ("(" @ printlinarg '\\' p @ ".") .
	    	printexpr (indent+incr) e @
	    	[doindent indent ")"]
    	||  printexpr indent (App (exps as e1.es)) =
    	    	(if Sum (map minlen exps) + indent > linelen
	    	    then
		    	printexpr indent e1 @
			concmap (printarg (indent+incr)) es
		    else
		    	[hd (printexpr indent e1) @
			concmap (printlinarg ' ') es]
	    	where
		    printarg indent e =
		    	case e in
		    	    App $ : parenexpr
			||  Let $ $ : parenexpr
			||  $ : printexpr
		    	end indent e
			where
			    parenexpr indent e =
			    	let l1.ls = printexpr indent e
				in  maplast
				    	I
					(@ ")")
					(insertlpar l1 . ls))
    	||  printexpr indent (Tuple (exps as e1.es)) =
	    	if Sum (map minlen exps) + indent + 2 > linelen
		    then
    	    	    	(let l1.ls = printexpr indent e1
			in maplast I (@ ",") (insertlpar l1 . ls)) @
		    	conc
			    (maplast
			    	(maplast I (@ ","))
				(maplast I (@ ")"))
				(map (printexpr indent) es))
		    else
		    	[hd (printexpr indent e1) @
			concmap (printlinarg ',') es]
	and
	    printlinarg sep (Aexp id) = sep . id
	||  printlinarg sep (e as App $) = sep .'('.hd (printexpr 0 e) @ ")"
	||  printlinarg sep (e as Tuple $) = sep.'('.hd (printexpr 0 e) @ ")"
    	and
	    doindent 0 x = x
	||  doindent n x & (n>0) = ' ' . doindent (n-1) x
	end

end
