-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

export merge, mergered;

-- merge statelist1 statelist2
--	Merge two statelists.  A statelist is a symbol-itemset pair
--	list.  The symbol is the symbol shifted to reach the state.

-- mergered redlist1 redlist2
--	Merge two lists of reductions.  A reductionlist is a list of
--	production-number and context pairs.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/mergestate.m,v 1.1 88/04/19 17:05:08 pelle Exp $"
and
    local
	mergenucl ((co1,ct1),rhs1) ((co2,ct2),rhs2) =
	    mrg co1 ct1 rhs1 co2 ct2 rhs2
	where rec
	    mrg [] [] [] co2 ct2 rhs2 = (co2,ct2),rhs2
	||  mrg co1 ct1 rhs1 [] [] [] = (co1,ct1),rhs1
	||  mrg
		(co1 as (co1hd as p1,r1).co1tl)
		(ct1 as ct1hd.ct1tl)
		(rhs1 as rhs1hd.rhs1tl)
		(co2 as (co2hd as p2,r2).co2tl)
		(ct2 as ct2hd.ct2tl)
		(rhs2 as rhs2hd.rhs2tl)
		=
		if p1 < p2 | p1 = p2 & r1 < r2 then
		    let
		    	(co,ct),rhs = mrg co1tl ct1tl rhs1tl co2 ct2 rhs2
		    in
		    	(co1hd.co,ct1hd.ct),rhs1hd.rhs
	    	else if p1 > p2 | p1 = p2 & r1 > r2 then
		    let
		    	(co,ct),rhs = mrg co1 ct1 rhs1 co2tl ct2tl rhs2tl
		    in
		    	(co2hd.co,ct2hd.ct),rhs2hd.rhs
	    	else -- p1 = p2 & r1 = r2
		    let
			(co,ct),rhs = mrg co1tl ct1tl rhs1tl co2tl ct2tl rhs2tl
		    in
			(co1hd.co,NSunion ct1hd ct2hd.ct),rhs1hd.rhs
    in rec
	merge [] l2 = l2
    ||  merge l1 [] = l1
    ||  merge (l1 as (st1 as s1,i1).tl1) (l2 as (st2 as s2,i2).tl2) =
		 if s1 < s2 then st1 . merge tl1 l2
	    else if s1 > s2 then st2 . merge l1 tl2
	    else /* s1 = s2 */   (s1,mergenucl i1 i2). merge tl1 tl2
    end
and rec
    mergered [] l2 = l2
||  mergered l1 [] = l1
||  mergered (l1 as (h1 as s1,c1).tl1) (l2 as (h2 as s2,c2).tl2) =
	     if s1 < s2 then h1 . mergered tl1 l2
	else if s1 > s2 then h2 . mergered l1 tl2
	else /* s1 = s2 */   (s1,NSunion c1 c2).mergered tl1 tl2
	
end
