-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "attrtype.t"
#include "assoctype.t"
#include "attribute.t"
#include "check.t"
#include "errortype.t"
#include "isittype.t"
#include "symtab.t"
#include "syntax.t"

export mkgrammar;

--  mkgrammar parsetree : transform a concrete syntax tree into a tuple
--  	    	    	  containing the productions, the terminals, the
--  	    	    	  nonterminals, inherited and ssynthesized
--  	    	    	  attributes, the "first" function and included files.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/grammar.m,v 1.1 88/04/19 17:05:03 pelle Exp $"
and
    mkgrammar (start', return', func', terms, nonts, includes, grammar',
	       assocs, symtab, errs') =
    	(grammar, terminals, nonterminals, acceptid, endid, function, look,
    	iattr, sattr, assocs, includes), errs
    	where rec
    	    grammar = (startprod . grammar'
	    	where startprod = acceptid,[start],retact,NoPri,0
	    	    where retact = [[Attribute 0 attr],[Attribute 1 attr]]
		    	where attr = look return)
    	and
	    acceptid,symtab' = insert "$accept" symtab
    	and
	    endid,symtab'' = insert "$end" symtab'
    	and
    	    look = lookup symtab''
    	and
    	    nonterminals = acceptid . sort (<) nonts
    	and
    	    terminals = endid . sort (<) terms
    	and
    	    iattr, sattr = getattr grammar terminals nonterminals
    	and
    	    function = (look func @)
    	and
    	    start,is_start =
	        case start' in Is s : s, true || Isn't : 0, false end
    	and
    	    return,is_return =
	    	case return' in Is r : r, true || Isn't : 0, false end
    	and
    	    func, is_func =
	    	case func' in Is f : f, true || Isn't : 0, false end
    	and
	    errs = errs' @
	    	map
		    (MultiplyTokenDeclared o look o hd)
		    (filter ((>1) o length) (group (=) terminals)) @
	    	(if is_return then [] else [MissingReturn]) @
	    	(if is_func then [] else [MissingFunction]) @
	    	if is_start
		    then
		        if mem start nonterminals
	    	    	    then
			        if is_return & null errs'
	    	    	    	    then
			                checkattr
				    	    iattr
					    sattr
					    terminals
					    start
					    grammar
					    look
			            else
			    	        []
    	    	    	    else [MissingStartProduction]
	            else [MissingStart]

end
