-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "actions.t"
#include "assoc_sym.t"
#include "progtype.t"
#include "scc.t"

export groupstates, parsedec, localdecs, standarddecs, impstate;

-- groupstates s : Group a set of states, s, into strongly connected components

-- localdecs : Declarations that always appear and are local to the parser
--  	       program.  These should not be made available outside the
--  	       parser if avoidable.

-- standarddecs : Declarations that always appear, and that should be
--  	    	  exported.

-- parsedec : Declaration of the parser function.  Of course, it should be
--  	      exported.

-- impstate n : Create the import declaration for a state with number n

local
    Tids = map (\n. '*'.'T'.itos n) (from 1)
and
    maketypeconstr ($,$,$,$,$,fun,lookup,$,sattr,$,$) (tid,sym) (tids,constrs)=
	let tconstr = Aexp (fun "C" @ lookup sym)
	in  if null (assoc_sym sym sattr)
		then tids,tconstr.constrs
		else tid.tids,App [tconstr; Aexp tid].constrs
in
    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/codefuncs.m,v 1.1 88/04/19 17:04:52 pelle Exp $"
and
    groupstates states =
    	let
	    relations = map getdep states
	    where
	    	getdep (n,a1,a2) = n, (reduce dep ([],[]) (map snd (a1@a2)))
		where
		    dep (Shift x) (s,r) & (~ mem x s) = x.s, r
		||  dep (Reduce x) (s,r) & (~ mem x r) = s, x.r
		||  dep $ d = d
	in let
	    groups =
		(map
		    ((\ (sts as s.$).s,sts) o sort (<) o map fst)
		    (scc (mapsnd fst relations)))
	in
	    (map inferdeps groups
	    where
	    	inferdeps (num,shifts) =
		    let
		    	refs,refr =
			    split (map (\s.assoc_sym s relations) shifts)
		    in let
		    	refreds = mkset (conc refr)
		    and
		    	refmod =
			    mkset
			    	(filter
				    (~= num)
				    (map (find groups) (conc refs)))
			where
			    find groups stat =
				fst (hd (filter (mem stat o snd) groups))
		    in
		    	num,shifts,refmod,refreds)
and
    localdecs (grammar as $,$,nonterminals,$,$,fun,$,$,$,$,$) =
	[
	Funb(
	    Aexp (fun "bottom"),
	    App	[Aexp "fail"; Aexp "\"This cannot happen!  Ever!  :-)\""]);
	Type (fun "Prodtype") nontTids constrs
	where
	    nontTids,constrs =
		reduce
		    (maketypeconstr grammar)
		    ([],[])
		    (combine (Tids,(tl nonterminals)));
	Type
	    (fun "Stacktype")
	    ["*P"; "*L"; "*x"]
	    [App[
		Aexp (fun "Stack");
		Aexp "*P";
		Aexp "*L";
		App [
		    Aexp "*P";
		    Aexp "->";
		    App [Aexp (fun "Stacktype");
			Aexp "*P";
			Aexp "*L";
			Aexp "*x"];
		    Aexp "->";
		    App [Aexp "List"; Aexp "*L"];
		    Aexp "->";
		    Aexp "*x"];
		App [Aexp (fun "Stacktype");
		    Aexp "*P";
		    Aexp "*L";
		    Aexp "*x"]]]]
and
    standarddecs (grammar as $,terminals,$,$,$,fun,$,$,$,$,$) =
	[
	Type (fun "Lextype") termTids constrs
	where
	    termTids,constrs =
		reduce
		    (maketypeconstr grammar)
		    ([],[])
		    (combine (Tids,(tl terminals)))
	]
and
    parsedec ($,$,$,$,$,fun,$,$,$,$,$) =
    	Funb
	    (App [Aexp (fun ""); Aexp "I"],
	    App [Aexp (fun "s0"); Aexp (fun "bottom"); Aexp "I"])
and
    impstate ($,$,$,$,$,fun,$,$,$,$,$) n =
    	"import " @ fun "s" @ itos n @ ": " @
	"(" @ fun "Stacktype" @ " *P *L (OK (List *L) *X))->" @
	"((List *L)->(OK (List *L) *X)){FT,F};"

end

end
