-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "attrtype.t"
#include "assoc_sym.t"
#include "errortype.t"

export checkattr;

-- checkattr iattr sattr terms prods lookup :
--    	    Check that the attributes iattr and sattr are consistent with the
--  	    grammar.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/check.m,v 1.1 88/04/19 17:04:50 pelle Exp $"
and
    checkattr iattr sattr terms start prods lookup =
	map
	    MultipleTermIAttr
	    (filter
		((1<) o length o snd)
		(map (\name.lookup name,assoc_sym name iattr) terms)) @
	map
	    MultipleTermSAttr
	    (filter
		((1<) o length o snd)
		(map (\name.lookup name,assoc_sym name sattr) terms)) @
	map StartIAttr (assoc_sym start iattr) @
	concmap checkatts prods where
	    checkatts (nont,rhs,atts,$,prodno) =
		let
		    local
			extract = reduce cvt []
			    where
				cvt (Attribute i n) = \l.(i,n).l
-- TEMP FIX				cvt (Attribute i n) = ((i,n) .)
			    ||  cvt (Text $) = \x.x
		    in
			defs =
			    map
				(\n.
				n,
				(snd o split o filter ((n=) o fst))
				    (concmap extract (fst (split atts))))
				(count 0 (length rhs))
		    and
			expect =
			    assoc_sym nont sattr .
			    map (\s.assoc_sym s iattr) rhs
		    and
			getdiff (symno,are) shouldbe =
			    map
				(MissingAttribute prodno symno)
				(difference shouldbe are)
		    end
		in
		    conc (map2 getdiff defs expect)

end
