-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "attrtype.t"

export getattr;

-- getattribute : Extract two lists of symbol-attribute pairs for a grammar.
--  	    	  1 Inherited attributes.  A list of pairs where the first
--  	    	    is a symbol and the second a list of the corresponding
--  	    	    attributes.
--  	    	  2 Synthesized attributes.  Same organization as iattr.
--  	grammar : The productions
--    terminals : The terminals in this grammar.
-- nonterminals : The nonterminals in this grammar.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/attribute.m,v 1.1 88/04/19 17:04:49 pelle Exp $"
and
    getattr grammar terminals nonterminals =
	let
	    associate atts =
		map
		    (\s1.s1,(mkset o map snd o filter (\(s2,$).s1=s2) o conc) atts)
		    (nonterminals @ terminals)
	and
	    inherited, synthesized = split (map assocattr grammar)
		where
		assocattr (nont,syms,atts,$,$) =
		    let
			local
			    eq (n1,$) (n2,$) = n1 = n2
			and
			    less (n1,$) (n2,$) = n1 < n2
			and
			    rawdefined, rawused = split atts
			and
			    extract = reduce cvt []
			    where
				cvt (Attribute i n) = \l.((i,n) . l)	-- TEMP FIX
-- TEMP FIX		    	    cvt (Attribute i n) = ((i,n) .)
			    ||  cvt (Text $) = \x.x
			in rec
			    defined = mkset (concmap extract rawdefined)
			and
			    used = difference (mkset (concmap extract rawused)) defined
			and
			    groupattr =
				checkhd o group eq o sort less
				where
				    checkhd l =
					if ~ null l & fst (hd (hd l)) = 0 then l else [].l
			end
		    in
			let
			    defhd.deftl = groupattr defined
			and		
			    usehd.usetl = groupattr used
			and
			    translate = mapfst (\n.select (n+1) (nont.syms)) o conc
			in
			    translate (usehd.deftl), translate (defhd.usetl)
	in
	    associate inherited, associate synthesized

end
