(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Nov  2 21:55:34 1989 by muller         *)
(*      modified on Wed Jul  5 15:35:51 1989 by kalsow         *)

INTERFACE IntTable;

IMPORT List;

TYPE
  T <: REFANY;

PROCEDURE New (initialSize: CARDINAL := 64; maxChainLength: CARDINAL := 2): T
   RAISES {};
PROCEDURE Get (t: T; key: INTEGER; VAR value: REFANY): BOOLEAN;
PROCEDURE Put (t: T; key: INTEGER; value: REFANY): BOOLEAN RAISES {};

PROCEDURE Delete (t: T; key: INTEGER; VAR value: REFANY): BOOLEAN RAISES {};

PROCEDURE Clear( table: T ) RAISES {};
    (*
    Removes all entries from the table. *)
    
PROCEDURE Copy( table: T ): T RAISES {};
    (*
    Makes a copy of the table;  the keys and values themselves are
    not changed. *)

TYPE EnumerateProc = PROCEDURE(arg: REFANY; key: INTEGER; value: REFANY 
    ): BOOLEAN;
    (*
    An enumerate procedure is called by Enumerate on each key/value
    pair in the table.  The "arg" is the closure argument passed to
    Table.Enumerate.  The procedure returns false to continue the
    enumeration, true to halt it. *)

PROCEDURE Enumerate(
        table:   T;
        proc:    EnumerateProc;
        procArg: REFANY;
    VAR key:     INTEGER;
    VAR value:   REFANY
    ): BOOLEAN RAISES {};
    (*
    Invokes "proc" for each entry in the table.  If "proc" returns
    true, the enumeration is terminated, the terminating entry returned
    via "key" and "value", and true is returned.  If "proc" never
    returns true, "key" and "value" are set to nil, and false is
    returned. If the table is changed during enumeration, the
    results are undefined. *)
    
PROCEDURE ToValuesList( table: T ): List.T RAISES {};
    (*
    Returns a list of all the values in the table, in no particular
    order. *)
    
    
PROCEDURE ToAssocList( table: T ): List.T RAISES {};
    (*
    Returns an association list (see List.Assoc) of entries in the
    table, that is, a list of pairs (key value). *)

    
END IntTable.