(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Nov  2 18:28:30 1989 by muller         *)
(*      modified on Mon Oct  2 09:13:49 1989 by kalsow         *)
(*      modified on Tue Mar  3 18:14:23 PST 1987 by luca       *)

MODULE Axis;

PROCEDURE New (value: T): REF T =
  VAR r: REF T;
  BEGIN
    r := NEW (REF T);
    r^ := value;
    RETURN r;
  END New;

PROCEDURE NewArray (size: CARDINAL;  value: T := T.Hor): REF ARRAY OF T =
  VAR arr: REF ARRAY OF T;
  BEGIN
    arr := NEW (REF ARRAY OF T, size);
    (* Assumes the allocator initializes to Hor automatically: *)
    IF value # T.Hor THEN
      FOR i := 0 TO size - 1 DO arr[i] := value END
    END;
    RETURN arr
  END NewArray;

PROCEDURE UntracedNew (value: T): UNTRACED REF T =
  VAR r: UNTRACED REF T;
  BEGIN
    r := NEW (UNTRACED REF T);
    r^ := value;
    RETURN r;
  END UntracedNew;

PROCEDURE UntracedNewArray (size: CARDINAL; value: T := T.Hor):
                                                      UNTRACED REF ARRAY OF T =
  VAR arr: UNTRACED REF ARRAY OF T;
  BEGIN
    arr := NEW (UNTRACED REF ARRAY OF T, size);
    (* Assumes the allocator initializes to Hor automatically: *)
    IF value # T.Hor THEN
      FOR i := 0 TO size - 1 DO arr[i] := value END
    END;
    RETURN arr
  END UntracedNewArray;

PROCEDURE Compare (a, b: T): INTEGER =
  BEGIN
    RETURN ORD (a) - ORD (b);
  END Compare;

PROCEDURE Lt (a, b: T): BOOLEAN =
  BEGIN
    RETURN (a < b);
  END Lt;

PROCEDURE Eq (a, b: T): BOOLEAN =
  BEGIN
    RETURN (a = b);
  END Eq;

PROCEDURE Hash (a: T): INTEGER =
  BEGIN
    RETURN ORD (a);
  END Hash;

BEGIN
END Axis.
