(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by stolfi on Wed Aug 31 20:04:30 1988               *)
(* Last modified on Tue Jun  2 13:52:34 PDT 1992 by stolfi     *)
(*      modified on Tue Feb 11 21:39:46 PST 1992 by muller     *)


UNSAFE MODULE IntRGB;

IMPORT RGB;

CONST Scale = FLOAT (LAST (Intensity));

PROCEDURE FromReal (r: REAL): Intensity =
  BEGIN
    RETURN ROUND (Scale * MAX (0.0, MIN (1.0, r)))
  END FromReal;

PROCEDURE ToReal (i: Intensity): REAL =
  BEGIN
    RETURN FLOAT (i) / Scale
  END ToReal;

PROCEDURE FromRGB (rgb: RGB.T): T =
  BEGIN
    IF rgb = RGB.Undefined THEN
      RETURN Undefined
    ELSE
      RETURN T{
        filler := 0,
        defined := TRUE,
        r := ROUND (Scale * MAX (0.0, MIN (1.0, rgb[0]))),
        g := ROUND (Scale * MAX (0.0, MIN (1.0, rgb[1]))),
        b := ROUND (Scale * MAX (0.0, MIN (1.0, rgb[2])))
      }
    END;
  END FromRGB;

PROCEDURE ToRGB (irgb: T): RGB.T =
  BEGIN
    IF irgb.defined THEN
      RETURN RGB.T{
        FLOAT (irgb.r) / Scale,
        FLOAT (irgb.g) / Scale,
        FLOAT (irgb.b) / Scale
      }
    ELSE
      RETURN RGB.Undefined
    END
  END ToRGB;

PROCEDURE New (val: T): REF T =
  VAR r := NEW(REF T);
  BEGIN
    r^ := val;
    RETURN r
  END New;

PROCEDURE NewArray (size: CARDINAL; val: T := Undefined): REF ARRAY OF T =
  VAR r := NEW(REF ARRAY OF T, size);
  BEGIN
    FOR p := 0 TO size - 1 DO r[p] := val END;
    RETURN r
  END NewArray;

PROCEDURE ToBytes (x: T): Bytes = 
  BEGIN 
    RETURN LOOPHOLE (x, Bytes) 
  END ToBytes;

BEGIN
  <* ASSERT BITSIZE(T) MOD 8 = 0 *>    (* Assumed by ToBytes, Hash *)
END IntRGB.

