(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Revelation.def                                        *)
(* Last modified on Wed Feb  5 08:47:52 PST 1992 by kalsow     *)
(*      modified on Fri Feb 23 03:41:40 1990 by muller         *)


INTERFACE Revelation;

IMPORT String, Token, Type, Value, Decl;

TYPE
  Set <: ADDRESS;
  TypeList = REF RECORD  next: TypeList;  type: Type.T   END;

PROCEDURE NewSet  (): Set;
PROCEDURE Push    (s: Set): Set;
PROCEDURE Pop     (s: Set);
PROCEDURE SetName (s: Set;  name: String.T);

PROCEDURE Parse (READONLY fail: Token.Set; att: Decl.Attributes);

PROCEDURE Inherit (s: Set;  import: Value.T);

PROCEDURE TypeCheck (s: Set);

PROCEDURE Declare (s: Set);

PROCEDURE LookUp (key: Type.T): Type.T;

PROCEDURE LookUpAll (key: Type.T): TypeList;

PROCEDURE Initialize ();

END Revelation.
