(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Ident.i3                                              *)
(* Last Modified On Wed Apr 15 09:34:07 PDT 1992 By kalsow     *)

INTERFACE Ident;

IMPORT String, Token;

TYPE
  StringList  = REF ARRAY OF String.T;
  IntegerList = REF ARRAY OF INTEGER;

VAR
  stack  : StringList  := NIL;
  offset : IntegerList := NIL;
  top    : INTEGER := 0; (* points to the first empty stack element *)

PROCEDURE ParseList (READONLY fail: Token.Set): INTEGER;
(* returns the number of ids in the list *)

PROCEDURE Reset ();

END Ident.
