(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: NamedType.i3                                          *)
(* Last Modified On Thu Jun 20 01:09:50 1991 By kalsow         *)
(*      Modified On Sat Aug 18 00:03:50 1990 By muller         *)

INTERFACE NamedType;

IMPORT Type, Token, String, Value;

PROCEDURE Parse (READONLY fail: Token.Set): Type.T;

PROCEDURE New (t: Type.T): Type.T;
PROCEDURE Create (m, n: String.T): Type.T;

PROCEDURE Split (t: Type.T;  VAR name: String.QID): BOOLEAN;
PROCEDURE SplitV (t: Type.T;  VAR v: Value.T): BOOLEAN;

END NamedType.
