/*
 * itemid.c --
 *	POSTGRES standard buffer page item identifier (line table) code.
 */

#include "tmp/c.h"

#include "storage/item.h"
#include "storage/buf.h"
#include "storage/bufmgr.h"
#include "storage/itemid.h"

RcsId("$Header: RCS/itemid.c,v 1.6 91/04/28 09:14:37 cimarron Exp $");

/* 
 *	ItemIdIsValid is now a macro in itemid.h -cim 4/27/91
 */

bool
ItemIdIsUsed(itemId)
	ItemId	itemId;
{
	Assert(ItemIdIsValid(itemId));

	return ((bool)((itemId->lp_flags & LP_USED) != 0));
}

bool
ItemIdIsContinuation(itemId)
	ItemId	itemId;
{
	Assert(ItemIdIsValid(itemId));

	return ((bool)((itemId->lp_flags & LP_CTUP) != 0));
}

bool
ItemIdIsInternal(itemId)
	ItemId	itemId;
{
	Assert(ItemIdIsValid(itemId));

	return ((bool)((itemId->lp_flags & LP_ISINDEX) != 0));
}

bool
ItemIdIsLock(itemId)
	ItemId	itemId;
{
	Assert(ItemIdIsValid(itemId));

	return ((bool)((itemId->lp_flags & LP_LOCK) != 0));
}

bool
ItemIdIsContinuing(itemId)
	ItemId	itemId;
{
	Assert(ItemIdIsValid(itemId));

	return ((bool)((itemId->lp_flags & LP_DOCNT) != 0));
}
