/*
 * tim.h --
 *	POSTGRES time definitions.
 */

#ifndef	TimIncluded		/* Include this file only once */
#define TimIncluded	1

/*
 * Identification:
 */
#define TIM_H	"$Header: RCS/tim.h,v 1.8 90/08/17 08:54:58 cimarron Exp $"

#include "tmp/c.h"

typedef uint32	AbsoluteTime;

#define InvalidAbsoluteTime	0

typedef uint32	RelativeTime;

#define InvalidRelativeTime	0

typedef uint32	Time;		/* XXX this will disappear */

#define InvalidTime	0	/* XXX this will disappear */

/*
 * XXX INVALID_ABSTIME from adt/date.h.
 * XXX access/tim and adt/date should be merged somehow.
 */
#ifndef	INVALID_ABSTIME
#define INVALID_ABSTIME	2147483647
#endif	/* !defined(INVALID_ABSTIME) */

/*
 * AbsoluteTimeIsValid --
 *	True iff absolute time is valid.
 */
extern
bool
AbsoluteTimeIsValid ARGS((
	AbsoluteTime	time
));

/*
 * RelativeTimeIsValid --
 *	True iff relative time is valid.
 */
extern
bool
RelativeTimeIsValid ARGS((
	AbsoluteTime	time
));

/*
 * GetCurrentAbsoluteTime --
 *	Returns the current absolute time.
 */
AbsoluteTime
GetCurrentAbsoluteTime ARGS((
	void
));

/*
 * AbsoluteTimeIsBefore --
 *	True iff an absolute time is before or the same as another.
 *
 * Note:
 *	Assumes absolute times are valid.
 */
bool
AbsoluteTimeIsBefore ARGS((
	AbsoluteTime	time1,
	AbsoluteTime	time2
));

/*
 * AbsoluteTimeIsAfter --
 *	True iff an absolute time is strictly after another.
 *
 * Note:
 *	Assumes absolute times are valid.
 */
bool
AbsoluteTimeIsAfter ARGS((
	AbsoluteTime	time1,
	AbsoluteTime	time2
));

#endif	/* !defined(TimIncluded) */
